;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Define the interrupt page offsets
;

IPAGE_SEG SEGMENT AT 0

	ORG	0
  INT_ZERO	LABEL DWORD

;  Hardware defined interrupts

	ORG	4*0
  INT_DIV	LABEL DWORD		; Divide error
	ORG	4*1
  INT_STEP	LABEL DWORD		; Single step
	ORG	4*2
  INT_NMI	LABEL DWORD		; Non-maskable interrupt
	ORG	4*3
  INT_BRK	LABEL DWORD		; Breakpoint
	ORG	4*4
  INT_OVFL	LABEL DWORD		; Overflow error
 
;	Print Screen Emulation

   INT_PRSCA	= 5			; Interrupt 5 for print screen

	ORG	4*INT_PRSCA
   INT_PRSC	LABEL DWORD		; Print screen

;	Vertical sync interrupt

  INT_VSYNA	=	0AH		; VSYNC interrupt number

	ORG	4*INT_VSYNA
  INT_VSYN	LABEL DWORD

;  MS-DOS defined interrupts

	ORG	4*DOSI_TERM
  INT_TERM	LABEL DWORD		; Terminate program function
	ORG	4*DOSI_FUNC
  INT_FUNC	LABEL DWORD		; Perform function
	ORG	4*DOSI_TADDR
  INT_TADDR	LABEL DWORD		; Resume addr on program termination
	ORG	4*DOSI_CADDR
  INT_CADDR	LABEL DWORD		; ^C handler
	ORG	4*DOSI_FERADDR
  INT_FERADDR	LABEL DWORD		; Fatal error handler
	ORG	4*DOSI_ADREAD
  INT_ADREAD	LABEL DWORD		; Absolute disk read
	ORG	4*DOSI_ADWRITE
  INT_ADWRITE	LABEL DWORD		; Absolute disk write
	ORG	4*DOSI_TERMR
  INT_TERMR	LABEL DWORD		; Terminate but stay resident


; BIOS generated software interrupts

BIOSAI		=	50H		; Base of user interrupts

	ORG	4*(BIOSAI+0)
INT_UKB		LABEL	DWORD			; User keyboard interrupt
INT_UKBA	=	BIOSAI+0

	ORG	4*(BIOSAI+1)
INT_UTM		LABEL	DWORD			; User timer interrupt
INT_UTMA	=	BIOSAI+1

	ORG	4*(BIOSAI+2)
INT_USAI	LABEL	DWORD			; Users serial A interrupts
INT_USAIA	=	BIOSAI+2

	ORG	4*(BIOSAI+3)
INT_USBI	LABEL	DWORD			; User serial B interrupt
INT_USBIA	=	BIOSAI+3

	ORG	4*(BIOSAI+4)
INT_ULP		LABEL	DWORD			; User light pen interrupt
INT_ULPA	=	BIOSAI+4

	ORG	4*(BIOSAI+5)
INT_UCRT	LABEL	DWORD			; User keyboard output
INT_UCRTA	=	BIOSAI+5

	ORG	4*(BIOSAI+6)
INT_USAO	LABEL	DWORD			; Serial A output
INT_USAOA	=	BIOSAI+6

	ORG	4*(BIOSAI+7)
INT_USBO	LABEL	DWORD			; Serial B output
INT_USBOA	=	BIOSAI+7

	ORG	4*(BIOSAI+8)
INT_EVN		LABEL	DWORD			; Event interrupt
INT_EVNA	=	BIOSAI+8

	ORG	4*(BIOSAI+9)
INT_NET		LABEL	DWORD			; RESERVED
INT_NETA	=	BIOSAI+9

	ORG	4*(BIOSAI+10)
INT_UVSYN	LABEL	DWORD
INT_UVSYNA	=	BIOSAI+10		; Vertical Sync

	ORG	4*(BIOSAI+11)
INT_UMAX	=	BIOSAI+11
IPAGE_SEG ENDS

