	TITLE	SS AND SCLK
	PAGE	,132

;	SCREEN SAVER AND SCREEN CLOCK COMBINED
;
;	THIS PROGRAM COMBINES THE SCREEN SAVER AND SCREEN CLOCK
;	PROGRAMS
;
;	SSCK is short for screen saver with clock. This program is
;	invoked by typing
;
;	  SSCK xx		to install with screen timeout of xx
;	  SSCK CO		to turn the clock off
;	  SSCK CI		to turn the clock on
;	  SSCK Txx		to adjust screen timeout to xx
;
;	where xx is one or two digits represting the time in minutes
;	from no keyboard or screen inactivity to when the screen is
;	blanked.  The time specified can range from 0 to 60 minutes.
;	A time of 0 disables screen saver.

ssaver	segment
	assume	cs:ssaver, ds:ssaver, ss:ssaver, es:ssaver

keyint		equ	9h			;keyboard activity interrupt
scrnint		equ	10h			;video activity interrupt
timerint	equ	1ch			;timer interrupt tick
cr		equ	0dh
lf		equ	0ah
bel		equ	7
screen_size	equ	16 * 1024

;	SCRNCLK V 2 -- SCREEN CLOCK FOR MS-DOS (Z-100 PC)
;
;	THIS PROGRAM PROVIDES A SCREEN CLOCK FOR MS-DOS THAT
;	IS DISPLAYED IN THE UPPER RIGHT CORNER OF THE SCREEN.
;
;	THE COLOR OF THE DISPLAYED CLOCK IS DETERMINED BY THE
;	VARIABLES FGCOL AND BGCOL.  COLORS IN EGA GRAPHIC MODES
;	MAY BE DIFFERENT.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  23-MAY-86  21-APR-87

;	DEFINITIONS

BLACK	EQU	0			;COLOR CONTROL BITS
BLUE	EQU	001B
GREEN	EQU	010B
CYAN	EQU	011B
RED	EQU	100B
MAGENTA	EQU	101B
YELLOW	EQU	110B			;(IBM CALLS IT BROWN)
WHITE	EQU	111B

;	WE ASSUME 65543 TICKS PER HOUR.  EVERYTHING IS MULTIPLIED
;	BY 5 FOR GREATER ACCURACY WITHIN THE LIMITS OF INTEGER
;	ARITHMETIC.

TPHH	EQU	5			;TICKS/HOUR * 5 HIGH
TPHL	EQU	23H			;TICKS/HOUR * 5 LOW
TPM	EQU	5462			;TICKS/MINUTE * 5
TPS	EQU	91			;TICKS/SECOND * 5

SCRINT	EQU	10H			;SCREEN CONTROL INTERRUPT
SCP	EQU	2			;SET CURSOR POSITION
GCP	EQU	3			;GET CURSOR POSITION
WCHAR	EQU	9			;WRITE CHARACTER
GVS	EQU	15			;GET VIDEO STATE
TIMEINT	EQU	1CH*4			;Z-150 TIMER INTERRUPT VECTOR
SYSINT	EQU	21H*4			;MS-DOS SYSTEM INTERRUPT
VIDCON	EQU	3D4H			;VIDEO CONTROL PORT
MONCON	EQU	3B4H			;MONOCHROME CONTROL PORT
CURH	EQU	0EH			;CURSOR HIGH REGISTER
CURL	EQU	0FH			;CURSOR LOW REGISTER

JMPF	MACRO
	DB	0EAH			;DEFINE FAR JUMP
	ENDM

	org	0
zero	label	near

	org	5ch
def_fcb	label	near

	ORG	6CH
TIMERL	LABEL	WORD			;DEFINE TIMER LOW
	ORG	6EH
TIMERH	LABEL	WORD			;DEFINE TIMER HIGH

	org	100h
;TERMINATE AND STAY RESIDENT CODE STARTS HERE
;
start:
	jmp	setup				;jump around our tsr stuff

;	CLOCK DATA AREA

FGCOL	DB	GREEN			;FOREGROUND COLOR
BGCOL	DB	BLACK			;BACKGROUND COLOR
ROW	DB	0			;CLOCK ROW
CLKFLG	DB	1			;CLOCK ON/OFF FLAG
SKCNT	DB	0			;SKIP COUNTER
HOU	DB	0			;BINARY HOUR
MIN	DB	0			;BINARY MINUTE
OLDSEC	DB	0			;OLD SECOND
CPOS	DW	0			;CURSOR POSITION
PCPOS	DW	0			;PORT CURSOR POSITION
CURTYP	DW	0			;CURSOR TYPE
CMODE	DB	0			;CURRENT VIDEO MODE
TIMSTR	DB	' '			;SPACE BEFORE TIME
HOUR	DW	0			;HOUR (ASCII)
	DB	':'
MINUTE	DW	0			;MINUTE
	DB	':'
SECOND	DW	0			;SECOND
	DB	' '			;TRAILING SPACE

;	PROCESS CLOCK INTERRUPTS HERE

MYTIME:	PUSH	AX
	CMP	CS:BYTE PTR scrn_on,0	;SCREEN ON?
	JZ	TIMEXIT			;IF NOT, EXIT

;	FOR 1 CHECK PER 4 TICKS, USE THESE LINES

;	MOV	AL,CS:SKCNT		;GET SKIP COUNT
;	INC	AL			;ADD 1
;	AND	AL,3			;MOD 4
;	MOV	CS:SKCNT,AL		;SAVE NEW COUNT

;	FOR 1 CHECK PER 2 TICKS, USE THIS LINE

	XOR	CS:SKCNT,1		;TIME TO CHECK?

	JNZ	TIMEXIT			;NOT TIME TO CHECK
	CMP	CS:CLKFLG,0		;CLOCK ENABLED?
	JNZ	CHTIME			;IF SO, CHECK TIME
TIMEXIT:POP	AX
	JMP	timer_sr		;CHECK SCREEN

;	CHECK TIME, SEE IF A SECOND HAS PASSED

CHTIME:	MOV	CS:CLKFLG,0		;DISABLE OTHER CLOCK INTERRUPTS
	STI
	PUSH	BX			;SAVE REGISTERS
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	MOV	AX,40H			;BIOS RAM SEGMENT
	MOV	DS,AX
	MOV	AX,TIMERL		;GET TIMER LOW
	MOV	DX,TIMERH		;AND TIMER HIGH
	MOV	BX,AX
	MOV	CX,DX			;TIMER IN CX,BX
	SHL	AX,1			;MPY TIMER * 5
	RCL	DX,1			;* 2
	SHL	AX,1
	RCL	DX,1			;* 4
	ADD	AX,BX
	ADC	DX,CX			;* 5
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	BX,TPHH			;GET TICKS/HOUR * 5 HIGH
	MOV	CX,TPHL			;AND TICKS/HOUR * 5 LOW
	MOV	SI,-1			;SET A COUNTER
DIVLP:	INC	SI			;DIVIDE TICKS BY TICKS/HOUR
	SUB	AX,CX
	SBB	DX,BX
	JNB	DIVLP
	ADD	AX,CX
	ADC	DX,BX			;DX,AX = REMAINDER
	MOV	WORD PTR HOU,SI		;SAVE HOUR
	MOV	CX,TPM
	DIV	CX			;DIV BY TICKS/MINUTE * 5
	MOV	MIN,AL			;SAVE RESULT
	MOV	AX,DX			;GET REMAINDER
	MOV	CL,TPS
	DIV	CL			;DIV BY TICKS/SECOND * 5
	CMP	AL,OLDSEC		;HAS A SECOND PASSED?
	JNZ	UPDATE
	JMP	NOUPD			;IF NOT, EXIT

;	A SECOND HAS PASSED, PRINT TIME ON THE SCREEN

UPDATE:	CLD				;ENSURE FORWARD DIRECTION
	MOV	OLDSEC,AL		;UPDATE OLD SECOND
	CMP	AL,60			;INTEGER MATH ERROR?
	JNZ	NERR			;NO
	DEC	AL			;ELSE, CORRECT
NERR:	CALL	CONASC			;CONVERT SECONDS TO ASCII
	MOV	SECOND,AX		;RESULT TO BUFFER
	MOV	AL,MIN			;GET MINUTES
	CALL	CONASC			;CONVERT TO ASCII
	MOV	MINUTE,AX		;RESULT TO BUFFER
	MOV	AL,HOU			;GET HOURS
	CALL	CONASC			;CONVERT TO ASCII
	MOV	HOUR,AX			;RESULT TO BUFFER
	MOV	AH,GVS
	CALL	SCROUT			;GET VIDEO STATE
	MOV	CMODE,AL		;SAVE MODE
	MOV	DH,ROW			;GET ROW FOR CLOCK
	SUB	AH,10			;SUBTRACT CLOCK WIDTH FROM COLUMNS
	MOV	DL,AH			;SAVE AS STARTING COLUMN
	PUSH	DX
	MOV	AH,GCP
	CALL	SCROUT			;GET CURSOR POSITION
	MOV	CPOS,DX			;SAVE IT
	MOV	DX,VIDCON		;ASSUME TEXT MODE, GET VIDEO PORT
	CMP	CMODE,3			;CHECK FOR TEXT MODE
	JBE	PTIMTM			;IT IS
	CMP	CMODE,7			;CHECK FOR MONOCHROME MODE
	JNZ	PTIME0			;IT'S NOT
	MOV	DX,MONCON		;GET MONOCHROME PORT
	CMP	CX,607H			;CGA-TYPE CURSOR?
	JNZ	PTIMTM			;NO
	MOV	CX,0B0CH		;ELSE, REPLACE WITH MONOCHROME CURSOR
PTIMTM:	MOV	CURTYP,CX		;SAVE IT
	MOV	AL,CURH
	OUT	DX,AL			;ADDRESS CURSOR HIGH REGISTER
	INC	DX			;MOVE TO DATA PORT
	IN	AL,DX			;GET CURSOR HIGH
	MOV	AH,AL
	DEC	DX
	MOV	AL,CURL
	OUT	DX,AL			;ADDRESS CURSOR LOW REGISTER
	INC	DX
	IN	AL,DX			;GET CURSOR LOW
	MOV	PCPOS,AX		;SAVE PORT CURSOR POSITION
	MOV	AH,1
	MOV	CX,2020H
	CALL	SCROUT			;TURN CURSOR OFF
PTIME0:	POP	DX
	MOV	AH,SCP
	CALL	SCROUT			;SET CURSOR TO TIME AREA
	MOV	CX,10			;SET A COUNTER
	MOV	BL,BGCOL		;GET BACKGROUND COLOR
	SHL	BL,1			;ROTATE TO HIGHER NIBBLE
	SHL	BL,1
	SHL	BL,1
	SHL	BL,1
	OR	BL,FGCOL		;ADD IN FOREGROUND COLOR
	CMP	CMODE,6			;MODE 6?
	JNZ	PTIME1			;NO
	MOV	BL,1			;ELSE, COLOR IS 1
PTIME1:	MOV	SI,OFFSET TIMSTR	;POINT TO TIME STRING
PTMLP:	LODSB				;GET A DIGIT
	PUSH	CX			;SAVE COUNTER
	PUSH	SI			;SAVE POINTER
	CALL	PDIGIT			;PRINT DIGIT
	POP	SI
	POP	CX
	LOOP	PTMLP			;LOOP UNTIL DONE
PDONE:	MOV	AH,SCP
	MOV	DX,CPOS
	CALL	SCROUT			;RESTORE CUSOR TO USER'S POSITION
	MOV	DX,VIDCON		;ASSUME TEXT MODE, GET VIDEO PORT
	CMP	CMODE,3			;TEXT MODE?
	JBE	PDONTM			;YES
	CMP	CMODE,7			;MONOCHROME?
	JNZ	NOUPD			;IF NOT, DONE
	MOV	DX,MONCON		;ELSE, GET MONOCHROME PORT
PDONTM:	MOV	CX,CURTYP		;ELSE, GET CURSOR TYPE
	MOV	AH,1
	CALL	SCROUT			;RESTORE IT
	MOV	BX,PCPOS		;GET PORT CURSOR POSITION
	MOV	AL,CURH
	OUT	DX,AL			;ADDRESS CURSOR HIGH REGISTER
	INC	DX			;MOVE TO DATA PORT
	MOV	AL,BH
	OUT	DX,AL			;RESTOR CURSOR HIGH
	DEC	DX
	MOV	AL,CURL
	OUT	DX,AL			;ADDRESS CURSOR LOW REGISTER
	INC	DX
	MOV	AL,BL
	OUT	DX,AL			;RESTORE CURSOR LOW
NOUPD:	POP	ES
	POP	DS			;RESTORE REGISTERS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	MOV	CS:CLKFLG,1		;RE-ENABLE CLOCK
	POP	AX
	JMP	timer_sr		;AND EXIT

;	CONVERT NUMBER IN AL TO ASCII DIGITS IN AL, AH

CONASC:	MOV	AH,0			;CLEAR AH
	MOV	BH,10			;GET RADIX
	DIV	BH			;DIVIDE BY IT
	ADD	AX,'00'			;ADD ASCII
	RET

;	PRINT A DIGIT ON THE SCREEN

PDIGIT:	MOV	AH,WCHAR
	MOV	CX,1
	CALL	SCROUT			;WRITE CHARACTER
	MOV	AH,GCP
	CALL	SCROUT			;GET CURSOR POSITION
	INC	DL			;MOV IT OVER
	MOV	AH,SCP
	CALL	SCROUT			;SET NEW CURSOR POSITION
	RET

;	LOCAL SYSTEM INTERRUPT PROCESSOR

MYSYS:	CMP	AH,0F2H			;CLOCK PROCESS CODE?
	JZ	CLKSYS			;YES
	JMPF				;ELSE, EXIT
SYSADR	DW	0,0
CLKSYS:	CMP	AL,2			;CLOCK CONTROL?
	JB	CLKCON			;YES
	MOV	CS:WORD PTR TIME,BX	;ELSE, SET TIME
	MOV	CS:WORD PTR COUNT,BX	;AND COUNT
	IRET
CLKCON:	MOV	CS:CLKFLG,AL		;SET CLOCK CONDITION
	IRET

;	DO VIDEO OUTPUT WITHOUT TRIGGERING SCREEN SAVER

SCROUT:	pushf
	call	cs:dword ptr scrnvec
	RET


signature	db	"SSCK"			;signature

key_activity_sr:
	push	ax
	mov	ax,cs:word ptr time		;reset the counter
	mov	cs:word ptr count,ax
	cmp	cs:scrn_on,0ffh			;is the screen visible?
	je	kas2
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	call	restore_screen			;restore the screen and
	call	restore_cur			;the cursor
kas1:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
kas2:
	pop	ax
	jmp	cs:dword ptr keyvec


scrn_activity_sr:
	cmp	ah,3
	je	sas3
	cmp	ah,4
	je	sas3
	cmp	ah,8
	je	sas3
	cmp	ah,13
	je	sas3
	cmp	ah,15
	je	sas3
	push	ax
	mov	ax,cs:word ptr time		;reset the
	mov	cs:word ptr count,ax		;counter with time
	cmp	cs:byte ptr scrn_on,0ffh	;is the screen on or off
	je	sas2
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	call	restore_screen			;if off, then restore it
	mov	ah,2
	mov	dx,cs:word ptr cur_col		;restore the
	mov	bh,cs:byte ptr video_page	;    cursor
	cli
	pushf
	call	cs:dword ptr scrnvec
	mov	ah,1
	mov	cx,cs:word ptr cur_end		;and its
	cli					;    shape
	pushf
	call	cs:dword ptr scrnvec
sas1:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
sas2:
	pop	ax
sas3:
	jmp	cs:dword ptr scrnvec


timer_sr:
	cmp	cs:word ptr time,0		;screen saver off?
	jnz	timer_sr1			;no
	jmp	cs:dword ptr timervec		;else, exit
timer_sr1:
	cld
	cmp	cs:byte ptr scrn_on,0ffh
	je	screen_is_on
	jmp	screen_is_off

screen_is_on:
	dec	cs:word ptr count		;bump the count if screen is on
	jz	sion1				;time to turn it off?
	jmp	cs:dword ptr timervec
sion1:
	push	ax
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	sti					;yup
	mov	ah,0fh
	int	10h				;get current video mode
	cli
	mov	cs:byte ptr video_mode,al	;and save it all
	mov	cs:byte ptr chars_pl,ah
	mov	cs:byte ptr video_page,bh
	cmp	al,4				;assure text mode only
	jc	sion2
	cmp	al,6				;hi res mono graphics ok too
	je	sion2
	cmp	al,7				;monochrome is ok too
	je	sion2
	jmp	ts2
sion2:
	call	get_cursor
	cmp	cs:byte ptr video_mode,7
	je	clear7
	mov	ax,0b800h
	mov	ds,ax
	mov	si,0				;  the
	mov	ax,cs
	mov	es,ax				;     old
	mov	di,offset old_screen
	mov	cx,screen_size/2		;       video
	rep movsw				;          screen
	mov	ax,0b800h
	mov	es,ax				;then
	mov	di,0
	mov	ax,0720h			;spaces for text
	cmp	cs:byte ptr video_mode,6
	jne	clear0
	mov	ax,0				;zeros for graphics
clear0:
	mov	cx,screen_size/2		;clear
	rep stosw
	jmp	clear_cur
clear7:
	mov	ax,0b000h
	mov	ds,ax
	mov	si,0
	mov	ax,cs
	mov	es,ax
	mov	di,offset old_screen
	mov	cx,screen_size/8
	rep movsw
	mov	ax,0b000h
	mov	es,ax
	mov	di,0
	mov	ax,0720h
	mov	cx,screen_size/8
	rep stosw
clear_cur:
	sti
	mov	ah,1
	mov	ch,20h				;make the cursor dissappear
	int	10h
	cli
	mov	cs:byte ptr scrn_on,0		;say the screen is off
	jmp	ts2

screen_is_off:
	dec	cs:byte ptr scan_count
	jz	siof1
	jmp	cs:dword ptr timervec
siof1:
	push	ax
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	si
	push	di
	mov	cs:byte ptr scan_count,18	;reset the timer to 1 second
	mov	ax,cs
	mov	bx,offset old_screen		;get our saved screen buffer
	mov	cl,4
	shr	bx,cl
	add	ax,bx				;make it cs:0
	mov	ds,ax
	mov	si,0
	mov	ax,0b800h			;get the regurlar screen seg.
	mov	cx,screen_size/2		;and how many words
	cmp	cs:byte ptr video_mode,7	;monochrome card?
	jne	siof2				;nope
	mov	ax,0b000h			;yup, so get its seg.
	mov	cx,screen_size/8		;and how many words
siof2:
	mov	es,ax				;video ram = es:0
	mov	di,0
	mov	ax,0720h			;what to check for when we scan
	cmp	cs:byte ptr video_mode,6	;hi res mono graphics mode?
	jne	siof3				;nope
	mov	ax,0				;yup, then check for zeros
siof3:
	cli
	mov	cs:byte ptr upd_scrn,0		;restore the screen flag
siof4:
	repz scasw				;start comparing
	jz	siof5				;if everything was equal
	sub	di,2				;back up to inequality
	mov	si,di				;same place in our buffer
	mov	bx,es:word ptr[di]		;get the word
	mov	ds:word ptr[si],bx		;update our buffer
	add	di,2				;put back
	mov	cs:byte ptr upd_scrn,0ffh	;flag to put back the screen
	jmp	short siof4			;check the rest of video
siof5:
	cmp	cs:byte ptr upd_scrn,0		;should we update memory
	je	ts2
	call	restore_screen
	call	restore_cur

ts2:
	mov	ax,cs:word ptr time
	mov	cs:word ptr count,ax		;no point in checking again
ts3:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	jmp	cs:dword ptr timervec

restore_screen:
	cmp	cs:byte ptr video_mode,7
	je	restore7
	mov	ax,0b800h			;restore
	mov	es,ax
	mov	di,0				;  the
	mov	ax,cs
	mov	ds,ax				;    old
	mov	si,offset old_screen
	mov	cx,screen_size/2		;      video
	rep movsw				;         ram
	jmp	short restore9
restore7:
	mov	ax,0b000h
	mov	es,ax
	mov	di,0
	mov	ax,cs
	mov	ds,ax
	mov	si,offset old_screen
	mov	cx,screen_size/8
	rep movsw
restore9:
	mov	cs:byte ptr scrn_on,0ffh
	ret

restore_cur:
	mov	ah,2
	mov	dx,cs:word ptr cur_col		;resture the
	sti
	mov	bh,cs:byte ptr video_page	;    cursor
	int	10h				;      position
	mov	ah,1
	mov	cx,cs:word ptr cur_end		;and its
	int	10h				;     size
	cli
	ret

get_cursor:
	sti
	mov	ah,3
	mov	bh,cs:byte ptr video_page
	int	10h				;get cursor info
	cli
	mov	cs:word ptr cur_end,cx		;and save it all
	mov	cs:word ptr cur_col,dx
	ret


time		dw	0			;timeout value = 18*60*minutes
count		dw	0			;present count down value
keyvec		dd	0
scrnvec		dd	0
timervec	dd	0
scrn_on		dw	0ffh			;screen on = 0ffh off = 0
video_mode	db	0
chars_pl	db	0
video_page	db	0
cur_end		db	0
cur_start	db	0
cur_col		db	0
cur_row		db	0
scan_count	db	18
upd_scrn	db	0

		db	(($-zero)/16*16)+16-($-zero) dup (0)
old_screen:
buff	struc
	db	16 * 1024 dup(?)	;where to save our screen ram
tsr	db	?
buff	ends
;
;TERMINATE AND STAY RESIDENT CODE ENDS HERE

CLOCK:	INC	SI
	MOV	AH,0F2H			;GET CONTROL FUNCTION
	LODSB				;GET NEXT ENTRY
	MOV	BL,0			;ASSUME OFF
	CMP	AL,'O'			;OFF?
	JZ	SETCLK			;YES
	INC	BL			;ASSUME ON
	CMP	AL,'I'			;ON?
	JNZ	USAGE			;USAGE ERROR
SETCLK:	MOV	AL,BL			;GET OFF/ON CODE
	INT	21H			;SET CLOCK CONDITION
	INT	20H			;AND EXIT

STIME:	INC	SI
	CALL	GETNUM			;GET TIMEOUT VALUE
	JC	USAGE			;NUMBER TOO BIG
	MOV	BX,AX			;NUMBER TO BX
	MOV	AX,0F202H		;GET CONTROL CODE
	INT	21H			;SET TIMEOUT VALUE
	INT	20H			;EXIT

setup:
	CLD
	mov	SI,offset def_fcb+1
	mov	al,[SI]
	CMP	AL,'C'			;CLOCK CONTROL?
	JZ	CLOCK			;YES
	CMP	AL,'T'			;SET TIMEOUT?
	JZ	STIME			;YES
	mov	dx,offset msg1
	mov	ah,9
	int	21h
	CMP	AL,' '			;ANY ENTRY?
	JZ	USAGE			;IF NOT, EXPLAIN
	CMP	AL,'9'+1		;NUMBER?
	JB	NUMBER			;YES
usage:
	mov	dx,offset msg2
usage1:
	mov	ah,9
	int	21h
	int	20h
NUMBER:
	CALL	GETNUM			;GET TIMEOUT VALUE
	JC	USAGE			;ILLEGAL NUMBER
	mov	word ptr time,ax		;save his time out value
	mov	word ptr count,ax
	mov	word ptr scan_count,18		;scan memory every second
	
	mov	al,keyint
	mov	ah,35h				;get interrupt vector
	int	21h
	mov	di,bx
	sub	di,5				;point to the signature
	mov	si,offset signature
	mov	cx,4
	repz cmpsb
	jnz	su5
	mov	dx,offset msg4
	jmp	usage1
su5:
	mov	word ptr keyvec,bx		;save it
	mov	word ptr keyvec+2,es
	mov	dx,offset key_activity_sr
	mov	al,keyint
	mov	ah,25h				;set new interrupt vector
	int	21h

	mov	al,scrnint
	mov	ah,35h
	int	21h
	mov	word ptr scrnvec,bx
	mov	word ptr scrnvec+2,es
	mov	dx,offset scrn_activity_sr
	mov	al,scrnint
	mov	ah,25h
	int	21h

	mov	al,timerint			;and finally the timer
	mov	ah,35h
	int	21h
	mov	cs:word ptr timervec,bx
	mov	cs:word ptr timervec+2,es
	mov	dx,offset MYTIME
	mov	al,timerint
	mov	ah,25h
	int	21h

	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	AX,CS
	MOV	ES,AX			;PUT ES HERE
	MOV	SI,OFFSET SYSINT	;POINT TO SYSTEM INTERRUPT
	MOV	DI,OFFSET SYSADR	;PUT IT HERE
	PUSH	SI
	CLD
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET MYSYS	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS

	mov	dx,offset msg3
	mov	ah,9
	int	21h
	
	lea	dx,old_screen.tsr
	int	27h

;	CONVERT ASCII NUMBER AT [SI] TO BINARY NUMBER IN AL
;	RETURNS NUMBER * 60 * 18 IN AX

GETNUM:	MOV	CX,2			;ALLOW 2 DIGITS MAX
	MOV	BL,0			;CLEAR AN ACCUMULATOR
	MOV	BH,10			;GET A MULTIPLIER
GETNUM1:LODSB				;GET A CHARACTER
	SUB	AL,'0'			;REMOVE ASCII
	JC	GOTNUM			;BAD CHAR, END OF ENTRY
	CMP	AL,10			;MORE THAN 9?
	JNB	GOTNUM			;IF SO, END OF ENTRY
	XCHG	BL,AL			;ACC. TO AL
	MUL	BH			;MULTIPLY PREV. DIGIT BY 10
	XCHG	BL,AL			;BACK TO BL
	ADD	BL,AL			;ADD IN LATEST DIGIT
	LOOP	GETNUM1			;LOOP UNTIL DONE
GOTNUM:	CMP	CX,2			;ANY CONVERSION DONE?
	JNB	BADNUM			;NO
	MOV	AL,BL			;NUMBER TO AL
	mov	ah,0
	mov	bx,60*18		;second/min * ticks/seconds
	mul	bx
	RET				;CY SET IF NUMBER TOO BIG
BADNUM:	CMC				;SET CY ON BAD ENTRY
	RET

msg1	db	cr,lf,'Screen Saver/Screen Clock Version 1.0',cr,lf,lf,'$'
msg2	db	'To use this program, enter',cr,lf,lf
	db	'  SSCK xx		to install with timeout of xx',cr,lf
	db	'  SSCK Txx		to set timeout to xx after'
	db	' installation',cr,lf
	db	'  SSCK CO		to turn the screen clock off',cr,lf
	db	'  SSCK CI		to turn the screen clock on',cr,lf,lf
	db	'where xx is the screen saver timeout value in minutes.',cr,lf
	db	'The value can be 0 to 60.  A value of 0 disables the',cr,lf
	db	'screen saver.',cr,lf,'$'
msg3	db	'SSCK is now installed.',cr,lf,'$'
msg4	db	bel,cr,lf,'SSCK was previously installed.',cr,lf,'$'
	db	"Copyright (C) 1986 by Heath/Zenith Users' Group"
	db	"Written By: Jim Buszkiewicz and Pat Swayne"
ssaver	ends
	end	start
