	PAGE	,132
;	CHARACTER SCREEN DUMP PROGRAM
;
;	THIS PROGRAM WORKS WITH AN EXISTING GRAPHIC SCREEN DUMP
;	PROGRAM TO PROVIDE A COMPLETE SCREEN DUMP IN TEXT MODES,
;	INCLUDING GRAPHIC CHARACTERS.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  26-MAR-86
;
;	COPYRIGHT (C) 1986 BY HEATH/ZENITH USERS' GROUP

;	DEFINITIONS

PSCINT	EQU	5*4			;PRINT SCREEN INTERRUPT VECTOR
GCHRVEC	EQU	1FH*4			;GRAPHIC CHARACTER VECTOR
BCPOS	EQU	50H			;BIOS CURSOR POSITON OFFSET

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	JMP	SETUP			;SET UP PROGRAM

INT5VEC	DW	0,0			;STORE INT 5 VECTOR HERE
CPOS	DW	8 DUP (0)		;SAVED CURSOR POSITIONS
CTYPE	DW	0			;SAVED CURSOR TYPE
CPL	DB	0			;CHARACTERS/LINE

;	GRAPHIC CHARACTER TABLE -- PROVIDES TEXT MODE GRAPHICS
;	IN GRAPHIC MODES

GCHRTBL	DB	07EH,0C3H,0D8H,0DBH,07EH,018H,018H,01FH		;80H
	DB	066H,00H,00H,066H,066H,066H,03BH,00H
	DB	07H,00H,03CH,066H,07EH,060H,03CH,00H
	DB	07EH,0C3H,03CH,06H,03EH,066H,03BH,00H
	DB	036H,00H,03CH,06H,03EH,066H,03BH,00H
	DB	070H,00H,03CH,06H,03EH,066H,03BH,00H
	DB	018H,018H,03CH,06H,03EH,066H,03BH,00H
	DB	00H,00H,03CH,066H,060H,03CH,06H,0CH
	DB	07EH,0C3H,03CH,066H,07EH,060H,03CH,00H
	DB	066H,00H,03CH,066H,07EH,060H,03CH,00H
	DB	070H,00H,03CH,066H,07EH,060H,03CH,00H
	DB	066H,00H,00H,038H,018H,018H,03CH,00H
	DB	03CH,066H,00H,038H,018H,018H,03CH,00H
	DB	070H,00H,00H,038H,018H,018H,03CH,00H
	DB	063H,01CH,036H,063H,07FH,063H,063H,00H
	DB	018H,018H,00H,03CH,066H,07EH,066H,00H
	DB	07H,00H,07FH,031H,03CH,031H,07FH,00H		;90H
	DB	00H,00H,0EEH,03BH,07FH,0DCH,07EH,00H
	DB	03FH,078H,0D8H,0DEH,0F8H,0D8H,0DFH,00H
	DB	03CH,066H,00H,03CH,066H,066H,03CH,00H
	DB	066H,00H,00H,03CH,066H,066H,03CH,00H
	DB	070H,00H,00H,03CH,066H,066H,03CH,00H
	DB	03CH,066H,00H,066H,066H,066H,03BH,00H
	DB	070H,00H,00H,066H,066H,066H,03BH,00H
	DB	066H,00H,066H,066H,066H,03EH,06H,07CH
	DB	0C3H,018H,03CH,066H,066H,03CH,018H,00H
	DB	066H,00H,066H,066H,066H,066H,03CH,00H
	DB	0CH,0CH,03EH,060H,060H,03EH,0CH,0CH
	DB	03EH,063H,0F0H,060H,060H,0E3H,0DEH,00H
	DB	066H,066H,018H,07EH,018H,018H,018H,00H
	DB	07CH,066H,066H,07CH,062H,067H,062H,03H
	DB	0EH,01BH,018H,03CH,018H,0D8H,070H,00H
	DB	07H,00H,03CH,06H,03EH,066H,03BH,00H		;A0H
	DB	07H,00H,00H,038H,018H,018H,03CH,00H
	DB	07H,00H,00H,03CH,066H,066H,03CH,00H
	DB	07H,00H,00H,066H,066H,066H,03BH,00H
	DB	07EH,00H,00H,07CH,066H,066H,066H,00H
	DB	07FH,00H,063H,073H,07BH,06FH,067H,00H
	DB	03CH,06H,03EH,066H,03BH,00H,07FH,00H
	DB	00H,03CH,066H,066H,03CH,00H,07EH,00H
	DB	0CH,00H,0CH,0CH,018H,033H,01EH,00H
	DB	00H,00H,07EH,060H,060H,060H,00H,00H
	DB	00H,00H,07EH,06H,06H,06H,00H,00H
	DB	044H,04CH,058H,036H,069H,042H,0FH,00H
	DB	044H,04CH,058H,036H,06AH,05FH,02H,00H
	DB	018H,00H,018H,018H,018H,018H,018H,00H
	DB	00H,01BH,036H,06CH,036H,01BH,00H,00H
	DB	00H,06CH,036H,01BH,036H,06CH,00H,00H
	DB	011H,044H,011H,044H,011H,044H,011H,044H		;B0H
	DB	055H,0AAH,055H,0AAH,055H,0AAH,055H,0AAH
	DB	077H,0DDH,077H,0DDH,077H,0DDH,077H,0DDH
	DB	018H,018H,018H,018H,018H,018H,018H,018H
	DB	018H,018H,018H,018H,0F8H,018H,018H,018H
	DB	018H,018H,0F8H,018H,0F8H,018H,018H,018H
	DB	036H,036H,036H,036H,0F6H,036H,036H,036H
	DB	00H,00H,00H,00H,0FEH,036H,036H,036H
	DB	00H,00H,0F8H,018H,0F8H,018H,018H,018H
	DB	036H,036H,0F6H,06H,0F6H,036H,036H,036H
	DB	036H,036H,036H,036H,036H,036H,036H,036H
	DB	00H,00H,0FEH,06H,0F6H,036H,036H,036H
	DB	036H,036H,0F6H,06H,0FEH,00H,00H,00H
	DB	036H,036H,036H,036H,0FEH,00H,00H,00H
	DB	018H,018H,0F8H,018H,0F8H,00H,00H,00H
	DB	00H,00H,00H,00H,0F8H,018H,018H,018H
	DB	018H,018H,018H,018H,01FH,00H,00H,00H		;C0H
	DB	018H,018H,018H,018H,0FFH,00H,00H,00H
	DB	00H,00H,00H,00H,0FFH,018H,018H,018H
	DB	018H,018H,018H,018H,01FH,018H,018H,018H
	DB	00H,00H,00H,00H,0FFH,00H,00H,00H
	DB	018H,018H,018H,018H,0FFH,018H,018H,018H
	DB	018H,018H,01FH,018H,01FH,018H,018H,018H
	DB	036H,036H,036H,036H,037H,036H,036H,036H
	DB	036H,036H,037H,030H,03FH,00H,00H,00H
	DB	00H,00H,03FH,030H,037H,036H,036H,036H
	DB	036H,036H,0F7H,00H,0FFH,00H,00H,00H
	DB	00H,00H,0FFH,00H,0F7H,036H,036H,036H
	DB	036H,036H,037H,030H,037H,036H,036H,036H
	DB	00H,00H,0FFH,00H,0FFH,00H,00H,00H
	DB	036H,036H,0F7H,00H,0F7H,036H,036H,036H
	DB	018H,018H,0FFH,00H,0FFH,00H,00H,00H
	DB	036H,036H,036H,036H,0FFH,00H,00H,00H		;D0H
	DB	00H,00H,0FFH,00H,0FFH,018H,018H,018H
	DB	00H,00H,00H,00H,0FFH,036H,036H,036H
	DB	036H,036H,036H,036H,03FH,00H,00H,00H
	DB	018H,018H,01FH,018H,01FH,00H,00H,00H
	DB	00H,00H,01FH,018H,01FH,018H,018H,018H
	DB	00H,00H,00H,00H,03FH,036H,036H,036H
	DB	036H,036H,036H,036H,0F7H,036H,036H,036H
	DB	018H,018H,0FFH,018H,0FFH,018H,018H,018H
	DB	018H,018H,018H,018H,0F8H,00H,00H,00H
	DB	00H,00H,00H,00H,01FH,018H,018H,018H
	DB	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
	DB	00H,00H,00H,00H,0FFH,0FFH,0FFH,0FFH
	DB	0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H
	DB	0FH,0FH,0FH,0FH,0FH,0FH,0FH,0FH
	DB	0FFH,0FFH,0FFH,0FFH,00H,00H,00H,00H
	DB	00H,00H,03BH,066H,066H,066H,03BH,00H		;E0H
	DB	01EH,033H,033H,03EH,033H,033H,03EH,060H
	DB	07FH,063H,060H,060H,060H,060H,060H,00H
	DB	00H,00H,07FH,036H,036H,036H,036H,00H
	DB	07FH,063H,030H,018H,030H,063H,07FH,00H
	DB	00H,00H,03FH,066H,066H,066H,03CH,00H
	DB	00H,00H,033H,033H,033H,033H,03EH,060H
	DB	00H,00H,03BH,06EH,0CH,0CH,0CH,00H
	DB	03CH,018H,07EH,0C3H,07EH,018H,03CH,00H
	DB	03EH,063H,063H,07FH,063H,063H,03EH,00H
	DB	03EH,063H,063H,063H,063H,036H,077H,00H
	DB	01CH,030H,018H,03CH,066H,066H,038H,00H
	DB	00H,036H,049H,049H,049H,036H,00H,00H
	DB	03H,06H,07EH,0DBH,0DBH,07EH,060H,0C0H
	DB	00H,03EH,060H,07EH,060H,03EH,00H,00H
	DB	03EH,063H,063H,063H,063H,063H,063H,00H
	DB	00H,03EH,00H,03EH,00H,03EH,00H,00H		;F0H
	DB	018H,018H,07EH,018H,018H,00H,07EH,00H
	DB	030H,018H,0CH,018H,030H,00H,07EH,00H
	DB	0CH,018H,030H,018H,0CH,00H,07EH,00H
	DB	0EH,01BH,018H,018H,018H,018H,018H,018H
	DB	018H,018H,018H,018H,018H,018H,0D8H,070H
	DB	018H,018H,00H,07EH,00H,018H,018H,00H
	DB	00H,03BH,06EH,00H,03BH,06EH,00H,00H
	DB	03CH,066H,066H,03CH,00H,00H,00H,00H
	DB	00H,00H,00H,018H,018H,00H,00H,00H
	DB	00H,00H,00H,00H,018H,00H,00H,00H
	DB	01FH,018H,018H,018H,0D8H,078H,038H,018H
	DB	07CH,066H,066H,066H,00H,00H,00H,00H
	DB	038H,06CH,018H,03EH,00H,00H,00H,00H
	DB	00H,03CH,03CH,03CH,03CH,03CH,00H,00H
	DB	00H,00H,00H,00H,00H,00H,00H,00H			;FFH

;	INTERRUPT 5 PROCESSOR

	DB	'PS'			;IDENTIFIER
INT5:	PUSH	AX
	PUSH	BX
	STI				;ENABLE OTHER INTERRUPTS
	MOV	AH,15
	INT	10H			;GET CURRENT VIDEO MODE
	CMP	AL,4			;GRAPHIC MODE?
	JB	SDOK			;NO, OK TO PROCESS
	POP	BX
	POP	AX
	JMP	CS:DWORD PTR INT5VEC	;ELSE, LET PSC DO IT
SDOK:	PUSH	CX			;ELSE, SAVE MORE REGISTERS
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	AX			;SAVE MODE
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS SEGMENT
	PUSH	CS
	POP	ES			;AND TO THIS SEGMENT
	MOV	SI,OFFSET BCPOS		;POINT TO BIOS CURSOR POSITIONS
	MOV	DI,OFFSET CPOS		;SAVE THEM HERE
	MOV	CX,8			;8 POSITIONS
	CLD
	REP	MOVSW			;SAVE POSITIONS, TYPE
	MOV	AX,0B800H
	MOV	DS,AX			;POINT TO GRAPHIC RAM
	XOR	SI,SI
	MOV	DI,OFFSET VBUFF		;POINT TO VIDEO BUFFER
	MOV	CX,2000H
	REP	MOVSW			;SAVE VIDEO RAM
	PUSH	CS
	POP	DS			;PUT DS IN THIS SEGMENT
	MOV	AH,3
	INT	10H			;GET CURSOR TYPE
	MOV	CTYPE,CX		;SAVE IT
	POP	AX			;GET MODE
	PUSH	AX
	MOV	DI,2048*2		;ASSUME 80 COLUMN MODE
	MOV	CX,80*25		;CHARS ON SCREEN
	MOV	CPL,80			;CHARACTERS/LINE
	MOV	BL,6			;WILL USE MODE 6
	CMP	AL,2			;TEST MODE
	JNB	COL80			;IT'S AN 80 COLUMN MODE
	MOV	DI,2048			;1K WORDS IN 40 COL PAGE
	MOV	CX,40*25		;CHARS ON SCREEN
	MOV	CPL,40
	MOV	BL,5			;WILL USE MODE 5
COL80:	MOV	AL,BH			;GET PAGE NUMBER
	XOR	AH,AH			;IN AX
	MUL	DI			;CALCULATE PAGE START
	MOV	SI,AX			;IN SI
	ADD	SI,OFFSET VBUFF		;PAGE IS IN VIDEO BUFFER
	MOV	AL,BL			;GET NEW MODE
	CBW				;AX = NEW MODE
	INT	10H			;SET NEW MODE
	MOV	BL,83H			;FOREGROUND COLOR 3, XOR MODE
	MOV	DX,0FFH			;START AT UPPER LEFT (LESS 1)
	PUSH	BX			;SAVE PAGE NO.
	MOV	BH,0			;MUST BE 0 NOW
REPLP:	INC	DL			;INCREMENT COLUMN
	CMP	DL,CPL			;END OF LINE?
	JNZ	NOTEL
	INC	DH			;ELSE, NEXT LINE
	MOV	DL,0			;COLUMN 0
NOTEL:	MOV	AH,2
	INT	10H			;SET NEW CURSOR POSITION
	LODSW				;GET A CHARACTER, ATTRIBUTE
	TEST	AH,0FH			;TEST FOREGROUND
	JNZ	NOTREV			;NOT BLACK
	TEST	AH,01110000B		;BLACK BACKGROUND?
	JZ	NOTREV			;BOTH BLACK, NOT REVERSE
	PUSH	AX			;ESLE, SAVE CHARACTER
	MOV	AL,7
	CALL	PUTCHR			;MAKE REVERSE VIDEO
	MOV	AL,8
	CALL	PUTCHR
	POP	AX
NOTREV:	CALL	PUTCHR			;WRITE CHARACTER
	LOOP	REPLP			;REPEAT UNTIL SCREEN PAINTED
	POP	BX			;RESTORE PAGE NUMBER
	PUSHF				;PREPARE TO CALL INT. ROUTINE
	CLI
	CALL	DWORD PTR INT5VEC	;PRINT THE SCREEN
	STI
	POP	AX			;GET OLD MODE
	CBW				;AX = MODE
	INT	10H			;SET IT
	MOV	AL,BH			;GET PAGE NUMBER
	MOV	AH,5
	INT	10H			;SET PAGE
	MOV	AX,40H
	MOV	ES,AX			;POINT TO BIOS SEGMENT
	MOV	SI,OFFSET CPOS		;POINT TO SAVED CURSORS
	MOV	DI,OFFSET BCPOS		;PUT THEM HERE
	MOV	CX,8			;8 POSITIONS
	REP	MOVSW			;RESTORE CURSORS
	MOV	AH,1
	MOV	CX,CTYPE		;GET CURSOR TYPE
	INT	10H			;RESTORE IT
	MOV	AX,0B800H
	MOV	ES,AX			;POINT TO VIDEO RAM
	MOV	SI,OFFSET VBUFF		;POINT TO VIDEO BUFFER
	XOR	DI,DI
	MOV	CX,2000H
	REP	MOVSW			;RESTORE VIDEO
	POP	ES			;RESTORE REGISTERS
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET

PUTCHR:	PUSH	CX			;SAVE COUNTER
	MOV	CX,1			;WRITE 1 CHARACTER
	MOV	AH,9
	INT	10H			;WRITE IT
	POP	CX
	RET

VBUFF:					;BUFFER AREA
BUFF	STRUC
	DB	4000H DUP (?)		;SIZE OF VIDEO BUFFER
ENDRES	DB	?			;END OF RESIDENT CODE
BUFF	ENDS

;	SET UP VECTORS, STORE PROGRAM IN MEMORY

SETUP:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN ON MESSAGE
	XOR	AX,AX
	MOV	DS,AX			;POINT TO PAGE 0
	MOV	SI,OFFSET PSCINT	;POINT TO PSC VECTOR
	LES	DI,DWORD PTR [SI]	;GET IT
	CMP	ES:WORD PTR -2[DI],'SP'	;CHECK FOR IDENTIFIER
	JNZ	NOTIN			;PSCTM IS NOT ALREADY IN
	PUSH	CS
	POP	DS
	MOV	DX,OFFSET ITSIN
	MOV	AH,9
	INT	21H			;SAY "PSCTM ALREADY IN"
	INT	20H			;AND EXIT
NOTIN:	MOV	AX,ES
	CMP	AX,0F000H		;PSC INSTALLED?
	JB	PSCIN			;YES
	PUSH	CS
	POP	DS
	MOV	DX,OFFSET NOPSC
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO PSC"
	INT	20H			;AND EXIT
PSCIN:	MOV	WORD PTR [SI],OFFSET INT5	;VECTOR INTERRUPT TO HERE
	MOV	2[SI],CS
	MOV	SI,OFFSET GCHRVEC	;POINT TO GRAPHIC CHAR VECTOR
	MOV	WORD PTR [SI],OFFSET GCHRTBL	;POINT TO OUR TABLE
	MOV	2[SI],CS
	PUSH	CS
	POP	DS
	MOV	INT5VEC,DI		;SAVE OLD VECTOR
	MOV	INT5VEC+2,ES
	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;PRINT INSTALL MESSAGE
	MOV	DX,OFFSET VBUFF.ENDRES	;PROGRAM ENDS HERE
	INT	27H			;EXIT, LEAVING PROGRAM INSTALLED

SIGNON	DB	13,10,'Print SCreen utility for Text Modes, V 1.0'
	DB	13,10,10,'$'
ITSIN	DB	7,'PSCTM is already installed.$'
NOPSC	DB	7,'ERROR -- No graphic PSC utility installed.$'
INSMSG	DB	'PSCTM is now installed.$'

CODE	ENDS
	END	START
