/* fphandler is interposed before the user's signal handler so that
 * it can deal with SIGFPE caused by the lack of an 80387
 */

/* This must not be compiled with -O !!!!!!!! */

#include <stdio.h>
#include <signal.h>

void (*__userfphandler)() = SIG_DFL;

typedef unsigned char u_char;

extern int __emulate();

void __fphandler(sig)
int sig;
{
    long a[1];
    u_char *instr;

    signal(SIGFPE, __fphandler);

    instr = (u_char *)a[16];

#ifdef DEBUG
    fprintf(stderr, "handler: called from pc %d (%02x %02x %02x %02x)\n",
	    instr, instr[0], instr[1], instr[2], instr[3]);
#endif

    if(__emulate(a) != 0)
    {
	if(__userfphandler == SIG_DFL)
	{
	    fprintf(stderr, "unhandled fp exception ");
	    fprintf(stderr, "at pc %d (%02x %02x %02x %02x)\n",
		    instr, instr[0], instr[1], instr[2], instr[3]);
	    exit(1);
	}
	if(__userfphandler != SIG_IGN)
	    (*__userfphandler)(sig);
    }
	
    return;
}
