#include <stdio.h>
#include "a.out.gnu.h"

long textoff, textaddr, textlen;
long dataoff, dataaddr, datalen;
long bssaddr, bsslen;
long symoff, symlen;
long entry;

#define ROUNDUP(a,b) (((a)+(b)-1) & ~((b)-1))

#ifndef SEGSIZ
#define SEGSIZ 1
#endif

#ifndef N_TXTADDR
#define N_TXTADDR(e) SEGSIZ
#endif

#ifndef N_DATAOFF
#define N_DATAOFF(e) (N_TXTOFF(e)+e.a_text)
#endif

#ifndef N_DATAADDR
#define N_DATAADDR(e) ROUNDUP(N_TXTADDR(e)+e.a_text, SEGSIZ)
#endif

#ifndef N_BSSADDR
#define N_BSSADDR(e) (N_DATAADDR(e)+e.a_data)
#endif

extern void cvtout();

main(argc, argv)
int argc;
char **argv;
{
    struct exec e;
    int verbose;
    
    if(argc > 2 || (argc == 2 && strcmp(argv[1], "-v") != 0))
    {
	fprintf(stderr, "usage: %s [-v] <gcc-file >minix-file", argv[0]);
	exit(2);
    }

    verbose = (argc == 2);

    fread(&e, sizeof(e), 1, stdin);
    if(e.a_magic != ZMAGIC)
    {
	fprintf(stderr, "Bad magic number 0x%x\n", e.a_magic);
	exit(1);
    }

    if(e.a_trsize != 0 || e.a_drsize != 0)
    {
	fprintf(stderr, "Input file contains relocation information\n");
	exit(1);
    }

    textoff = N_TXTOFF(e);
    textaddr = N_TXTADDR(e);
    textlen = e.a_text;

    dataoff = N_DATAOFF(e);
    dataaddr = N_DATAADDR(e);
    datalen = e.a_data;

    bssaddr = N_BSSADDR(e);
    bsslen = e.a_bss;    

    symoff = N_SYMOFF(e);
    symlen = e.a_syms;

    entry = e.a_entry;

    if(verbose)
    {
      fprintf(stderr,  "textoff %5ld, dataoff  %5ld,                symoff %5ld\n",
	      textoff, dataoff, symoff);
      fprintf(stderr, "textaddr %4ld, dataaddr %5ld, bssaddr %5ld\n",
	      textaddr, dataaddr, bssaddr);
      fprintf(stderr,  "textlen %5ld, datalen  %5ld, bsslen  %5ld, symlen %5ld\n",
	      textlen, datalen, bsslen, symlen);
      fprintf(stderr, "entry %ld\n", entry);
    }
    
    cvtout(verbose);

    exit(0);
}
