;;;
;;;   File: stg2.st
;;;
;;;   Situation Theoretic Grammar with a few rules and showing how to
;;;   relate utterance situation to a described situation.
;;;
;;;   Alan W Black (awb@ed.ac.uk) July 91
;;;
;;;   As before utterance are represented by situations.  They are
;;;   also related to a semantics (paramteric object) and a labelling
;;;   and anchoring environment.  A general resource situation is also
;;;   included.  This time we add constraints to relate an utterance
;;;   to the situation it is describing by "reducing" the semantics
;;;   with respect to the anchoring environment.
;;;

Individuals
    {h,t}
Relations
    ( 
      use_of/2 cat/2 
      sem/2 env/2
      NounPhrase/1 Sentence/1 VerbPhrase/1
      subj/1 pred/1 
      described/2
      resource/2
      label/2 anchor/2 
      sing/1 
    )
Parameters
    {R1,A1,S,NP,VP,PN,V,Env,DS}
Variables
    {*X, *Y, *Z, *S, *Fact, *VPEnv, *SEnv, *VPEnvType, *VEnv, *VEnvType
     *R1, *A1, *A2, *VR1, *VA1, *VA2, *DS, *Res}
Situations
    (SitResource :: [Res ! Res != <<named,h,"Hanako",1>>
                           Res != <<female,h,1>>
                           Res != <<named,t,"Taro",1>>
                           Res != <<male,t,1>>]
     SingEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,sing,1>>
		       Env != <<label,A1,subj,1>>]
     LikeEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,like,1>>
		       Env != <<label,A1,subj,1>>
		       Env != <<label,A2,obj,1>>]
    )
GoalProp
   *S : [S ! S != <<cat,S,Sentence,1>>
             S != <<described,*S,*DS,1>>]

Constraints
;;;
;;;  These constraints are minimal.  Two are needed because there
;;;  is currently no deal with (semantic) facts with different
;;;  arity in the same specification (and refer to their arguments).
;;;

   *S : [S ! S != <<described,S,*DS :: [DS ! DS != <<*VR1,*VA1,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<sem,S,<<*R1,*A1,1>>,1>>
                S != <<env,S,*SEnv ::
                              [Env ! Env != <<anchor,*R1,*VR1,1>>
                                     Env != <<anchor,*A1,*VA1,1>>],1>>].

   *S : [S ! S != <<described,S,*DS :: [DS ! DS != <<*VR1,*VA1,*VA2,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>
		 	            Env != <<anchor,*A2,*VA2,1>>],1>>].

Grammar Rules
   [S ! S != <<cat,S,Sentence,1>>
        S != <<sem,S,*Fact,1>>
        S != <<env,S,*SEnv :: *VPEnvType & 
		              [Env ! Env != <<anchor,*X,*Y,1>>],1>>
	S != <<resource,S,*Res,1>>]
   ->
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<sem,NP,*Y,1>>
	  NP != <<resource,NP,*Res,1>>],
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<sem,VP, *Fact ,1>>
          VP != <<env,VP,*VPEnv :: *VPEnvType &
                                   [Env ! Env != <<label,*X,subj,1>>],1>>
	  VP != <<resource,VP,*Res,1>>].

   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<sem,VP,*Fact,1>>
         VP != <<env,VP,*VPEnv :: *VEnvType & 
		                  [Env ! Env != <<anchor,*X,*Y,1>>],1>>
	 VP != <<resource,VP,*Res,1>>]
   ->
    [V ! V != <<cat,V,Verb,1>>
         V != <<sem,V,*Fact,1>>
         V != <<env,V,*VEnv :: *VEnvType &
                               [Env ! Env != <<label,*X,obj,1>>],1>>
	 V != <<resource,V,*Res,1>>],
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<sem,NP,*Y,1>>
          NP != <<resource,NP,*Res,1>>].
Lexical Entries

Hanako - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<sem,PN,h,1>>
	 PN != <<resource,PN,SitResource,1>>]
Taro -
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<sem,PN,t,1>>
	 PN != <<resource,PN,SitResource,1>>]
sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>
	 VP != <<resource,VP,SitResource,1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>
        V != <<sem,V,<<R1,A1,A2,1>>,1>>
        V != <<env,V,LikeEnv,1>>
	V != <<resource,V,SitResource,1>>]

