;;;
;;;   File: stg1.st
;;;
;;;   Situation Theoretic Grammar in its barest form
;;;
;;;   Alan W Black (awb@ed.ac.uk) July 91
;;;
;;;   This is a minimum description to show the essential parts of STG.
;;;   Each utterance (or part of an utterance) is represented as a
;;;   situation.  Grammar rules are constraints between such utterance
;;;   situations.  An utterance situation is related to a semantics,
;;;   represented by a parametric object, and an environment
;;;   represented by a situation which relates the paramters in the
;;;   semantics to labels and anchors.
;;;
;;;   This is following Cooper89/90 as closely as possible.
;;;

Individuals
    {h,t}
Relations
    ( 
      use_of/2 cat/2 
      sem/2 env/2
      NounPhrase/1 Sentence/1 VerbPhrase/1
      subj/1 pred/1 
      label/2 anchor/2 
      sing/1 
    )
Parameters
    {R1,A1,S,NP,VP,PN,ENV}
Variables
    {*X, *Y, *Z, *S, *Fact, *VPEnv, *SEnv, *VPEnvType}
Situations
    (SingEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,sing,1>>
		       Env != <<label,A1,subj,1>>] )
GoalProp
   *S : [S ! S != <<cat,*S,sentence,1>>]
Grammar Rules
;;;
;;;   S -> NP VP
   [S ! S != <<cat,S,Sentence,1>>
        S != <<sem,S,*Fact,1>>
        S != <<env,S,*SEnv :: *VPEnvType & 
		             [Env ! Env != <<anchor,*X,*Y,1>>],1>>]
   ->
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<sem,NP,*Y,1>>],
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<sem,VP,*Fact,1>>
          VP != <<env,VP,*VPEnv :: *VPEnvType &
                                  [Env ! Env != <<label,*X,subj,1>>],1>>].

;;;
;;;  An alternative where the *same* environment is extended
;;;  (this doesn't work in the current implementation - 10th July 91)
;;;
;;   [S ! S != <<cat,S,Sentence,1>>
;;        S != <<sem,S,*Fact,1>>
;;        S != <<env,S,*VPEnv :: [Env ! Env != <<anchor,*X,*Y,1>>],1>>]
;;   ->
;;    [NP ! NP != <<cat,NP,NounPhrase,1>>
;;          NP != <<sem,NP,*Y,1>>],
;;    [VP ! VP != <<cat,VP,VerbPhrase,1>>
;;          VP != <<sem,VP,*Fact,1>>
;;          VP != <<env,VP,*VPEnv :: [Env ! Env != <<label,*X,subj,1>>],1>>].

Lexical Entries

Hanako - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<sem,PN,h,1>>]
Taro -
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<sem,PN,t,1>>]
sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>]

