;;;
;;;  A random debug function
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (c) 1993  Alan W Black (awb@ed.ac.uk)
;;;
;;; This file is part of an implementation of ASTL a computational
;;; situation theoretic language.  This implementation of ASTL is free
;;; software; you can redistribute it and/or modify it under the terms
;;; of the GNU General Public License as published by the Free
;;; Software Foundation; either version 1, or (at your option) any
;;; later version.
;;;
;;; ASTL is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY.  No author or distributor accepts
;;; responsibility to anyone for the consequences of using it or for
;;; whether it serves any particular purpose or works at all, unless
;;; he says so in writing.  Refer to the GNU Genral Public License for
;;; full details.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this file, but only under the conditions described in the
;;; GNU General Public License.   A copy of this license is
;;; supposed to have been given to you along with this program so you
;;; can know your rights and responsibilities.  It should be in a
;;; file named COPYING.  Among other things, the copyright notice
;;; and this notice must be preserved on all copies.
;;;
;;; The author gratefully acknowledges financial support for the
;;; research this implementation is based on from an SERC studnetship
;;; (number 89313458) and Esprit Basic Research Action Project 6852
;;; (DYANA-2).
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun showedge (edge)
	     (format t "

start ~A end ~A info ~A
situation ~A 
fact ~A
conditions ~A
bindings ~A"
		     (vertex-name (edge-start edge))
		     (vertex-name (edge-end edge))
		     (edge-info edge)
		     (sit-point-name (edge-situation edge))
		     (edge-fact edge)
		     (mapcar #'(lambda (proposition)
				 (format nil "
  Prop Sit ~A From ~A To ~A
       Fact ~A"
       (proposition-situation proposition)
       (if (si-varp (proposition-start proposition))
	   (variable-name (proposition-start proposition))
	   (vertex-name (proposition-start proposition)))
       (if (si-varp (proposition-end proposition))
	   (variable-name (proposition-end proposition))
	   (vertex-name (proposition-end proposition)))
       (proposition-fact proposition)))
			     (edge-conditions edge))
		     (or t (edge-bindings edge))))

