;;;
;;;   File: drt1.st
;;;
;;;   Discourse Representation Theory in Situation Theoretic Grammar
;;;
;;;   Alan W Black (awb@ed.ac.uk) August 91
;;;
;;;   This is the bare minimum showing how a thread of a domain of
;;;   individuals being discussed and a set of conditions (effectively
;;;   a described situation) can be threaded through an analysis.
;;;
;;;   This version works for transitive and intransitive verbs with
;;;   proper noun arguments
;;;

Individuals
    {h,t}
Relations
    ( use_of/2 cat/2 
      sem/2 env/2
      NounPhrase/1 Sentence/1 VerbPhrase/1 Discourse/1
      subj/1 pred/1 
      label/2 anchor/2
      sing/1 like/2
      DRSIn/2 DRSOut/2
    )
Parameters
    {R1,A1,S,S1,S2,TS,NP,VP,PN,V,Env,DS}
Variables
    {*X, *Y, *Z, *S, *Fact, *VPEnv, *SEnv, *VPEnvType, *VEnv, *VEnvType,
     *R1, *A1, *A2, *VR1, *VA1, *VA2, *DS, 
     *DRSInType,
     *DRSIn, *DRSout,
     *ThreadS, *ThreadNP, *ThreadVP, *ThreadV, *Thread, *ThreadDS,
     *T1, *T2, *S1, *S2, *P1, *P2, *NPSem,
     *NP, *VP, *V}
Situations
    (SingEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,sing,1>>
		       Env != <<label,A1,subj,1>>]
     LikeEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,like,1>>
		       Env != <<label,A1,subj,1>>
		       Env != <<label,A2,obj,1>>]
     DRSStart 
     Dstart :: [S ! S != <<cat,S,Discourse,1>>
                    S != <<DRSout,S,DRSStart,1>>]
    )
GoalProp
   *S : [S ! S != <<cat,S,discourse,1>>
             S != <<DRSOut,S,*DRSout,1>>
        ]

Constraints
;;;
;;;  These first set of constraint define the relationship between
;;;  the incoming DRS and the outgoing DRS in the various types of
;;;  node.  The only interesting ones are sentences where a new 
;;;  condition is added and noun phrase where a new individuals
;;;  is added.  In the other nodes the DRS is simply "copied"
;;;  across
;;;
   *S : [S ! S != <<DRSOut,S,*DRSOut :: *DRSInType &
                                          [DS ! DS != <<*VR1,*VA1,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*R1,*A1,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>],1>>].

   *S : [S ! S != <<DRSOut,S,*DRSOut ::
                              *DRSInType &
                              [DS ! DS != <<*VR1,*VA1,*VA2,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>
			            Env != <<anchor,*A2,*VA2,1>>],1>>].

*S : [S ! S != <<DRSout,S,*DRSout ::
                         *DRSInType &
                         [DS ! DS != <<marker,*X,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,NounPhrase,1>>
                 S != <<DRSIn,S,*DRSin :: *DRSInType,1>>
                 S != <<sem,S,*X,1>>
            ].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,VerbPhrase,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,Verb,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,Discourse,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

;;;
;;;  The relationship between the DRSIn and the previous DRSOut
;;;  is done by threading.  Relationships for threads are built 
;;;  up in the grammar rules.  Tracing a thread is done here
;;;

;;; An (utterance) situation's DRSin is the DRSOut of its thread.
*S : [S ! S != <<DRSIn,S,*DRSin,1>>]
<=
  *Y : [TS ! TS != <<t-in,*S,*S1 :: [S1 ! S1 != <<DRSOut,S1,*DRSIn,1>>],1>>].

;;;
;;;  This is basically a lexical rule to add the base case of the
;;;  threads.  Lexical items thread through themselves as they have
;;;  no daughters.
;;;
*S : [S ! S != <<threads,S,*Thread ::
                           [TS ! TS != <<t-need,*S,*S,1>>],1>>]
<=
   *S : [S ! S != <<use_of,S,*Y,1>>].

Grammar Rules
   *S : [S ! S != <<cat,S,Sentence,1>>
             S != <<sem,S,*Fact,1>>
             S != <<env,S,*SEnv :: *VPEnvType & 
  	                   [Env ! Env != <<anchor,*P1,*NPSem,1>>],1>>
	     S != <<threads,S,*ThreadS ::
	 	              [TS ! TS != <<t-need,*S,*Y,1>>
				    TS != <<t-in,*X,*NP,1>>
				    TS != <<t-in,*S,*VP,1>>],1>>
         ]
   ->
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*NPSem,1>>
                NP != <<threads,NP,*ThreadNP ::
                                    [TS ! TS != <<t-need,*NP,*Y,1>>],1>>
           ],
    *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
                VP != <<sem,VP, *Fact ,1>>
                VP != <<env,VP,*VPEnv :: *VPEnvType &
                                     [Env ! Env != <<label,*P1,subj,1>>],1>>
                VP != <<threads,VP,*ThreadVP ::
                                    [TS ! TS != <<t-need,*VP,*X,1>>],1>>
           ].

   *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
               VP != <<sem,VP,*Fact,1>>
               VP != <<env,VP,*VPEnv :: *VEnvType & 
    		                    [Env ! Env != <<anchor,*P1,*NPSem,1>>],1>>
               VP != <<threads,VP,*ThreadVP ::
                               [TS ! TS != <<t-need,*VP,*X,1>>
                                     TS != <<t-in,*Y,*V,1>>
                                     TS != <<t-in,*VP,*NP,1>>],1>>]
   ->
    *V  : [V ! V != <<cat,V,Verb,1>>
               V != <<sem,V,*Fact,1>>
               V != <<env,V,*VEnv :: *VEnvType &
                              [Env ! Env != <<label,*P1,obj,1>>],1>>
               V != <<threads,V,*ThreadV ::
		           [TS ! TS != <<t-need,*V,*X,1>>],1>>],
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*NPSem,1>>
                NP != <<threads,NP,*ThreadNP ::
                             [TS ! TS != <<t-need,*NP,*Y,1>>],1>>].


   *DS : [DS ! DS != <<cat,DS,Discourse,1>>
               DS != <<threads,DS,*ThreadDS ::
                             [TS ! TS != <<t-in,*X,DStart,1>>
                                   TS != <<t-in,*DS,*S,1>>],1>>]
   ->
     *S : [S ! S != <<cat,S,sentence,1>>
                S != <<threads,S,*ThreadS ::
                             [TS ! TS != <<t-need,*S,*X,1>>],1>>].

Lexical Entries

Hanako - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<sem,PN,h,1>>]
Taro -
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<sem,PN,t,1>>]
sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>
        V != <<sem,V,<<R1,A1,A2,1>>,1>>
        V != <<env,V,LikeEnv,1>>]

