/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.IStringSubstituter;
import com.ibm.wsaa.util.OrderedMap;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    protected static Pattern applySubREPattern = Pattern.compile("^s/(.*[^/])/(.*)/(.*)$");
    private static Pattern timePattern;
    private static long SECOND;
    private static long MINUTE;
    private static long HOUR;
    private static long DAY;
    private static long WEEK;
    private static long MONTH;
    private static long YEAR;

    public static String[] split(String string, char c) {
        return StringUtils.split(string, c, false);
    }

    public static String[] split(String string, char c, boolean bl) {
        return StringUtils.split(string, c, bl, false);
    }

    public static String[] split(String string, char c, boolean bl, boolean bl2) {
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string) && !bl2) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                ++n2;
            } else if (cArray2[i] == c && n2 % 2 == 0) {
                String string2 = new String(cArray2, n, i - n);
                linkedList.add(StringUtils.strip(bl ? StringUtils.unEscapeChars(string2, cArray) : string2));
                n = i + 1;
            }
            if (cArray2[i] == '\\') continue;
            n2 = 0;
        }
        String string3 = new String(cArray2, n, cArray2.length - n);
        linkedList.add(StringUtils.strip(bl ? StringUtils.unEscapeChars(string3, cArray) : string3));
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] split2(String string, char c, boolean bl) {
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                ++n2;
            } else if (cArray2[i] == c && n2 % 2 == 0) {
                String string2 = new String(cArray2, n, i - n);
                linkedList.add(StringUtils.strip(bl ? StringUtils.unEscapeChars(string2, cArray) : string2));
                n = i + 1;
            }
            if (cArray2[i] == '\\') continue;
            n2 = 0;
        }
        String string3 = new String(cArray2, n, cArray2.length - n);
        linkedList.add(StringUtils.strip(bl ? StringUtils.unEscapeChars(string3, cArray) : string3));
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] splitQuoted(String string, char c) {
        return StringUtils.splitQuoted(string, c, false, false);
    }

    public static String[] splitQuoted(String string, char c, boolean bl, boolean bl2) {
        char c2;
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                ++n2;
            } else if (n2 % 2 == 0) {
                if (cArray2[i] == '\'' && !bl4) {
                    bl3 = !bl3;
                } else if (cArray2[i] == '\"' && !bl3) {
                    bl4 = !bl4;
                } else if (cArray2[i] == c && !bl3 && !bl4) {
                    String string2 = StringUtils.strip(new String(cArray2, n, i - n));
                    if (bl) {
                        string2 = StringUtils.unEscapeChars(string2, cArray);
                    }
                    if (bl2 && string2.length() > 1) {
                        c2 = string2.charAt(0);
                        char c3 = string2.charAt(string2.length() - 1);
                        if (c2 == '\'' && c3 == '\'' || c2 == '\"' && c3 == '\"') {
                            string2 = string2.substring(1, string2.length() - 1);
                        }
                    }
                    linkedList.add(string2);
                    n = i + 1;
                }
            }
            if (cArray2[i] == '\\') continue;
            n2 = 0;
        }
        String string3 = StringUtils.strip(new String(cArray2, n, cArray2.length - n));
        if (bl) {
            string3 = StringUtils.unEscapeChars(string3, cArray);
        }
        if (bl2 && string3.length() > 1) {
            char c4 = string3.charAt(0);
            c2 = string3.charAt(string3.length() - 1);
            if (c4 == '\'' && c2 == '\'' || c4 == '\"' && c2 == '\"') {
                string3 = string3.substring(1, string3.length() - 1);
            }
        }
        linkedList.add(string3);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] splitBracketed(String string, char c, boolean bl) {
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '{') {
                ++n2;
            } else if (cArray2[i] == '}') {
                --n2;
            } else if (n2 == 0 && cArray2[i] == '\\') {
                ++n3;
            } else if (cArray2[i] == c && n2 == 0 && n3 % 2 == 0) {
                String string2 = StringUtils.strip(new String(cArray2, n, i - n));
                if (bl) {
                    string2 = StringUtils.unEscapeChars(string2, cArray);
                }
                linkedList.add(string2);
                n = i + 1;
            }
            if (cArray2[i] == '\\') continue;
            n3 = 0;
        }
        String string3 = StringUtils.strip(new String(cArray2, n, cArray2.length - n));
        linkedList.add(string3);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            linkedList.add(StringUtils.strip(string.substring(n, n2)));
            n = n2 + string2.length();
        }
        linkedList.add(StringUtils.strip(string.substring(n)));
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] split(String string) {
        if (string == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static int countChars(String string, char c, boolean bl) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                ++n2;
            } else if (cArray[i] == c && n2 % 2 == 0) {
                ++n;
            }
            if (cArray[i] == '\\') continue;
            n2 = 0;
        }
        return n;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            stringBuffer.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
        return stringBuffer.append(string.substring(n)).toString();
    }

    public static String replace(String string, char c, char c2) {
        return StringUtils.replace(string, c, c2, false, false);
    }

    public static String replace(String string, char c, char c2, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c3 = cArray[i];
            if (c3 == '\\' && bl) {
                ++n;
            } else if (n % 2 == 0) {
                if (c3 == '\'' && bl2) {
                    ++n2;
                } else if (c3 == '\"' && bl2) {
                    ++n3;
                } else if (c3 == c && n2 % 2 == 0 && n3 % 2 == 0) {
                    cArray[i] = c2;
                }
            }
            if (cArray[i] == '\\') continue;
            n = 0;
        }
        return new String(cArray);
    }

    public static String escapeChars(String string, char[] cArray) {
        return StringUtils.escapeChars(string, cArray, '\\');
    }

    public static String escapeDoubleQuotes(String string) {
        return StringUtils.escapeChars(string, new char[]{'\"'}, '\\');
    }

    public static String escapeChar(String string, char c) {
        return StringUtils.escapeChars(string, new char[]{c}, '\\');
    }

    public static String escapeChars(String string, char[] cArray, char c) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray2 = string.toCharArray();
        for (int i = 0; i < cArray2.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < cArray.length && !bl; ++j) {
                bl = cArray2[i] == cArray[j] || cArray2[i] == c;
            }
            if (bl) {
                stringBuffer.append(c);
            }
            stringBuffer.append(cArray2[i]);
        }
        return stringBuffer.toString();
    }

    public static String unEscapeChars(String string, char[] cArray) {
        return StringUtils.unEscapeChars(string, cArray, '\\');
    }

    public static String unEscapeChars(String string, char[] cArray, char c) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray2 = string.toCharArray();
        for (int i = 0; i < cArray2.length; ++i) {
            char c2 = cArray2[i];
            if (c2 == c && i + 1 != cArray2.length) {
                char c3 = cArray2[i + 1];
                boolean bl = false;
                for (int j = 0; j < cArray.length && !bl; ++j) {
                    bl = c3 == cArray[j];
                }
                if (bl) {
                    ++i;
                } else if (c3 == c) {
                    stringBuffer.append(c);
                    ++i;
                }
            }
            stringBuffer.append(cArray2[i]);
        }
        return stringBuffer.toString();
    }

    public static boolean isNumeric(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n2 = n = cArray[0] == '-' ? 1 : 0;
        while (n < cArray.length) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length > 0) {
            stringBuffer.append(objectArray[0]);
        }
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(string).append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, char c, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        char[] cArray = new char[]{c};
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length > 0) {
            stringBuffer.append(bl ? StringUtils.escapeChars(objectArray[0] == null ? "null" : objectArray[0].toString(), cArray) : objectArray[0]);
        }
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(c).append(bl ? StringUtils.escapeChars(objectArray[i] == null ? "null" : objectArray[i].toString(), cArray) : objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(Iterator iterator, String string) {
        if (iterator == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(string).append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static String quoteAndJoin(Iterator iterator, String string) {
        return StringUtils.quoteAndJoin(iterator, '\'', string);
    }

    public static String quoteAndJoin(Iterator iterator, char c, String string) {
        return StringUtils.quoteAndJoin(iterator, c + "", c + "", string);
    }

    public static String quoteAndJoin(Iterator iterator, String string, String string2, String string3) {
        if (iterator == null) {
            return null;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            stringBuffer.append(string).append(iterator.next()).append(string2);
        }
        while (iterator.hasNext()) {
            stringBuffer.append(string3).append(string).append(iterator.next()).append(string2);
        }
        return stringBuffer.toString();
    }

    public static String join(Iterator iterator, char c, boolean bl) {
        String string;
        Object e;
        if (iterator == null) {
            return null;
        }
        char[] cArray = new char[]{c};
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            e = iterator.next();
            string = e == null ? "null" : e.toString();
            stringBuffer.append(bl ? StringUtils.escapeChars(string, cArray) : string);
        }
        while (iterator.hasNext()) {
            e = iterator.next();
            string = e == null ? "null" : e.toString();
            stringBuffer.append(c).append(bl ? StringUtils.escapeChars(string, cArray) : string);
        }
        return stringBuffer.toString();
    }

    public static String strip(String string, String string2) {
        int n;
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return string;
        }
        char[] cArray = string2.toCharArray();
        char[] cArray2 = string.toCharArray();
        int n2 = 0;
        int n3 = cArray2.length - 1;
        for (n = 0; n < cArray2.length; ++n) {
            if (cArray2[n] == ' ' || cArray2[n] == '\t' || StringUtils.charIsOneOf(cArray2[n], cArray)) {
                ++n2;
                continue;
            }
            n = cArray2.length;
        }
        for (n = n3; n > n2; --n) {
            if (cArray2[n] == ' ' || cArray2[n] == '\t' || StringUtils.charIsOneOf(cArray2[n], cArray)) {
                --n3;
                continue;
            }
            n = n2;
        }
        return new String(cArray2, n2, n3 - n2 + 1);
    }

    public static String strip(String string) {
        return StringUtils.strip(string, " \t\r\n");
    }

    public static String[] strip(String[] stringArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl && StringUtils.isEmpty(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean charIsOneOf(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0 || StringUtils.strip(string).length() == 0;
    }

    public static boolean getBoolean(String string) {
        return StringUtils.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return bl;
        }
        char c = string.charAt(0);
        return c == 'T' || c == 't' || c == 'Y' || c == 'y' || c == '1';
    }

    public static int getInt(String string, int n) {
        if (!StringUtils.isNumeric(string)) {
            return n;
        }
        return Integer.parseInt(string);
    }

    public static char getChar(String string, char c) {
        if (string == null || string.length() == 0) {
            return c;
        }
        return string.charAt(0);
    }

    public static String[] getVars(String string, String string2) {
        string = string + "{";
        int n = string.length();
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = string2.indexOf(string);
        while (n2 != -1) {
            int n3 = string2.indexOf(125, n2);
            if (n3 != -1) {
                linkedList.add(string2.substring(n2 + n, n3));
                n2 = string2.indexOf(string, n3);
                continue;
            }
            n2 = -1;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String getString(String string, String string2) {
        return StringUtils.getString(string, string2, false);
    }

    public static String getString(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0) {
            string = string2;
        }
        if (string == null) {
            return null;
        }
        return bl ? string.trim() : string;
    }

    public static OrderedMap getMap(String string) throws ParseException {
        return StringUtils.getMap(string, ',', '=');
    }

    public static OrderedMap getMap(String string, char c, char c2) throws ParseException {
        OrderedMap orderedMap = new OrderedMap();
        String[] stringArray = StringUtils.split(string, c, true);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringUtils.split(stringArray[i], c2, true);
            if (stringArray2.length != 2) {
                throw new ParseException("Invalid map string: [" + string + "]", 0);
            }
            String string2 = orderedMap.put(stringArray2[0], stringArray2[1]);
            if (string2 == null) continue;
            throw new ParseException("Duplicate keys in map string: [" + string + "]", 0);
        }
        return orderedMap;
    }

    public static String makeUnicodeReadable(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~') {
                stringBuffer.append("\\u" + StringUtils.toHex(c, 4));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String convertToCsv(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    bl = true;
                    break;
                }
                case ',': {
                    bl = true;
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    bl = true;
                    break;
                }
            }
            stringBuffer.append(c);
        }
        return bl ? "\"" + stringBuffer + "\"" : string;
    }

    public static String convertToHtml(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (Character.isISOControl(c)) {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toValidXmlString(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c) && c != ' ') {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String htmlEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '@' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '-' && c <= '9' || c == '*' || c == '+' || c == '_') {
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u00ff') {
                stringBuffer.append("%u" + StringUtils.toHex(c, 4));
                continue;
            }
            stringBuffer.append("%" + StringUtils.toHex(c, 2));
        }
        return stringBuffer.toString();
    }

    public static String toHex(int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = n % 16;
        cArray[n2 - 1] = (char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3);
        int n4 = 16;
        for (int i = 1; i < n2; ++i) {
            n3 = n / n4 % 16;
            n4 <<= 4;
            cArray[n2 - 1 - i] = (char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3);
        }
        return new String(cArray);
    }

    public static boolean isValidIdentifier(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0 && !Character.isLetter(cArray[i])) {
                return false;
            }
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    public static String escapeApostrophes(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                ++n;
            } else if (n % 2 == 0) {
                if (cArray[i] == '\'') {
                    if (bl2 || i > 0 && i < cArray.length - 1 && !Character.isWhitespace(cArray[i - 1]) && cArray[i - 1] != '+' && cArray[i - 1] != '-' && !Character.isWhitespace(cArray[i + 1])) {
                        stringBuffer.append('\\');
                    } else {
                        bl = !bl;
                    }
                } else if (cArray[i] == '\"') {
                    if (bl || i > 0 && i < cArray.length - 1 && !Character.isWhitespace(cArray[i - 1]) && cArray[i - 1] != '+' && cArray[i - 1] != '-' && !Character.isWhitespace(cArray[i + 1])) {
                        stringBuffer.append('\\');
                    } else {
                        boolean bl3 = bl2 = !bl2;
                    }
                }
            }
            if (cArray[i] != '\\') {
                n = 0;
            }
            stringBuffer.append(cArray[i]);
        }
        if (bl || bl2) {
            throw new RuntimeException("Single or double quote not properly closed in the following expression: [" + string + "]");
        }
        return stringBuffer.toString();
    }

    public static String[] fragment(String string, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            linkedList.add(string.substring(i, n2));
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String applySubRE(String string, String string2) {
        Matcher matcher = applySubREPattern.matcher(string);
        if (matcher.find()) {
            boolean bl = matcher.group(3).indexOf(103) != -1;
            boolean bl2 = matcher.group(3).indexOf(115) == -1;
            Pattern pattern = Pattern.compile(matcher.group(1), bl2 ? 8 : 32);
            Matcher matcher2 = pattern.matcher(string2);
            if (bl) {
                return matcher2.replaceAll(matcher.group(2));
            }
            return matcher2.replaceFirst(matcher.group(2));
        }
        return string2;
    }

    public static boolean containsUnEscapedChars(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                bl = !bl;
                continue;
            }
            if (!bl) {
                for (int j = 0; j < cArray.length; ++j) {
                    if (cArray2[i] != cArray[j]) continue;
                    return true;
                }
            }
            bl = false;
        }
        return false;
    }

    public static boolean containsEscapedChars(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                bl = !bl;
                continue;
            }
            if (bl) {
                for (int j = 0; j < cArray.length; ++j) {
                    if (cArray2[i] != cArray[j]) continue;
                    return true;
                }
            }
            bl = false;
        }
        return false;
    }

    public static String chop(String string, int n) {
        if (string.length() < n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String[] addToArray(String[] stringArray, String string) {
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray == null ? new String[1] : new String[stringArray.length + 1];
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
        }
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static String toValidHref(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&#39;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toValidXml(String string) {
        return StringUtils.convertToHtml(string);
    }

    public static String toValidXmlAttr(String string) {
        return StringUtils.toValidHref(string);
    }

    public static String toValidJavascriptParam(String string) {
        return StringUtils.escapeChars(string, new char[]{'\'', '\"'});
    }

    public static long parseTime(String string) {
        if (timePattern == null) {
            timePattern = Pattern.compile("(\\d+)\\s*(\\w*)");
        }
        if ((string = string.toUpperCase()).equals("NEVER")) {
            return Long.MAX_VALUE;
        }
        if (string.equals("")) {
            return 0L;
        }
        Matcher matcher = timePattern.matcher(string);
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid time string format: [" + string + "]");
        }
        long l = Long.parseLong(matcher.group(1));
        String string2 = matcher.group(2);
        if (string2.startsWith("S")) {
            l *= SECOND;
        } else if (string2.startsWith("MIN")) {
            l *= MINUTE;
        } else if (string2.startsWith("H")) {
            l *= HOUR;
        } else if (string2.startsWith("D")) {
            l *= DAY;
        } else if (string2.startsWith("W")) {
            l *= WEEK;
        } else if (string2.startsWith("MO")) {
            l *= MONTH;
        } else if (string2.startsWith("Y")) {
            l *= YEAR;
        }
        return l;
    }

    public static String getTimeString(long l) {
        long l2;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (l == Long.MAX_VALUE) {
            return "never";
        }
        if (l >= YEAR) {
            l2 = l / YEAR;
            l %= YEAR;
            linkedList.add(l2 + " year" + (l2 > 1L ? "s" : ""));
        }
        if (l >= MONTH) {
            l2 = l / MONTH;
            l %= MONTH;
            linkedList.add(l2 + " month" + (l2 > 1L ? "s" : ""));
        }
        if (l >= DAY) {
            l2 = l / DAY;
            l %= DAY;
            linkedList.add(l2 + " day" + (l2 > 1L ? "s" : ""));
        }
        if (l >= HOUR) {
            l2 = l / HOUR;
            l %= HOUR;
            linkedList.add(l2 + " hour" + (l2 > 1L ? "s" : ""));
        }
        if (l >= MINUTE) {
            l2 = l / MINUTE;
            l %= MINUTE;
            linkedList.add(l2 + " minute" + (l2 > 1L ? "s" : ""));
        }
        if (l >= SECOND) {
            l2 = l / SECOND;
            l %= SECOND;
            linkedList.add(l2 + " second" + (l2 > 1L ? "s" : ""));
        }
        return StringUtils.join(linkedList.iterator(), ",");
    }

    public static String getTimeStringShort(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = l / HOUR;
        stringBuffer.append(l2 + ":");
        l2 = (l %= HOUR) / MINUTE;
        stringBuffer.append((l2 < 10L ? "0" : "") + l2 + ":");
        l2 = (l %= MINUTE) / SECOND;
        l %= SECOND;
        stringBuffer.append((l2 < 10L ? "0" : "") + l2);
        return stringBuffer.toString();
    }

    public static boolean needsTruncate(String string, int n, String string2) throws UnsupportedEncodingException {
        return string.getBytes(string2).length > n;
    }

    public static String truncateBytes(String string, int n, String string2) throws UnsupportedEncodingException {
        try {
            Charset charset = Charset.forName(string2);
            CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(new byte[]{63});
            try {
                CharBuffer charBuffer = CharBuffer.wrap(string);
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
                boolean bl = false;
                byte[] byArray = byteBuffer.array();
                for (int i = 0; i < byArray.length && !bl; ++i) {
                    if (byArray[i] != 63) continue;
                    bl = true;
                }
                String string3 = null;
                if (coderResult.isOverflow() || bl) {
                    byteBuffer.limit(byteBuffer.position());
                    CharsetDecoder charsetDecoder = charset.newDecoder();
                    byteBuffer.rewind();
                    string3 = charsetDecoder.decode(byteBuffer).toString();
                } else {
                    string3 = string;
                }
                if (string3.getBytes(string2).length > n) {
                    return string3.substring(0, string3.length() - 1);
                }
                return string3;
            }
            catch (Throwable throwable) {
                while (string.getBytes(string2).length > n) {
                    string = string.substring(0, string.length() - 1);
                }
                return string;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Call to StringUtils.truncateBytes(String s, int length, String charset) failed with the following parameters:  s=[" + StringUtils.makeUnicodeReadable(string) + "], length=[" + n + "], charset=[" + string2 + "]", exception);
        }
    }

    public static String getReaderContents(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = reader.read(cArray, 0, 1024)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static String substitute(String string, Pattern pattern, IStringSubstituter iStringSubstituter) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (matcher.find()) {
            stringBuffer.append(string.substring(n, matcher.start()));
            stringBuffer.append(iStringSubstituter.substitute(matcher));
            n = matcher.end();
        }
        if (n == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    static {
        SECOND = 1000L;
        MINUTE = SECOND * 60L;
        HOUR = MINUTE * 60L;
        DAY = HOUR * 24L;
        WEEK = DAY * 7L;
        MONTH = DAY * 31L;
        YEAR = DAY * 365L;
    }
}

