/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.ExpressionSolver;
import com.ibm.wsaa.util.StringUtils;
import com.ibm.wsaa.util.vars.VarResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class FileContents {
    private StringBuffer contents = new StringBuffer();
    private String filename;
    private String encoding;
    int maxReuseCapacity = 100000;

    public void readFile(String string, String string2) throws IOException {
        this.filename = string;
        this.readFile(new FileInputStream(string), string2);
    }

    public void readFile(File file, String string) throws IOException {
        this.filename = file.getAbsolutePath();
        this.readFile(new FileInputStream(file), string);
    }

    public void readFile(InputStream inputStream, String string) throws IOException {
        this.encoding = string;
        if (this.contents.capacity() > this.maxReuseCapacity) {
            this.contents = new StringBuffer();
        } else {
            this.contents.setLength(0);
        }
        InputStreamReader inputStreamReader = null;
        inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        char[] cArray = new char[1000];
        int n = 0;
        while ((n = bufferedReader.read(cArray, 0, 1000)) != -1) {
            this.contents.append(cArray, 0, n);
        }
        inputStream.close();
    }

    public void saveFile(String string, String string2) throws IOException {
        File file;
        String string3 = string == null ? this.filename : string;
        File file2 = new File(string3);
        if ((file2 = file2.getAbsoluteFile()).exists()) {
            file2.delete();
        }
        if (!(file = file2.getParentFile()).exists()) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string3, false);
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = string2 == null && this.encoding != null ? new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding) : new OutputStreamWriter((OutputStream)fileOutputStream, string2);
        outputStreamWriter.write(this.getContents());
        outputStreamWriter.flush();
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public String getContents() {
        return this.contents.substring(0, this.contents.length());
    }

    public StringBuffer getContentsBuffer() {
        return this.contents;
    }

    public void setContents(StringBuffer stringBuffer) {
        this.contents = stringBuffer;
    }

    public void insertVars(VarResolver varResolver) throws Exception {
        String string = varResolver.resolveString(this.contents.toString());
        this.contents.setLength(0);
        this.contents.append(string);
    }

    public int insertVars(String string, ResourceBundle resourceBundle, boolean bl, boolean bl2) {
        if (resourceBundle == null) {
            return 0;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            hashMap.put(string2, resourceBundle.getString(string2).trim());
        }
        return this.insertVars(string, hashMap, bl, bl2);
    }

    public int insertVars(String string, Map map, boolean bl, boolean bl2) {
        Iterator iterator;
        CharSequence charSequence;
        Object object;
        int n = 0;
        HashSet hashSet = new HashSet();
        HashSet<CharSequence> hashSet2 = new HashSet<CharSequence>();
        if (bl2) {
            object = map.keySet().iterator();
            while (object.hasNext()) {
                hashSet.add(object.next());
            }
        }
        object = new StringBuffer(this.contents.length());
        String string2 = this.contents.toString();
        String string3 = "$" + string + "{";
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string2.indexOf(string3, n2)) != -1) {
            ++n;
            ((StringBuffer)object).append(string2.substring(n2, n3));
            n2 = string2.indexOf(125, n3);
            charSequence = string2.substring(n3 + string3.length(), n2);
            iterator = (String)map.get(charSequence);
            ((StringBuffer)object).append((String)(iterator == null ? string3 + (String)charSequence + "}" : iterator));
            if (bl && iterator == null) {
                hashSet2.add(charSequence);
            } else if (bl2) {
                hashSet.remove(charSequence);
            }
            ++n2;
        }
        ((StringBuffer)object).append(string2.substring(n2));
        this.contents = object;
        charSequence = new StringBuffer();
        if (bl && !hashSet2.isEmpty()) {
            ((StringBuffer)charSequence).append("Properties not found in map for $" + string + " variables:  \t");
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)charSequence).append(iterator.next() + ", ");
            }
            ((StringBuffer)charSequence).append("\n");
        }
        if (bl2 && !hashSet.isEmpty()) {
            ((StringBuffer)charSequence).append("Properties not used in map for $" + string + " variables:  \t");
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)charSequence).append(iterator.next() + ", ");
            }
            ((StringBuffer)charSequence).append("\n");
        }
        if (((StringBuffer)charSequence).length() > 0) {
            throw new RuntimeException("Errors encountered while trying to insert properties into file [" + this.filename + "]:\n " + ((StringBuffer)charSequence).toString());
        }
        return n;
    }

    public void evaluateCommands() throws Exception {
        String string = this.contents.toString();
        StringBuffer stringBuffer = new StringBuffer(this.contents.length());
        int n = 0;
        while ((n = this.evaluateNextCOND(string, stringBuffer, n)) != -1) {
        }
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        n = 0;
        while ((n = this.evaluateNextIF(string, stringBuffer, n)) != -1) {
        }
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        n = 0;
        while ((n = this.evaluateNextFOREACH(string, stringBuffer, n)) != -1) {
        }
        this.contents = stringBuffer;
    }

    private int evaluateNextCOND(String string, StringBuffer stringBuffer, int n) throws Exception {
        int n2 = this.prependUpTo("COND", n, string, stringBuffer);
        if (n2 == -1) {
            return -1;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            int n3 = (n2 += 5) + 1;
            n2 = string.indexOf(63, n2);
            string2 = string.substring(n3, n2).trim();
            int n4 = n2 + 1;
            n2 = string.indexOf(58, n2);
            string3 = string.substring(n4, n2).trim();
            int n5 = n2 + 1;
            n2 = string.indexOf(93, n2);
            string4 = string.substring(n5, n2).trim();
        }
        catch (Exception exception) {
            throw new Exception("Incomplete %COND command found.");
        }
        if (ExpressionSolver.solveBoolean(string2)) {
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(string4);
        }
        return n2 + 1;
    }

    private int evaluateNextIF(String string, StringBuffer stringBuffer, int n) throws Exception {
        int n2 = this.prependUpTo("IF", n, string, stringBuffer);
        if (n2 == -1) {
            return -1;
        }
        String[] stringArray = FileContents.parseOutCommand("IF", string, n2);
        if (stringArray[0] == null || stringArray[1] == null) {
            throw new Exception("Incomplete %IF command found.");
        }
        int n3 = stringArray[1].length();
        stringArray[1] = StringUtils.replace(stringArray[1], "\n\t", "\n");
        stringArray[1] = StringUtils.replace(stringArray[1], "\n    ", "\n");
        int n4 = 0;
        if (ExpressionSolver.solveBoolean(stringArray[0])) {
            while ((n4 = this.evaluateNextIF(stringArray[1], stringBuffer, n4)) != -1) {
            }
        }
        return n2 + 11 + stringArray[0].length() + n3;
    }

    public int evaluateNextFOREACH(String string, StringBuffer stringBuffer, int n) throws Exception {
        int n2 = this.prependUpTo("FOREACH", n, string, stringBuffer);
        if (n2 == -1) {
            return -1;
        }
        String[] stringArray = FileContents.parseOutCommand("FOREACH", string, n);
        if (stringArray[0] == null || stringArray[1] == null || stringArray[0].indexOf(" in ") == -1) {
            throw new Exception("Incomplete %FOREACH command found.");
        }
        String string2 = stringArray[0].trim();
        String string3 = "$V{" + string2.substring(0, string2.indexOf(" in ")) + "}";
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(string2.indexOf(" in ") + 4), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            int n3 = 0;
            int n4 = 0;
            while ((n4 = stringArray[1].indexOf(string3, n3)) != -1) {
                stringBuffer.append(stringArray[1].substring(n3, n4) + string4);
                n3 = n4 + string3.length();
            }
            stringBuffer.append(stringArray[1].substring(n3));
        }
        return n2 + 21 + stringArray[0].length() + stringArray[1].length();
    }

    private int prependUpTo(String string, int n, String string2, StringBuffer stringBuffer) {
        int n2 = string2.indexOf("%" + string + "[", n);
        if (n2 == -1) {
            stringBuffer.append(string2.substring(n));
            return -1;
        }
        stringBuffer.append(string2.substring(n, n2));
        return n2;
    }

    private static String[] parseOutCommand(String string, String string2, int n) {
        String[] stringArray = new String[2];
        int n2 = string2.indexOf(91, n);
        int n3 = string2.indexOf(93, n2);
        stringArray[0] = string2.substring(n2 + 1, n3);
        int n4 = 1;
        for (n2 = n3 + 1; n4 != 0 && n2 < string2.length(); ++n2) {
            if (string2.charAt(n2) != '%') continue;
            if (string2.indexOf("%" + string, n2) == n2) {
                ++n4;
                continue;
            }
            if (string2.indexOf("%END" + string, n2) != n2) continue;
            --n4;
        }
        if (n4 == 0) {
            stringArray[1] = string2.substring(n3 + 1, n2 - 1);
        }
        return stringArray;
    }
}

