/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.ConfigEntry;
import com.ibm.wsaa.util.ConfigFile;
import com.ibm.wsaa.util.ConfigRuntimeException;
import com.ibm.wsaa.util.PasswordUtil;
import com.ibm.wsaa.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ConfigMgr {
    private static Hashtable configFileTable = new Hashtable();
    private static ArrayList configSearchPaths = new ArrayList();
    public static ConfigRuntimeException loadErrorsException = null;

    public static String[] getConfigSearchPaths() {
        return configSearchPaths.toArray(new String[configSearchPaths.size()]);
    }

    public static void load(String string) throws ConfigRuntimeException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.clear();
        if (string == null || string.equals("")) {
            linkedList.add("Search path passed to ConfigMgr.load() was empty:  searchPath=[" + string + "]");
        } else {
            Object object;
            Object object2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    object2 = new File(string2);
                    if (!((File)object2).exists() || arrayList.contains(object = ((File)object2).getCanonicalPath())) continue;
                    arrayList.add((String)object);
                }
                catch (Exception exception) {
                    throw new ConfigRuntimeException("Could not get canonical path for token [" + string2 + "].", exception);
                }
            }
            boolean bl = configSearchPaths.size() == arrayList.size();
            for (int i = 0; i < configSearchPaths.size() && bl; ++i) {
                if (((String)configSearchPaths.get(i)).equalsIgnoreCase((String)arrayList.get(i))) continue;
                bl = false;
            }
            if (bl) {
                return;
            }
            configSearchPaths = arrayList;
            File file = null;
            object2 = configSearchPaths.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                file = new File((String)object);
                if (!file.exists()) continue;
                if (!file.canRead()) {
                    linkedList.add("Search path passed to ConfigMgr.load() is not readable:  searchPath=[" + string + "]");
                    continue;
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.isFile() || !file2.getAbsolutePath().toLowerCase().endsWith(".cfg")) continue;
                    ConfigFile configFile = null;
                    try {
                        configFile = new ConfigFile(file2.getAbsolutePath());
                        if (configFileTable.containsKey(configFile.name)) continue;
                        configFileTable.put(configFile.name, configFile);
                        continue;
                    }
                    catch (ConfigRuntimeException configRuntimeException) {
                        linkedList.addAll(configRuntimeException.getErrors());
                    }
                }
            }
            object2 = configFileTable.values().iterator();
            while (object2.hasNext()) {
                object = (ConfigFile)object2.next();
                try {
                    ((ConfigFile)object).resolveAllValues();
                    ((ConfigFile)object).save();
                }
                catch (ConfigRuntimeException configRuntimeException) {
                    linkedList.addAll(configRuntimeException.getErrors());
                }
            }
        }
        if (!linkedList.isEmpty()) {
            loadErrorsException = new ConfigRuntimeException("Problems occurred while trying to load configuration files into memory. ", linkedList);
        }
        if (loadErrorsException != null) {
            throw loadErrorsException;
        }
    }

    public static void reload() throws ConfigRuntimeException {
        String string = StringUtils.join(configSearchPaths.toArray(), File.pathSeparator);
        configSearchPaths.clear();
        configFileTable.clear();
        ConfigMgr.load(string);
    }

    public static void addPath(String string) throws ConfigRuntimeException {
        ConfigMgr.load(StringUtils.join(configSearchPaths.toArray(), File.pathSeparator) + File.pathSeparator + string);
    }

    public static void set(String string, String string2, boolean bl) throws ConfigRuntimeException {
        ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).setValue(ConfigMgr.getLastTokens(string), string2, bl);
    }

    public static void set(String string, String string2, String string3, boolean bl) throws ConfigRuntimeException {
        ConfigMgr.getConfigFile(string).setValue(string2, string3, bl);
    }

    public static String get(String string) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).getValue(ConfigMgr.getLastTokens(string));
    }

    public static String get(String string, String string2) {
        String string3 = string2;
        try {
            string3 = ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).getValue(ConfigMgr.getLastTokens(string), string2);
            if (StringUtils.isEmpty(string3)) {
                string3 = string2;
            }
        }
        catch (ConfigRuntimeException configRuntimeException) {
            string3 = string2;
        }
        return string3;
    }

    public static String get(String string, Object[] objectArray) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).getValue(ConfigMgr.getLastTokens(string), objectArray);
    }

    public static String get(String string, Object[] objectArray, String string2) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).getValue(ConfigMgr.getLastTokens(string), objectArray, string2);
    }

    public static boolean getBoolean(String string) throws ConfigRuntimeException {
        String string2 = ConfigMgr.get(string).toUpperCase();
        int n = string2.length() == 0 ? 70 : (int)string2.charAt(0);
        return n == 84 || n == 89 || n == 49;
    }

    public static long getTime(String string) throws ConfigRuntimeException {
        String string2 = ConfigMgr.get(string).toUpperCase();
        try {
            return StringUtils.parseTime(string2);
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Invalid value for key [" + string + "].  " + exception.getMessage());
        }
    }

    public static boolean getBoolean(String string, boolean bl) throws ConfigRuntimeException {
        String string2 = ConfigMgr.get(string, "" + bl).toUpperCase();
        int n = string2.length() == 0 ? 70 : (int)string2.charAt(0);
        return n == 84 || n == 89 || n == 49;
    }

    public static int getInt(String string) throws ConfigRuntimeException {
        try {
            return Integer.parseInt(ConfigMgr.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigRuntimeException("Cannot return value as int for key [" + string + "].  Value was [" + ConfigMgr.get(string) + "].");
        }
    }

    public static int getInt(String string, int n) throws ConfigRuntimeException {
        try {
            return Integer.parseInt(ConfigMgr.get(string, "" + n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigRuntimeException("Cannot return value as int for key [" + string + "].  Value was [" + ConfigMgr.get(string) + "].");
        }
    }

    public static Set getKeyNames(String string) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).getKeyNamesInSection(ConfigMgr.getLastTokens(string));
    }

    public static boolean isEncoded(String string, String string2) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(string).isEncoded(string2);
    }

    public static boolean isEncoded(String string) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).isEncoded(ConfigMgr.getLastTokens(string));
    }

    public static Hashtable getSection(String string) throws ConfigRuntimeException {
        try {
            Map map = (Map)ConfigMgr.getConfigFile((String)ConfigMgr.getFirstToken((String)string)).sectionValuesMap.get(ConfigMgr.getLastTokens(string));
            if (map == null) {
                throw new ConfigRuntimeException("Section not found for key [" + string + "].");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ConfigEntry configEntry = (ConfigEntry)iterator.next();
                hashtable.put(configEntry.propName, configEntry.getValue());
            }
            return hashtable;
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught in method ConfigMgr.getSection() for key [" + string + "]", exception);
        }
    }

    public static Map getConfigMap(String string) throws ConfigRuntimeException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Map map = ConfigMgr.getConfigFile((String)string).allValuesMap;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            treeMap.put(string2, ((ConfigEntry)map.get(string2)).getValue());
        }
        return treeMap;
    }

    public static void save() throws ConfigRuntimeException {
        Iterator iterator = configFileTable.values().iterator();
        while (iterator.hasNext()) {
            ((ConfigFile)iterator.next()).save();
        }
    }

    public static void createBatchEnvFile(String string, String string2, boolean bl, boolean bl2) throws ConfigRuntimeException {
        try {
            ConfigFile configFile = ConfigMgr.getConfigFile(string);
            StringBuffer stringBuffer = new StringBuffer("echo off\n\n");
            stringBuffer.append("rem This file was automatically generated from the contents in the " + string + ".cfg file\n\n");
            stringBuffer.append("rem version 2\n\n");
            if (string.indexOf(46) > -1) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            Object object = configFile.sectionList.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                LinkedList linkedList = (LinkedList)configFile.sectionContents.get(string3);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (string4.length() > 0 && string4.charAt(0) == '=') {
                        ConfigEntry configEntry = (ConfigEntry)configFile.allValuesMap.get(string4.substring(1));
                        stringBuffer.append("set " + configEntry.configKey.replace('.', '_') + "=" + configEntry.getValue() + "\n");
                        continue;
                    }
                    stringBuffer.append("rem " + string4 + "\n");
                }
            }
            object = new FileWriter(string2);
            ((Writer)object).write(stringBuffer.toString().toCharArray());
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught while trying to generate batch file [" + string2 + "].");
        }
    }

    public static void createShellEnvFile(String string, String string2, boolean bl, boolean bl2) throws ConfigRuntimeException {
        try {
            ConfigFile configFile = ConfigMgr.getConfigFile(string);
            StringBuffer stringBuffer = new StringBuffer("#!/bin/sh\n\n");
            stringBuffer.append("# This file was automatically generated from the contents in the " + string + ".cfg file\n\n");
            stringBuffer.append("# version 2\n\n");
            if (string.indexOf(46) > -1) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            Object object = configFile.sectionList.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                LinkedList linkedList = (LinkedList)configFile.sectionContents.get(string3);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (string4.length() > 0 && string4.charAt(0) == '=') {
                        ConfigEntry configEntry = (ConfigEntry)configFile.allValuesMap.get(string4.substring(1));
                        stringBuffer.append("export " + configEntry.configKey.replace('.', '_') + "=\"" + ConfigMgr.replace(configEntry.getValue(), "\\", "\\\\") + "\"\n");
                        continue;
                    }
                    stringBuffer.append((string4.startsWith("#") ? "" : "# ") + string4 + "\n");
                }
            }
            object = new FileWriter(string2);
            ((Writer)object).write(stringBuffer.toString().toCharArray());
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught while trying to generate batch file [" + string2 + "].");
        }
    }

    private static String replace(String string, String string2, String string3) {
        int n = -1;
        while ((n = string.indexOf(string2, n + 1)) != -1) {
            string = string.substring(0, n) + string3 + string.substring(n += string2.length());
        }
        return string;
    }

    public static ConfigFile getConfigFile(String string) throws ConfigRuntimeException {
        Object object;
        if (string.indexOf(46) == -1) {
            string = string + ".cfg";
        }
        if (!configFileTable.containsKey(string)) {
            boolean bl = false;
            Iterator iterator = configSearchPaths.iterator();
            while (iterator.hasNext() && !bl) {
                String string2 = (String)iterator.next();
                object = new File(string2 + File.separator + string);
                try {
                    if (!((File)object).exists() || !((File)object).getCanonicalFile().getName().equals(string)) continue;
                    configFileTable.put(string, new ConfigFile(((File)object).getAbsolutePath()));
                    bl = true;
                }
                catch (Exception exception) {
                    throw new ConfigRuntimeException("Unexpected exception caught in ConfigMgr.getConfigFile(" + string + "):  msg=[" + exception.getLocalizedMessage() + "]", exception);
                }
            }
        }
        if ((object = (ConfigFile)configFileTable.get(string)) == null) {
            throw new ConfigRuntimeException("Could not find configuration file [" + string + "] " + "in search path [" + ConfigMgr.getSearchPath() + "]");
        }
        if (((ConfigFile)object).hasBeenModified) {
            try {
                ((ConfigFile)object).save();
            }
            catch (ConfigRuntimeException configRuntimeException) {
                System.err.println("WARNING:  Could not save configuration file [" + string + "].  File is read-only.  File may now contain unencoded passwords.");
                ((ConfigFile)object).hasBeenModified = false;
            }
        }
        return object;
    }

    private static String getSearchPath() {
        String string = "";
        for (int i = 0; i < configSearchPaths.size(); ++i) {
            string = string + configSearchPaths.get(i) + File.pathSeparator;
        }
        return string;
    }

    public static Hashtable getAllValues(boolean bl) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = configSearchPaths.iterator();
        while (iterator.hasNext()) {
            File file = new File((String)iterator.next());
            if (!file.exists() || !file.isDirectory()) continue;
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith("cfg");
                }
            });
            for (int i = 0; i < stringArray.length; ++i) {
                ConfigFile configFile = ConfigMgr.getConfigFile(stringArray[i]);
                String string = stringArray[i].substring(0, stringArray[i].indexOf(46));
                Iterator iterator2 = configFile.allValuesMap.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    ConfigEntry configEntry = (ConfigEntry)configFile.allValuesMap.get(string2);
                    String string3 = null;
                    string3 = bl ? configEntry.getValue() : (configEntry.isEncoded ? PasswordUtil.decode(configEntry.rawValue) : configEntry.rawValue);
                    hashtable.put(string + "." + string2, string3);
                }
            }
        }
        return hashtable;
    }

    public static Hashtable getAllValues() throws Exception {
        return ConfigMgr.getAllValues(true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ConfigMgr.printUsageAndExit();
        }
        if (stringArray[0].equals("setVals")) {
            CharSequence charSequence;
            String string = null;
            LinkedList<String> linkedList = new LinkedList<String>();
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                System.out.println("looking at arg [" + stringArray[i] + "]");
                if (stringArray[i].equals("-searchPath") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-vals")) {
                    charSequence = new StringBuffer();
                    while (i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                        ((StringBuffer)charSequence).append(stringArray[++i] + " ");
                    }
                    String[] stringArray2 = StringUtils.split(((StringBuffer)charSequence).toString());
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (j % 2 != 1) continue;
                        linkedList.add(stringArray2[j - 1] + "=" + stringArray2[j]);
                    }
                    continue;
                }
                if (!stringArray[i].equals("-verbose")) continue;
                bl = true;
            }
            if (string == null || linkedList.size() == 0) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (bl) {
                    System.out.println("Setting search path to [" + string + "]");
                }
                ConfigMgr.load(string);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    charSequence = (String)iterator.next();
                    System.out.println("Command=[" + (String)charSequence + "]");
                    int n = ((String)charSequence).indexOf(61);
                    if (n == -1) {
                        ConfigMgr.printUsageAndExit();
                    }
                    String string2 = ((String)charSequence).substring(0, n);
                    String string3 = ((String)charSequence).substring(n + 1);
                    if (bl) {
                        System.out.println("Setting [" + string2 + "] to [" + string3 + "]");
                    }
                    ConfigMgr.set(string2, string3, false);
                }
                if (bl) {
                    System.out.println("Saving...");
                }
                ConfigMgr.save();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            if (bl) {
                System.out.println("Done.");
            }
        } else if (stringArray[0].equals("createShellEnvFile") && stringArray.length >= 3) {
            String string = null;
            String string4 = null;
            String string5 = null;
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-searchPath") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-configFile") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-batchPathname") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (!stringArray[i].equals("-verbose")) continue;
                bl = true;
            }
            if (string == null || string4 == null || string5 == null) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (bl) {
                    System.out.println("creating shell script [" + string5 + "]...");
                }
                ConfigMgr.load(string);
                ConfigMgr.createShellEnvFile(string4, string5, false, bl);
                if (bl) {
                    System.out.println("Done.");
                }
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else if (stringArray[0].equals("createBatchEnvFile") && stringArray.length >= 3) {
            String string = null;
            String string6 = null;
            String string7 = null;
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-searchPath") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-configFile") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-batchPathname") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string7 = stringArray[++i];
                    continue;
                }
                if (!stringArray[i].equals("-verbose")) continue;
                bl = true;
            }
            if (string == null || string6 == null || string7 == null) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (bl) {
                    System.out.println("creating batch file [" + string7 + "]...");
                }
                ConfigMgr.load(string);
                ConfigMgr.createBatchEnvFile(string6, string7, false, bl);
                if (bl) {
                    System.out.println("Done.");
                }
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else {
            ConfigMgr.printUsageAndExit();
        }
    }

    public static void printUsageAndExit() {
        System.err.println("---Usage---");
        System.err.println("java -jar ConfigMgr.jar createBatchEnvFile -searchPath <searchPath> -configFile <configFile> -batchPathname <batchFilePath> [-verbose]");
        System.err.println("java -jar ConfigMgr.jar createShellEnvFile -searchPath <searchPath> -configFile <configFile> -batchPathname <batchFilePath> [-verbose]");
        System.err.println("java -jar ConfigMgr.jar setVals -searchPath <searchPath> -vals [var1 val1 [var2 val2...]] [-verbose]");
        System.exit(2);
    }

    private static String getFirstToken(String string) throws ConfigRuntimeException {
        if (string.indexOf(46) == -1) {
            throw new ConfigRuntimeException("Invalid config key [" + string + "].  " + "Must be of the format [config.key] or [config.section.key]");
        }
        return string.substring(0, string.indexOf(46));
    }

    private static String getLastTokens(String string) throws ConfigRuntimeException {
        if (string.indexOf(46) == -1) {
            throw new ConfigRuntimeException("Invalid config key [" + string + "].  " + "Must be of the format [config.key] or [config.section.key]");
        }
        return string.substring(string.indexOf(46) + 1);
    }
}

