/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jjson;

import com.ibm.jjson.JsonList;
import com.ibm.jjson.JsonMap;
import com.ibm.jjson.JsonParseException;
import com.ibm.jjson.JsonUtils;

public class JsonParser {
    private static final long serialVersionUID = 1L;

    protected JsonParser() {
    }

    public static Object parse(String string) throws JsonParseException {
        MutableInt mutableInt = new MutableInt(0);
        char[] cArray = string.toCharArray();
        Object object = JsonParser.parseAnything(cArray, mutableInt);
        JsonParser.validateEnd(cArray, mutableInt);
        return object;
    }

    protected static void parseInto(String string, Object object) throws JsonParseException {
        MutableInt mutableInt = new MutableInt(0);
        char[] cArray = string.toCharArray();
        if (object instanceof JsonMap) {
            JsonParser.parseObject((JsonMap)object, cArray, mutableInt);
        } else if (object instanceof JsonList) {
            JsonParser.parseArray((JsonList)object, cArray, mutableInt);
        }
        JsonParser.validateEnd(cArray, mutableInt);
    }

    private static void validateEnd(char[] cArray, MutableInt mutableInt) throws JsonParseException {
        if (mutableInt.val == cArray.length) {
            return;
        }
        JsonParser.skipCommentsAndSpace(cArray, mutableInt, true);
        if (mutableInt.val < cArray.length) {
            throw new JsonParseException(cArray, mutableInt.val, "Remainder after parse.");
        }
    }

    private static Object parseAnything(char[] cArray, MutableInt mutableInt) throws JsonParseException {
        if (cArray.length == 0) {
            return null;
        }
        char c = cArray[mutableInt.val];
        if (c == '{') {
            return JsonParser.parseObject(new JsonMap(), cArray, mutableInt);
        }
        if (c == '[') {
            return JsonParser.parseArray(new JsonList(), cArray, mutableInt);
        }
        if (c == '\'' || c == '\"') {
            return JsonParser.parseString(cArray, mutableInt);
        }
        if (c >= '0' && c <= '9' || c == '-') {
            return JsonParser.parseNumber(cArray, mutableInt);
        }
        if (c == 't') {
            mutableInt.val += 4;
            return Boolean.TRUE;
        }
        if (c == 'f') {
            mutableInt.val += 5;
            return Boolean.FALSE;
        }
        if (c == 'n') {
            mutableInt.val += 4;
            return null;
        }
        if (c == '/' || Character.isWhitespace(c)) {
            JsonParser.skipCommentsAndSpace(cArray, mutableInt, true);
            return JsonParser.parseAnything(cArray, mutableInt);
        }
        throw new JsonParseException(cArray, mutableInt.val, "Unrecognized syntax");
    }

    private static void skipCommentsAndSpace(char[] cArray, MutableInt mutableInt, boolean bl) {
        while (mutableInt.val < cArray.length) {
            char c = cArray[mutableInt.val];
            if (!Character.isWhitespace(c)) {
                if (c == '/') {
                    JsonParser.skipComments(cArray, mutableInt);
                } else {
                    if (!bl) {
                        --mutableInt.val;
                    }
                    return;
                }
            }
            ++mutableInt.val;
        }
    }

    private static void skipComments(char[] cArray, MutableInt mutableInt) {
        block3: {
            char c;
            block2: {
                if ((c = cArray[++mutableInt.val]) != '*') break block2;
                while (mutableInt.val < cArray.length) {
                    if (cArray[++mutableInt.val] != '*' || cArray[++mutableInt.val] != '/') continue;
                    return;
                }
                break block3;
            }
            if (c != '/') break block3;
            while (mutableInt.val < cArray.length) {
                if (cArray[++mutableInt.val] != '\n') continue;
                return;
            }
        }
        throw new JsonParseException(cArray, mutableInt.val, "Unrecognized syntax");
    }

    protected static Number parseNumber(char[] cArray, MutableInt mutableInt) {
        int n = mutableInt.val;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (cArray[n] == '-') {
            ++n;
        }
        if (cArray[n] != '0') {
            bl = true;
        }
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == 'x' || c == 'X') {
                bl2 = true;
            } else if (c == '.') {
                bl3 = true;
            } else if (!(c >= '0' && c <= '9' || bl2 && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) && (!bl3 || c != 'e' && c != 'E' && c != '+' && c != '-')) break;
            ++n;
        }
        String string = new String(cArray, mutableInt.val, n - mutableInt.val);
        Number number = null;
        if (bl3) {
            number = Double.valueOf(string);
        } else if (bl2) {
            string = cArray[mutableInt.val] == '-' ? '-' + string.substring(3) : string.substring(2);
            number = n - mutableInt.val > 7 ? (Number)Long.valueOf(string, 16) : (Number)Integer.valueOf(string, 16);
        } else {
            number = bl ? (Number)(n - mutableInt.val > 8 ? (Number)Long.valueOf(string, 10) : (Number)Integer.valueOf(string, 10)) : (Number)(n - mutableInt.val > 9 ? (Number)Long.valueOf(string, 8) : (Number)Integer.valueOf(string, 8));
        }
        mutableInt.val = n;
        return number;
    }

    private static String parseString(char[] cArray, MutableInt mutableInt) throws JsonParseException {
        char c;
        char c2 = cArray[mutableInt.val++];
        int n = mutableInt.val;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        while (mutableInt.val < cArray.length && string == null) {
            c = cArray[mutableInt.val];
            if (c == '\\') {
                bl = !bl;
                bl2 = true;
            } else if (!bl && c == c2) {
                string = new String(cArray, n, mutableInt.val - n);
            } else {
                bl = false;
            }
            ++mutableInt.val;
        }
        if (string == null) {
            throw new JsonParseException(cArray, n, "Could not find expected end character [" + c2 + "].");
        }
        if (bl2) {
            string = JsonUtils.unEscapeChars(string, new char[]{'\'', '\"'});
        }
        n = mutableInt.val;
        while (mutableInt.val < cArray.length) {
            c = cArray[mutableInt.val];
            if (c == '+') {
                while (mutableInt.val < cArray.length) {
                    char c3;
                    if ((c3 = cArray[++mutableInt.val]) == '\"' || c3 == '\'') {
                        return string + JsonParser.parseString(cArray, mutableInt);
                    }
                    if (c3 == '/') {
                        JsonParser.skipCommentsAndSpace(cArray, mutableInt, false);
                        continue;
                    }
                    if (Character.isWhitespace(c3)) continue;
                    throw new JsonParseException(cArray, n, "Expected [\"] or ['] following [+].  c2=[" + c3 + "]");
                }
            } else if (c == '/') {
                JsonParser.skipCommentsAndSpace(cArray, mutableInt, false);
            } else if (!Character.isWhitespace(c)) break;
            ++mutableInt.val;
        }
        mutableInt.val = n;
        return string;
    }

    protected static JsonList parseArray(JsonList jsonList, char[] cArray, MutableInt mutableInt) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = n;
        while (mutableInt.val < cArray.length) {
            char c = cArray[mutableInt.val];
            if (n4 == n) {
                if (c == '[') {
                    n4 = n2;
                }
            } else if (n4 == n2) {
                if (c == ']') {
                    ++mutableInt.val;
                    return jsonList;
                }
                if (c == '/') {
                    JsonParser.skipCommentsAndSpace(cArray, mutableInt, false);
                } else if (!Character.isWhitespace(c)) {
                    jsonList.add(JsonParser.parseAnything(cArray, mutableInt));
                    --mutableInt.val;
                    n4 = n3;
                }
            } else if (n4 == n3) {
                if (c == ',') {
                    n4 = n2;
                } else if (c == '/') {
                    JsonParser.skipCommentsAndSpace(cArray, mutableInt, false);
                } else if (c == ']') {
                    ++mutableInt.val;
                    return jsonList;
                }
            }
            ++mutableInt.val;
        }
        if (n4 == n) {
            throw new JsonParseException(cArray, mutableInt.val, "Expected '[' at beginning of JSON array.");
        }
        if (n4 == n2) {
            throw new JsonParseException(cArray, mutableInt.val, "Expected one of the following characters: {,[,',\",LITERAL.");
        }
        if (n4 == n3) {
            throw new JsonParseException(cArray, mutableInt.val, "Expected ',' or ']'.");
        }
        return null;
    }

    private static String parseFieldName(char[] cArray, MutableInt mutableInt) {
        char c;
        int n = mutableInt.val;
        char c2 = cArray[n];
        char c3 = c = c2 == '\'' || c2 == '\"' ? c2 : (char)'\u0000';
        if (c == '\u0000') {
            while (mutableInt.val < cArray.length) {
                c2 = cArray[mutableInt.val];
                if (c2 == ':' || Character.isWhitespace(c2) || c2 == '/') {
                    return new String(cArray, n, mutableInt.val - n).intern();
                }
                ++mutableInt.val;
            }
        } else {
            boolean bl = false;
            ++n;
            ++mutableInt.val;
            while (mutableInt.val < cArray.length) {
                c2 = cArray[mutableInt.val];
                if (c2 == '\\') {
                    bl = !bl;
                } else if (c2 == c && !bl) {
                    String string = new String(cArray, n, mutableInt.val - n);
                    mutableInt.val = n + 1;
                    return string.intern();
                }
                ++mutableInt.val;
            }
        }
        throw new JsonParseException(cArray, mutableInt.val, "Couldn't find the end of the field name.");
    }

    protected static JsonMap parseObject(JsonMap jsonMap, char[] cArray, MutableInt mutableInt) {
        int n = 0;
        int n2 = 1;
        int n3 = 3;
        int n4 = 4;
        int n5 = 5;
        int n6 = n;
        String string = null;
        while (mutableInt.val < cArray.length) {
            char c = cArray[mutableInt.val];
            if (n6 == n) {
                if (c == '{') {
                    n6 = n2;
                }
            } else if (n6 == n2) {
                if (c == '}') {
                    ++mutableInt.val;
                    return jsonMap;
                }
                if (c == '/') {
                    JsonParser.skipCommentsAndSpace(cArray, mutableInt, false);
                } else if (!Character.isWhitespace(c)) {
                    string = JsonParser.parseFieldName(cArray, mutableInt);
                    --mutableInt.val;
                    n6 = n3;
                }
            } else if (n6 == n3) {
                if (c == ':') {
                    n6 = n4;
                }
            } else if (n6 == n4) {
                if (c == '/') {
                    JsonParser.skipCommentsAndSpace(cArray, mutableInt, false);
                } else if (!Character.isWhitespace(c)) {
                    jsonMap.put(string, JsonParser.parseAnything(cArray, mutableInt));
                    --mutableInt.val;
                    n6 = n5;
                }
            } else if (n6 == n5) {
                if (c == ',') {
                    n6 = n2;
                } else if (c == '/') {
                    JsonParser.skipCommentsAndSpace(cArray, mutableInt, false);
                } else if (c == '}') {
                    ++mutableInt.val;
                    return jsonMap;
                }
            }
            ++mutableInt.val;
        }
        if (n6 == n) {
            throw new JsonParseException(cArray, mutableInt.val, "Expected '{' at beginning of JSON object.");
        }
        if (n6 == n2) {
            throw new JsonParseException(cArray, mutableInt.val, "Could not find attribute name on JSON object.");
        }
        if (n6 == n3) {
            throw new JsonParseException(cArray, mutableInt.val, "Could not find ':' following attribute name on JSON object.");
        }
        if (n6 == n4) {
            throw new JsonParseException(cArray, mutableInt.val, "Expected one of the following characters: {,[,',\",LITERAL.");
        }
        if (n6 == n5) {
            throw new JsonParseException(cArray, mutableInt.val, "Could not find '}' marking end of JSON object.");
        }
        return null;
    }

    static class MutableInt {
        int val = 0;

        public MutableInt(int n) {
            this.val = n;
        }
    }
}

