/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;

public class XPath {
    SinglePath[] singlePaths;
    protected static String validXmlChars = "[\\w\\d\\.\\_\\-]+";
    protected static Pattern p1 = Pattern.compile("^(" + validXmlChars + ")\\[\\@(" + validXmlChars + ")\\=(\\S+)\\]$");

    public XPath(String string) throws TransformerException {
        try {
            String[] stringArray = StringUtils.split(string, '|');
            this.singlePaths = new SinglePath[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.singlePaths[i] = new SinglePath(stringArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new TransformerException("Invalid/unsupported XPath encountered:  [" + string + "]");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XPath: ");
        for (int i = 0; i < this.singlePaths.length; ++i) {
            stringBuffer.append("[" + this.singlePaths[i] + "] ");
        }
        return stringBuffer.toString();
    }

    static class Token {
        short type;
        String name;
        String attrMatchName;
        String attrMatchVal;
        Matcher m;

        protected Token(String string) {
            string = string.replaceFirst("child::", "");
            string = string.replaceAll("[\"']+", "");
            if (string.length() == 0) {
                throw new RuntimeException();
            }
            if (string.charAt(0) == '@') {
                this.type = (short)2;
                this.name = string.substring(1);
            } else {
                this.m = p1.matcher(string);
                if (this.m.matches()) {
                    this.type = 1;
                    this.name = this.m.group(1);
                    this.attrMatchName = this.m.group(2);
                    this.attrMatchVal = this.m.group(3);
                } else if (string.matches("text\\(\\)")) {
                    this.type = (short)3;
                } else if (string.matches(validXmlChars)) {
                    this.type = 1;
                    this.name = string;
                } else {
                    throw new RuntimeException();
                }
            }
        }

        public String toString() {
            return "type=" + this.type + ",name=" + this.name + ",attrMatchName=" + this.attrMatchName + ",attrMatchVal=" + this.attrMatchVal;
        }
    }

    static class SinglePath {
        public static int RELATIVE = 0;
        public static int ABSOLUTE = 1;
        public static int ALL = 2;
        public int spType;
        public Token[] tokens;

        public SinglePath(String string) {
            if (string.startsWith("//")) {
                this.spType = ALL;
                string = string.substring(2);
            } else if (string.startsWith("/")) {
                this.spType = ABSOLUTE;
                string = string.substring(1);
            } else {
                this.spType = RELATIVE;
            }
            String[] stringArray = StringUtils.split(string, '/');
            this.tokens = new Token[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.tokens[i] = new Token(stringArray[i]);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("spType=[" + this.spType + "],");
            for (int i = 0; i < this.tokens.length; ++i) {
                stringBuffer.append("[" + this.tokens[i] + "]");
            }
            return stringBuffer.toString();
        }
    }
}

