/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.IMatcher;
import com.ibm.dmh.util.StringUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberMatcher
implements IMatcher<Number> {
    private NumberPattern[] numberPatterns;

    public NumberMatcher(String string) {
        this.numberPatterns = new NumberPattern[1];
        this.numberPatterns[0] = new NumberPattern(string);
    }

    public NumberMatcher(String[] stringArray) {
        this.numberPatterns = new NumberPattern[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.numberPatterns[i] = new NumberPattern(stringArray[i]);
        }
    }

    @Override
    public boolean matches(Number number) {
        for (int i = 0; i < this.numberPatterns.length; ++i) {
            if (this.numberPatterns[i].matches(number)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Integer n) {
        if (n == null) {
            return false;
        }
        return this.matches((int)n);
    }

    private class NumberRange {
        int start;
        int end;
        boolean isNot;

        public NumberRange(String string, String string2, String string3, boolean bl) {
            this.isNot = bl;
            if (string.equals("") && string3 == null) {
                this.end = this.start = Integer.parseInt(string2);
            } else if (string.equals(">")) {
                this.start = Integer.parseInt(string2) + 1;
                this.end = Integer.MAX_VALUE;
            } else if (string.equals(">=")) {
                this.start = Integer.parseInt(string2);
                this.end = Integer.MAX_VALUE;
            } else if (string.equals("<")) {
                this.start = Integer.MIN_VALUE;
                this.end = Integer.parseInt(string2) - 1;
            } else if (string.equals("<=")) {
                this.start = Integer.MIN_VALUE;
                this.end = Integer.parseInt(string2);
            } else {
                this.start = Integer.parseInt(string2);
                this.end = Integer.parseInt(string3);
            }
        }

        public boolean matches(Number number) {
            boolean bl;
            long l = number.longValue();
            boolean bl2 = bl = l >= (long)this.start && l <= (long)this.end;
            if (this.isNot) {
                bl = !bl;
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NumberPattern {
        NumberRange[] numberRanges;

        public NumberPattern(String string) {
            LinkedList<NumberRange> linkedList = new LinkedList<NumberRange>();
            for (String string2 : this.breakUpTokens(string)) {
                boolean bl = string2.charAt(0) == '!';
                String string3 = string2.substring(1);
                Pattern pattern = Pattern.compile("(([<>]=?)?)(-?\\d+)(-?(-?\\d+)?)");
                Matcher matcher = pattern.matcher(string3);
                if (!matcher.matches()) {
                    throw new RuntimeException("Numeric value didn't match pattern:  [" + string3 + "]");
                }
                String string4 = matcher.group(1);
                String string5 = matcher.group(3);
                String string6 = matcher.group(5);
                linkedList.add(new NumberRange(string4, string5, string6, bl));
            }
            this.numberRanges = linkedList.toArray(new NumberRange[linkedList.size()]);
        }

        private List<String> breakUpTokens(String string) {
            string = string.replaceAll("(-?\\d+)\\s*-\\s*(-?\\d+)", "$1-$2");
            string = string.replaceAll("([<>]=?)\\s+(-?\\d+)", "$1$2");
            string = string.replaceAll("(!)\\s+(-?\\d+)", "$1$2");
            string = string.replaceAll(",", " ");
            String[] stringArray = StringUtils.split(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("!")) continue;
                stringArray[i] = "^" + stringArray[i];
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(Arrays.asList(stringArray));
            return linkedList;
        }

        public boolean matches(Number number) {
            if (this.numberRanges.length == 0) {
                return true;
            }
            for (int i = 0; i < this.numberRanges.length; ++i) {
                if (!this.numberRanges[i].matches(number)) continue;
                return true;
            }
            return false;
        }
    }
}

