/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingMap<K, V>
extends ConcurrentHashMap<K, V> {
    private Semaphore semaphore = new Semaphore(1);

    public boolean waitUntilEmpty(long l, TimeUnit timeUnit) {
        try {
            if (!this.semaphore.tryAcquire(l, timeUnit)) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public V put(K k, V v) {
        V v2 = super.put(k, v);
        this.setSemaphoreState();
        return v2;
    }

    @Override
    public V remove(Object object) {
        Object v = super.remove(object);
        this.setSemaphoreState();
        return v;
    }

    @Override
    public void clear() {
        super.clear();
        this.setSemaphoreState();
    }

    private void setSemaphoreState() {
        try {
            if (this.isEmpty()) {
                if (this.semaphore.availablePermits() == 0) {
                    this.semaphore.release();
                }
            } else if (this.semaphore.availablePermits() == 1) {
                this.semaphore.acquire();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

