/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.msg;

import com.ibm.dmh.msg.WsaaMessageTextGeneric;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsaaMessageGeneric {
    public static final int INFORMATION_STATUS = 0;
    public static final int WARNING_STATUS = 1;
    public static final int ERROR_STATUS = 2;
    public static final int SEVERE_STATUS = 3;
    private final WsaaMessageTextGeneric module;
    private final WsaaMessageTextGeneric explanation;
    private final WsaaMessageTextGeneric systemAction;
    private final WsaaMessageTextGeneric userResponse;
    private final WsaaMessageTextGeneric identifier;
    private final WsaaMessageTextGeneric title;

    public WsaaMessageGeneric(String string, String string2, String string3, String string4, String string5, String string6) {
        this.identifier = new WsaaMessageTextGeneric(string);
        this.title = new WsaaMessageTextGeneric(string2);
        this.module = new WsaaMessageTextGeneric(string3);
        this.explanation = new WsaaMessageTextGeneric(string4);
        this.systemAction = new WsaaMessageTextGeneric(string5);
        this.userResponse = new WsaaMessageTextGeneric(string6);
    }

    WsaaMessageGeneric(WsaaMessageTextGeneric wsaaMessageTextGeneric, WsaaMessageTextGeneric wsaaMessageTextGeneric2, WsaaMessageTextGeneric wsaaMessageTextGeneric3, WsaaMessageTextGeneric wsaaMessageTextGeneric4, WsaaMessageTextGeneric wsaaMessageTextGeneric5, WsaaMessageTextGeneric wsaaMessageTextGeneric6) {
        this.identifier = wsaaMessageTextGeneric;
        this.title = wsaaMessageTextGeneric2;
        this.module = wsaaMessageTextGeneric3;
        this.explanation = wsaaMessageTextGeneric4;
        this.systemAction = wsaaMessageTextGeneric5;
        this.userResponse = wsaaMessageTextGeneric6;
    }

    WsaaMessageGeneric(String string) {
        this(string, "", "", "", "", "");
    }

    public WsaaMessageTextGeneric getIdentifier() {
        return this.identifier;
    }

    public WsaaMessageTextGeneric getExplanation() {
        return this.explanation;
    }

    public WsaaMessageTextGeneric getModule() {
        return this.module;
    }

    public WsaaMessageTextGeneric getSystemAction() {
        return this.systemAction;
    }

    public WsaaMessageTextGeneric getUserResponse() {
        return this.userResponse;
    }

    public Level getSeverity() {
        return WsaaMessageGeneric.getSeverity(this.identifier.getText());
    }

    static Level getSeverity(String string) {
        char c = Character.toUpperCase(string.charAt(string.length() - 1));
        switch (c) {
            case 'I': {
                return Level.INFO;
            }
            case 'W': {
                return Level.WARNING;
            }
        }
        return Level.SEVERE;
    }

    public int getMessageNumber() {
        return Integer.parseInt(this.identifier.getText().substring(3, 7));
    }

    public final WsaaMessageTextGeneric getTitle() {
        return this.title;
    }

    SortedSet<String> getParameters() {
        TreeSet<String> treeSet = new TreeSet<String>();
        this.getVariables(this.identifier, treeSet);
        this.getVariables(this.title, treeSet);
        this.getVariables(this.module, treeSet);
        this.getVariables(this.explanation, treeSet);
        this.getVariables(this.systemAction, treeSet);
        this.getVariables(this.userResponse, treeSet);
        return treeSet;
    }

    void getVariables(WsaaMessageTextGeneric wsaaMessageTextGeneric, Set<String> set) {
        String string = wsaaMessageTextGeneric.getXml();
        String string2 = "";
        int n = 0;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c != '<') continue block7;
                    n = 1;
                    continue block7;
                }
                case 1: {
                    if (c == 'm' || c == 'M') {
                        n = 2;
                        continue block7;
                    }
                    if (Character.isWhitespace(c)) continue block7;
                    n = 0;
                    continue block7;
                }
                case 2: {
                    if (c == 'v' || c == 'V') {
                        n = 3;
                        continue block7;
                    }
                    n = 0;
                    continue block7;
                }
                case 3: {
                    if (c != '>') continue block7;
                    n = 4;
                    continue block7;
                }
                case 4: {
                    if (c == '<') {
                        set.add(string2);
                        string2 = "";
                        n = 0;
                        continue block7;
                    }
                    string2 = string2 + c;
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WsaaMessageGeneric) {
            return this.getMessageNumber() == ((WsaaMessageGeneric)object).getMessageNumber();
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.getMessageNumber();
    }

    public String getPrefix() {
        return this.identifier.getText().substring(0, 3);
    }
}

