/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbFlags;
import com.ibm.dmh.db.DbResultSet;
import com.ibm.dmh.db.DbUtil;
import com.ibm.dmh.db.SQLRuntimeException;
import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbPreparedStatement {
    private static Logger logger = LoggerManager.getMainLogger();
    private static boolean debug = logger.isLoggable(Level.FINE);
    protected String sql;
    protected String sqlFixed;
    private int[] columnSizes;
    private int[] sqlTypes;
    protected Object[] currentParams;
    protected int flags;
    protected PreparedStatement ps;
    public int executeSize;
    public int commitSize;
    public int maxBatchExecuteSize = Integer.MAX_VALUE;
    public int maxBatchCommitSize = Integer.MAX_VALUE;
    public int commitWeight = 1;
    public long updateCount;
    public long updateTime;
    public String[] autoLock = new String[0];
    private Connection connection;
    private static Pattern sqlVarPattern = Pattern.compile("\\?(?:\\:(?:([\\w\\d\\_]+)(?:\\((\\d+)\\))?))?");
    Pattern isQueryPattern = Pattern.compile("^\\s*(?:select|with).*", 34);
    Pattern modifiedTablePattern = Pattern.compile("^\\s*(?:insert\\s+into|delete\\s+from|update|delete\\s+from\\s*\\(?\\s*select\\s+.*\\s+from)\\s+\\$\\(SCHEMA\\)\\.([\\d\\w\\_]+).*", 34);

    protected DbPreparedStatement() {
    }

    protected DbPreparedStatement(int n, Connection connection, CharSequence charSequence) throws SQLRuntimeException {
        this.connection = connection;
        this.flags = n;
        this.sql = ((Object)charSequence).toString();
        int n2 = StringUtils.countChars((String)this.sql, (char)'?', (boolean)false);
        this.columnSizes = new int[n2];
        this.sqlTypes = new int[n2];
        this.currentParams = new Object[n2];
        int n3 = 0;
        Matcher matcher = sqlVarPattern.matcher(charSequence);
        while (matcher.find()) {
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            if (string != null) {
                if (StringUtils.isNumeric((String)string)) {
                    this.columnSizes[n3] = StringUtils.getInt((String)string, (int)0);
                } else {
                    this.sqlTypes[n3] = DbUtil.getSqlType(string);
                    if (this.sqlTypes[n3] == 0) {
                        throw new SQLRuntimeException("Unknown SQL type [" + string + "] specified for prepared statement [" + charSequence + "]");
                    }
                    if (string2 != null) {
                        this.columnSizes[n3] = StringUtils.getInt((String)string2, (int)0);
                    }
                }
            }
            ++n3;
        }
        if (DbFlags.isAutoBatchExecuteAndCommit(n)) {
            this.maxBatchExecuteSize = DbAdmin.maxBatchExecuteSize;
            this.maxBatchCommitSize = DbAdmin.maxBatchCommitSize;
        }
        this.sqlFixed = DbAdmin.replaceVars(charSequence);
        this.open();
    }

    private void open() throws SQLRuntimeException {
        if (this.ps != null) {
            return;
        }
        try {
            this.ps = DbAdmin.isLegacyDriver ? this.connection.prepareStatement(this.sqlFixed) : this.connection.prepareStatement(this.sqlFixed, DbFlags.getScrollability(this.flags), DbFlags.getUpdatability(this.flags), DbFlags.getHoldability(this.flags));
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public DbPreparedStatement setMaxBatchSizes(int n, int n2) {
        this.maxBatchExecuteSize = n;
        this.maxBatchCommitSize = n2;
        return this;
    }

    public DbPreparedStatement setAutoLock(String ... stringArray) {
        this.autoLock = stringArray;
        return this;
    }

    public DbPreparedStatement setCommitWeight(int n) {
        this.commitWeight = n;
        return this;
    }

    public DbPreparedStatement setParams(Object ... objectArray) throws SQLRuntimeException {
        this.open();
        for (int i = 0; i < objectArray.length; ++i) {
            this.setObject(i + 1, objectArray[i]);
        }
        return this;
    }

    public DbResultSet query(Object ... objectArray) throws SQLRuntimeException {
        long l = System.currentTimeMillis();
        try {
            this.setParams(objectArray);
            if (debug) {
                logger.log(Level.FINER, "Running prepared statement:  " + this.sql);
            }
            DbResultSet dbResultSet = new DbResultSet(this, this.ps.executeQuery(), l, this.currentParams);
            DbAdmin.getRsCache().add(dbResultSet);
            return dbResultSet;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int update(Object ... objectArray) throws SQLRuntimeException {
        try {
            DbAdmin.lockTable(this.autoLock);
            if (DbFlags.isLocking(this.flags)) {
                DbAdmin.lockTable(this.getModifiedTable());
            }
            this.setParams(objectArray);
            long l = System.currentTimeMillis();
            int n = this.ps.executeUpdate();
            DbAdmin.addUpdateStats(this.sql, l, n, this.currentParams);
            if (n > 0 && DbFlags.isAutoCommit(this.flags)) {
                DbAdmin.commit();
            }
            this.updateCount += (long)n;
            return n;
        }
        catch (SQLException sQLException) {
            if (DbFlags.isAutoRollback(this.flags)) {
                DbAdmin.rollback();
            }
            throw this.wrap(sQLException);
        }
    }

    public DbPreparedStatement addBatch(Object ... objectArray) throws SQLRuntimeException {
        try {
            this.setParams(objectArray);
            this.ps.addBatch();
            ++this.executeSize;
            ++this.commitSize;
            if (this.executeSize >= this.maxBatchExecuteSize) {
                this.executeBatch(this.commitSize >= this.maxBatchCommitSize);
            }
            return this;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public DbPreparedStatement executeBatch() throws SQLRuntimeException {
        return this.executeBatch(DbFlags.isAutoCommit(this.flags));
    }

    public DbPreparedStatement executeBatch(boolean bl) throws SQLRuntimeException {
        this.open();
        if (this.executeSize == 0) {
            return this;
        }
        long l = System.currentTimeMillis();
        try {
            DbAdmin.lockTable(this.autoLock);
            if (DbFlags.isLocking(this.flags)) {
                DbAdmin.lockTable(this.getModifiedTable());
            }
            int[] nArray = this.ps.executeBatch();
            int n = 0;
            for (int n2 : nArray) {
                n += n2 == -2 ? 0 : n2;
            }
            DbAdmin.addBatchStats(this.sql, l, n);
            this.executeSize = 0;
            this.updateCount += (long)n;
            long l2 = Math.max(System.currentTimeMillis() - l, 1L);
            this.updateTime += l2;
            if (DbFlags.isVerbose(this.flags)) {
                logger.info("[" + n + "] rows affected in [" + l2 + "ms]. Instant rate=[" + (long)(n * 1000) / l2 + "/s], Avg rate=[" + this.updateCount * 1000L / this.updateTime + "/s], Total rows=[" + this.updateCount + "]");
            }
            if (bl) {
                this.commitSize = 0;
                DbAdmin.commit();
            }
        }
        catch (SQLException sQLException) {
            if (DbFlags.isAutoRollback(this.flags)) {
                DbAdmin.rollback();
            }
            throw new SQLRuntimeException("SQL exception on prepared statement [" + this.sql + "]/[" + this.sqlFixed + "], sqlTypes=[" + StringUtils.join((int[])this.sqlTypes, (String)",") + "], columnSizes=[" + StringUtils.join((int[])this.columnSizes, (String)",") + "]", sQLException);
        }
        return this;
    }

    public String getSQL() {
        return this.sql;
    }

    public boolean isReusable() {
        return DbFlags.isReusable(this.flags);
    }

    public String getModifiedTable() {
        if (this.isQueryPattern.matcher(this.sql).matches()) {
            return null;
        }
        Matcher matcher = this.modifiedTablePattern.matcher(this.sql);
        if (!matcher.matches()) {
            if (this.sql.toUpperCase().indexOf("SESSION") == -1) {
                logger.log(Level.WARNING, "modifiedTablePattern didn't match!  SQL=[" + this.sql + "]");
            }
            return null;
        }
        return matcher.group(1).toUpperCase();
    }

    public void setObject(int n, Object object) throws SQLRuntimeException {
        this.open();
        int n2 = n - 1;
        this.currentParams[n2] = object;
        if (object == null) {
            if (this.sqlTypes[n2] == 0) {
                throw new SQLRuntimeException("Attempting to set null on variable [" + n + "] of prepared statement [" + this.sql + "] with unspecified sql type");
            }
            try {
                this.ps.setNull(n, this.sqlTypes[n2]);
            }
            catch (SQLException sQLException) {
                throw this.wrap(sQLException);
            }
            return;
        }
        if (this.columnSizes[n2] != 0) {
            this.setString(n, object.toString());
        } else if (object instanceof Character) {
            this.setString(n, object.toString());
        } else {
            try {
                this.ps.setObject(n, object);
            }
            catch (SQLException sQLException) {
                throw new SQLRuntimeException("SQL exception on prepared statement [" + this.sql + "]|[" + this.sqlFixed + "] trying to set parameter [" + n + "] with value [" + object.getClass().getName() + ":" + object + "].", sQLException);
            }
        }
    }

    public void setString(int n, String string) throws SQLRuntimeException {
        this.open();
        int n2 = n - 1;
        this.currentParams[n2] = string;
        try {
            this.ps.setString(n, this.columnSizes[n2] == 0 ? string : StringUtils.truncateBytes((String)string, (int)this.columnSizes[n2], (String)DbAdmin.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.SEVERE, unsupportedEncodingException.getLocalizedMessage(), unsupportedEncodingException);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    protected void close() throws SQLRuntimeException {
        try {
            if (this.ps != null) {
                this.ps.close();
            }
            this.ps = null;
            if (this.executeSize > 0) {
                throw new SQLRuntimeException("DbPreparedStatement [" + this.sql + "] closed with [" + this.executeSize + "] unexecuted batch inserts.");
            }
            this.executeSize = 0;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void setNull(int n, int n2) throws SQLRuntimeException {
        this.open();
        try {
            this.currentParams[n - 1] = null;
            this.ps.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void setInt(int n, int n2) throws SQLRuntimeException {
        this.open();
        try {
            this.currentParams[n - 1] = n2;
            this.ps.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLRuntimeException {
        this.open();
        try {
            this.currentParams[n - 1] = timestamp;
            this.ps.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Connection getConnection() throws SQLRuntimeException {
        this.open();
        try {
            return this.ps.getConnection();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void clearParameters() throws SQLRuntimeException {
        this.open();
        try {
            this.ps.clearParameters();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getResultSetHoldability() {
        this.open();
        if (DbAdmin.isLegacyDriver) {
            return 1;
        }
        try {
            return this.ps.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    private SQLRuntimeException wrap(SQLException sQLException) {
        throw new SQLRuntimeException("Exception on prepared statement [" + this.getDebugSql() + "]", sQLException);
    }

    protected String getDebugSql() {
        return this.sql + (this.currentParams.length > 0 ? " (params=[" + StringUtils.join((Object[])this.currentParams, (String)",") + "])" : "");
    }

    public boolean equals(Object object) {
        return this.sql.equals(((DbPreparedStatement)object).sql);
    }

    public int hashCode() {
        return this.sql.hashCode();
    }

    public int loadFromSelect(String string) {
        int n;
        this.open();
        DbResultSet dbResultSet = null;
        Logger logger = LoggerManager.getMainLogger();
        try {
            dbResultSet = DbAdmin.query(DbFlags.HOLDABLE, string, new Object[0]);
            int n2 = 0;
            Object[] objectArray = new Object[dbResultSet.getMetaData().getColumnCount()];
            while (dbResultSet.next()) {
                ++n2;
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = dbResultSet.getObject(n + 1);
                }
                this.addBatch(objectArray);
            }
            if (DbFlags.isVerbose(this.flags)) {
                logger.info("[" + n2 + "] rows loaded into prepared statement.");
            }
            n = n2;
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLRuntimeException(sQLException);
            }
            catch (Throwable throwable) {
                DbAdmin.close(dbResultSet);
                throw throwable;
            }
        }
        DbAdmin.close(dbResultSet);
        return n;
    }
}

