/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.IMatcher;
import com.ibm.dmh.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMatcher
implements IMatcher<Object> {
    private SearchPattern[] searchPatterns;

    public StringMatcher(String string, boolean bl) {
        this.searchPatterns = new SearchPattern[1];
        this.searchPatterns[0] = new SearchPattern(string, bl);
    }

    public StringMatcher(String[] stringArray, boolean bl) {
        this.searchPatterns = new SearchPattern[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.searchPatterns[i] = new SearchPattern(stringArray[i], bl);
        }
    }

    @Override
    public boolean matches(Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < this.searchPatterns.length; ++i) {
            if (this.searchPatterns[i].matches(object.toString())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchPattern {
        Pattern[] orPatterns;
        Pattern[] andPatterns;
        Pattern[] notPatterns;

        public SearchPattern(String string, boolean bl) {
            LinkedList<Pattern> linkedList = new LinkedList<Pattern>();
            LinkedList<Pattern> linkedList2 = new LinkedList<Pattern>();
            LinkedList<Pattern> linkedList3 = new LinkedList<Pattern>();
            for (String string2 : this.breakUpTokens(string)) {
                char c = string2.charAt(0);
                String string3 = string2.substring(1);
                string3 = string3.replaceAll("([\\?\\*\\+\\\\\\[\\]\\{\\}\\(\\)\\^\\$\\.])", "\\\\$1");
                string3 = StringUtils.replace(string3, "\u3001", ".*");
                if (!(string3 = StringUtils.replace(string3, "\u3002", ".?")).startsWith(".*")) {
                    string3 = "^" + string3;
                }
                if (!string3.endsWith(".*")) {
                    string3 = string3 + "$";
                }
                int n = 32;
                if (bl) {
                    n |= 2;
                }
                Pattern pattern = Pattern.compile(string3, n);
                if (c == '^') {
                    linkedList.add(pattern);
                    continue;
                }
                if (c == '+') {
                    linkedList2.add(pattern);
                    continue;
                }
                if (c != '-') continue;
                linkedList3.add(pattern);
            }
            this.orPatterns = linkedList.toArray(new Pattern[linkedList.size()]);
            this.andPatterns = linkedList2.toArray(new Pattern[linkedList2.size()]);
            this.notPatterns = linkedList3.toArray(new Pattern[linkedList3.size()]);
        }

        private List<String> breakUpTokens(String string) {
            String string2;
            int n;
            if (string == null || StringUtils.strip(string).length() == 0) {
                return Collections.emptyList();
            }
            string = " " + string + " ";
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\\') {
                    ++n2;
                } else if (n2 % 2 == 0) {
                    if (cArray[i] == '\'') {
                        bl = !bl;
                    } else if (cArray[i] == '\"') {
                        bl2 = !bl2;
                    } else if (cArray[i] == '+' && (bl || bl2)) {
                        cArray[i] = 8193;
                    } else if (cArray[i] == '-' && (bl || bl2)) {
                        cArray[i] = 8194;
                    }
                }
                if (cArray[i] == '\\') continue;
                n2 = 0;
            }
            string = new String(cArray);
            string = string.replaceAll("([\\+\\-])\\s+", "$1");
            string = StringUtils.replace(string, '*', '\u3001', true, false);
            string = StringUtils.replace(string, '?', '\u3002', true, false);
            string = StringUtils.unEscapeChars(string, new char[]{'*', '?'});
            string = string.trim();
            string = string.replace('\u2001', '+');
            string = string.replace('\u2002', '-');
            String[] stringArray = StringUtils.splitQuoted(string, ' ');
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n3 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n];
                int n4 = string2.length();
                if (n4 <= 0) continue;
                char c = string2.charAt(0);
                String string3 = null;
                if ((c == '+' || c == '-') && n4 > 1) {
                    string3 = string2.substring(1);
                } else {
                    string3 = string2;
                    c = '^';
                    ++n3;
                }
                if (string3.matches("\".*\"") || string3.matches("'.*'")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                string3 = StringUtils.unEscapeChars(string3, new char[]{'\"', '\''});
                string3 = StringUtils.unEscapeChars(string3, new char[]{'\\'});
                arrayList.add(c + string3);
            }
            if (n3 == 1) {
                for (n = 0; n < arrayList.size(); ++n) {
                    string2 = (String)arrayList.get(n);
                    if (string2.charAt(0) != '^') continue;
                    arrayList.set(n, '+' + string2.substring(1));
                }
            }
            return arrayList;
        }

        public boolean matches(String string) {
            int n;
            if (string == null) {
                return false;
            }
            for (n = 0; n < this.andPatterns.length; ++n) {
                if (this.andPatterns[n].matcher(string).matches()) continue;
                return false;
            }
            for (n = 0; n < this.notPatterns.length; ++n) {
                if (!this.notPatterns[n].matcher(string).matches()) continue;
                return false;
            }
            for (n = 0; n < this.orPatterns.length; ++n) {
                if (!this.orPatterns[n].matcher(string).matches()) continue;
                return true;
            }
            return this.orPatterns.length == 0;
        }
    }
}

