/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;

public class HexFieldWrapper {
    private Field field;
    private boolean firstDigit;

    public HexFieldWrapper(Field field, boolean firstDigit) {
        this.field = field;
        this.firstDigit = firstDigit;
    }

    public String getHexString() {
        if (this.field.isEmpty()) {
            return "";
        }
        byte[] bytes = this.field.getEbcdicValue();
        StringBuffer buff = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            int number = 0;
            number = this.isFirstDigit() ? (bytes[i] & 0xF0) >> 4 : bytes[i] & 0xF;
            buff.append(Integer.toHexString(number));
            ++i;
        }
        return buff.toString().toUpperCase();
    }

    public Field getField() {
        return this.field;
    }

    public void setHexString(String value) throws FMIConversionException, FMIKeyException, FMIModelException {
        byte[] bytes = this.field.getEbcdicValue();
        int i = 0;
        while (i < bytes.length) {
            int num = bytes[i] & 0xFF;
            byte byteNum = i < value.length() ? Byte.parseByte(value.substring(i, i + 1), 16) : (byte)0;
            num = this.firstDigit ? (num & 0xF) + (byteNum << 4) : (num & 0xF0) + byteNum;
            bytes[i] = (byte)num;
            ++i;
        }
        this.field.setEbcdic(bytes, 0, false, true, true);
    }

    public boolean isFirstDigit() {
        return this.firstDigit;
    }
}

