/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.providers.HexFieldWrapper;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;

public class FMISingleModeCellModifier
implements ICellModifier {
    public boolean canModify(Object element, String property) {
        return property != null && !property.equals("") && !property.equals(UiPlugin.getString("FIELD_TITLE"));
    }

    public Object getValue(Object element, String property) {
        if (property.equals(UiPlugin.getString("DATA_TITLE"))) {
            if (element instanceof Field) {
                return ((Field)element).getAsciiStr();
            }
            if (element instanceof HexFieldWrapper) {
                return ((HexFieldWrapper)element).getHexString();
            }
        }
        return "";
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (!property.equals(UiPlugin.getString("FIELD_TITLE")) && property.equals(UiPlugin.getString("DATA_TITLE"))) {
            if (element instanceof Field) {
                try {
                    Field field = (Field)element;
                    field.setASCIIStr((String)value, true);
                }
                catch (FMIConversionException e) {
                    UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
                }
                catch (FMIKeyException e) {
                    UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
                }
                catch (FMIModelException e) {
                    UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
                }
            } else if (element instanceof HexFieldWrapper) {
                try {
                    ((HexFieldWrapper)element).setHexString((String)value);
                }
                catch (FMIConversionException e) {
                    UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
                }
                catch (FMIKeyException e) {
                    UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
                }
                catch (FMIModelException e) {
                    UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
                }
            }
        }
    }
}

