/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.dialog;

import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.action.FMIFindReplaceAction;
import com.ibm.fmi.ui.editors.FileManagerIntegrationEditor;
import com.ibm.fmi.ui.event.FMIEditorFocusEvent;
import com.ibm.fmi.ui.event.FMIEditorFocusEventListener;
import com.ibm.fmi.ui.event.FMIEditorMessageEvent;
import com.ibm.fmi.ui.event.FMIEditorMessageEventListener;
import com.ibm.fmi.ui.providers.FMIFindReplaceProvider;
import com.ibm.fmi.ui.util.FMIModelIndex;
import com.ibm.fmi.ui.util.FMIModelRegion;
import com.ibm.fmi.ui.util.FMISelectionIndex;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FindReplaceWindow
extends Window
implements ModifyListener,
SelectionListener,
FMIEditorFocusEventListener,
FMIEditorMessageEventListener {
    private Button bFind;
    private Button bReplaceFind;
    private Button bReplace;
    private Button bReplaceAll;
    private Button bSelectMatching;
    private Button bCloseWindow;
    private Combo findCombo;
    private Combo replaceCombo;
    private Button forwardButton;
    private Button backwardButton;
    private Button selectedButton;
    private Button visibleButton;
    private Button excludedButton;
    private Button excludedVisibleButton;
    private Table fieldTable;
    private TableViewer fieldTableViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Button caseSensitiveButton;
    private Button regExButton;
    private Label statusMessage;
    private RecordLayout layout;
    private FileManagerIntegrationEditor editor;
    private FMIModelIndex searchModelIndex;
    private FMIModelIndex selectionModelIndex;
    private FMISelectionIndex selectionIndex;
    private FMIModelRegion modelRegion;
    private FMIFindReplaceAction fmifra;
    private static final String NO_MATCH_FOUND = UiPlugin.getString("FindReplace.noMatch");
    private static final String NO_PREVIOUS_MATCH = UiPlugin.getString("FindReplace.noPrevMatch");
    private static final String MATCH_REPLACED = UiPlugin.getString("FindReplace.matchReplaced");
    private static final String MATCH_FOUND = UiPlugin.getString("FindReplace.matchFound");

    public FindReplaceWindow(Shell parentShell) {
        super(parentShell);
        super.setShellStyle(96);
    }

    protected Control createContents(Composite parent) {
        GridLayout gl = new GridLayout(2, true);
        parent.setLayout((Layout)gl);
        Composite searchStringComp = new Composite(parent, 0);
        searchStringComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        searchStringComp.setLayout((Layout)new GridLayout(2, false));
        Label findLabel = new Label(searchStringComp, 16384);
        findLabel.setText(UiPlugin.getString("FindReplace.findField"));
        findLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.findCombo = new Combo(searchStringComp, 4);
        this.findCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.findCombo.addModifyListener((ModifyListener)this);
        Label findRLabel = new Label(searchStringComp, 16384);
        findRLabel.setText(UiPlugin.getString("FindReplace.replaceWith"));
        findRLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.replaceCombo = new Combo(searchStringComp, 4);
        this.replaceCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.replaceCombo.addModifyListener((ModifyListener)this);
        Group fieldGroup = new Group(parent, 0);
        fieldGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        fieldGroup.setLayout((Layout)new GridLayout(3, false));
        fieldGroup.setText(UiPlugin.getString("FindReplace.withinFields"));
        this.fieldTableViewer = new TableViewer((Composite)fieldGroup, 546);
        this.fieldTable = this.fieldTableViewer.getTable();
        this.fieldTable.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        TableColumn tc = new TableColumn(this.fieldTable, 16384);
        tc.setWidth(200);
        FMIFindReplaceProvider ftvProvider = new FMIFindReplaceProvider();
        this.fieldTableViewer.setContentProvider((IContentProvider)ftvProvider);
        this.fieldTableViewer.setLabelProvider((IBaseLabelProvider)ftvProvider);
        this.selectAllButton = new Button((Composite)fieldGroup, 0);
        this.selectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.selectAllButton.setText(UiPlugin.getString("FindReplace.selectAll"));
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceWindow.this.fieldTable != null && !FindReplaceWindow.this.fieldTable.isDisposed()) {
                    TableItem[] items = FindReplaceWindow.this.fieldTable.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(true);
                        ++i;
                    }
                }
            }
        });
        this.deselectAllButton = new Button((Composite)fieldGroup, 0);
        this.deselectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.deselectAllButton.setText(UiPlugin.getString("FindReplace.deselectAll"));
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceWindow.this.fieldTable != null && !FindReplaceWindow.this.fieldTable.isDisposed()) {
                    TableItem[] items = FindReplaceWindow.this.fieldTable.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(false);
                        ++i;
                    }
                }
            }
        });
        Group scopeGroup = new Group(parent, 0);
        scopeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        scopeGroup.setText(UiPlugin.getString("FindReplace.Scope"));
        scopeGroup.setLayout((Layout)new RowLayout(512));
        this.selectedButton = new Button((Composite)scopeGroup, 16);
        this.selectedButton.setText(UiPlugin.getString("FindReplace.selectedRecs"));
        this.selectedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceWindow.this.selectedButton.getSelection()) {
                    FindReplaceWindow.this.modelRegion = null;
                }
            }
        });
        this.visibleButton = new Button((Composite)scopeGroup, 16);
        this.visibleButton.setText(UiPlugin.getString("FindReplace.visibleRecs"));
        this.excludedButton = new Button((Composite)scopeGroup, 16);
        this.excludedButton.setText(UiPlugin.getString("FindReplace.excludedRecs"));
        this.excludedVisibleButton = new Button((Composite)scopeGroup, 16);
        this.excludedVisibleButton.setText(UiPlugin.getString("FindReplace.excludedAndVisibleRecs"));
        Group directionGroup = new Group(parent, 0);
        directionGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        directionGroup.setText(UiPlugin.getString("FindReplace.direction"));
        directionGroup.setLayout((Layout)new RowLayout(512));
        this.forwardButton = new Button((Composite)directionGroup, 16);
        this.forwardButton.setText(UiPlugin.getString("FindReplace.forward"));
        this.backwardButton = new Button((Composite)directionGroup, 16);
        this.backwardButton.setText(UiPlugin.getString("FindReplace.backward"));
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        optionsGroup.setText(UiPlugin.getString("FindReplace.options"));
        optionsGroup.setLayout((Layout)new GridLayout(1, true));
        this.caseSensitiveButton = new Button((Composite)optionsGroup, 32);
        this.caseSensitiveButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 1, 1));
        this.caseSensitiveButton.setText(UiPlugin.getString("FindReplace.case"));
        this.regExButton = new Button((Composite)optionsGroup, 32);
        this.regExButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 1, 1));
        this.regExButton.setText(UiPlugin.getString("FindReplace.regExp"));
        Composite buttonBar = new Composite(parent, 0);
        GridLayout buttonBarLayout = new GridLayout(2, true);
        buttonBar.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        buttonBar.setLayout((Layout)buttonBarLayout);
        this.bFind = new Button(buttonBar, 0);
        this.bFind.setText(UiPlugin.getString("FindReplace.findButton"));
        this.bFind.addSelectionListener((SelectionListener)this);
        this.bFind.setLayoutData((Object)new GridData(768));
        this.bReplaceFind = new Button(buttonBar, 0);
        this.bReplaceFind.setText(UiPlugin.getString("FindReplace.replaceFindButton"));
        this.bReplaceFind.addSelectionListener((SelectionListener)this);
        this.bReplaceFind.setLayoutData((Object)new GridData(768));
        this.bReplace = new Button(buttonBar, 0);
        this.bReplace.setText(UiPlugin.getString("FindReplace.replaceButton"));
        this.bReplace.addSelectionListener((SelectionListener)this);
        this.bReplace.setLayoutData((Object)new GridData(768));
        this.bReplaceAll = new Button(buttonBar, 0);
        this.bReplaceAll.setText(UiPlugin.getString("FindReplace.replaceAllButton"));
        this.bReplaceAll.addSelectionListener((SelectionListener)this);
        this.bReplaceAll.setLayoutData((Object)new GridData(768));
        this.bSelectMatching = new Button(buttonBar, 0);
        this.bSelectMatching.setText(UiPlugin.getString("FindReplace.selectMatchesButton"));
        this.bSelectMatching.setEnabled(false);
        this.bSelectMatching.addSelectionListener((SelectionListener)this);
        this.bSelectMatching.setLayoutData((Object)new GridData(768));
        this.bCloseWindow = new Button(buttonBar, 0);
        this.bCloseWindow.setText(IDialogConstants.CLOSE_LABEL);
        this.bCloseWindow.addSelectionListener((SelectionListener)this);
        this.bCloseWindow.setLayoutData((Object)new GridData(768));
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.statusMessage.setText("Status message");
        this.initializeDialogSettings();
        return parent;
    }

    public Set getSelectedFields() {
        if (this.fieldTable == null || this.fieldTable.isDisposed()) {
            return null;
        }
        TableItem[] items = this.fieldTable.getItems();
        HashSet<Object> fields = new HashSet<Object>();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                fields.add(items[i].getData());
            }
            ++i;
        }
        return Collections.unmodifiableSet(fields);
    }

    public void modifyText(ModifyEvent e) {
        if (this.findCombo != null && !this.findCombo.isDisposed() && this.findCombo.getText() != null && !this.findCombo.getText().equals("")) {
            this.bFind.setEnabled(true);
            if (this.replaceCombo != null && !this.replaceCombo.isDisposed() && this.replaceCombo.getText() != null) {
                this.bReplaceAll.setEnabled(true);
                this.bReplace.setEnabled(true);
                this.bReplaceFind.setEnabled(true);
            } else {
                this.bReplaceAll.setEnabled(false);
                this.bReplace.setEnabled(false);
                this.bReplaceFind.setEnabled(false);
            }
        } else {
            this.bFind.setEnabled(false);
            this.bReplaceAll.setEnabled(false);
            this.bReplace.setEnabled(false);
            this.bReplaceFind.setEnabled(false);
        }
    }

    protected void initializeDialogSettings() {
        if (this.fieldTableViewer != null) {
            this.fieldTableViewer.setInput((Object)this.editor);
        }
        if (this.forwardButton != null && !this.forwardButton.isDisposed()) {
            this.forwardButton.setSelection(true);
            this.backwardButton.setSelection(false);
        }
        if (this.visibleButton != null && !this.visibleButton.isDisposed()) {
            this.visibleButton.setSelection(true);
        }
    }

    public FileManagerIntegrationEditor getEditor() {
        return this.editor;
    }

    public void setEditor(FileManagerIntegrationEditor editor) {
        this.editor = editor;
        this.selectionModelIndex = null;
        this.selectionIndex = null;
        this.searchModelIndex = editor.getSelectionPoint();
        if (this.searchModelIndex == null) {
            FMIModelRegion mr = editor.getSelectedRegion();
            this.searchModelIndex = mr != null ? mr.getFirstIndex() : new FMIModelIndex(0, 0, 0);
        }
        this.setLayout(editor.getActiveModel().getCurLayout());
    }

    public void widgetSelected(SelectionEvent se) {
        boolean visible = false;
        boolean excluded = false;
        Button bSource = (Button)se.getSource();
        if (this.selectedButton.getSelection()) {
            if (this.modelRegion == null) {
                this.modelRegion = this.editor.getSelectedRegion();
                this.selectionModelIndex = this.forwardButton.getSelection() ? this.modelRegion.getFirstIndex() : this.modelRegion.getLastIndex();
            }
            excluded = true;
            visible = true;
        } else if (this.visibleButton.getSelection()) {
            visible = true;
            excluded = false;
        } else if (this.excludedButton.getSelection()) {
            excluded = true;
            visible = false;
        } else if (this.excludedVisibleButton.getSelection()) {
            excluded = true;
            visible = true;
        }
        if (bSource == this.bCloseWindow) {
            this.close();
        } else if (bSource == this.bFind) {
            String searchString = this.findCombo.getText();
            this.doFind(searchString, visible, excluded);
        } else if (bSource == this.bReplace) {
            this.doReplace();
        } else if (bSource == this.bReplaceFind) {
            String searchString = this.findCombo.getText();
            if (this.doReplace()) {
                this.doFind(searchString, visible, excluded);
            }
        } else if (bSource == this.bReplaceAll) {
            this.editor.replaceAll(this.findCombo.getText(), this.caseSensitiveButton.getSelection(), this.regExButton.getSelection(), this.getSelectedFields(), this.replaceCombo.getText(), this.modelRegion, visible, excluded);
        } else if (bSource == this.bSelectMatching) {
            this.editor.selectMatchingRecords(this.findCombo.getText(), this.caseSensitiveButton.getSelection(), this.regExButton.getSelection(), this.getSelectedFields(), this.modelRegion, visible, excluded);
        }
    }

    private boolean doReplace() {
        if (this.selectionModelIndex != null) {
            String replaceText = this.replaceCombo.getText();
            boolean result = this.editor.replaceSelection(this.selectionIndex, replaceText);
            if (this.forwardButton.getSelection()) {
                this.searchModelIndex = new FMIModelIndex(this.selectionModelIndex.getDisplayLineIndex(), this.selectionModelIndex.getFieldIndex(), this.selectionModelIndex.getFieldOffset() + replaceText.length());
                this.selectionModelIndex = null;
            }
            return result;
        }
        this.statusMessage.setText(NO_PREVIOUS_MATCH);
        return false;
    }

    private void doFind(String searchString, boolean visible, boolean excluded) {
        this.selectionModelIndex = this.editor.findAndSelect(this.searchModelIndex, searchString, this.forwardButton.getSelection(), this.caseSensitiveButton.getSelection(), this.regExButton.getSelection(), this.getSelectedFields(), this.modelRegion, visible, excluded);
        if (this.selectionModelIndex != null) {
            this.selectionIndex = new FMISelectionIndex(this.selectionModelIndex, searchString.length(), searchString);
            this.searchModelIndex = this.forwardButton.getSelection() ? new FMIModelIndex(this.selectionModelIndex.getDisplayLineIndex(), this.selectionModelIndex.getFieldIndex(), this.selectionModelIndex.getFieldOffset() + this.selectionIndex.getSelectionLength()) : new FMIModelIndex(this.selectionModelIndex.getDisplayLineIndex(), this.selectionModelIndex.getFieldIndex(), this.selectionModelIndex.getFieldOffset() - this.selectionIndex.getSelectionLength());
            this.statusMessage.setText(MATCH_FOUND);
        } else {
            this.statusMessage.setText(NO_MATCH_FOUND);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    private void setLayout(RecordLayout layout) {
        if (this.layout == layout) {
            return;
        }
        this.layout = layout;
        this.initializeDialogSettings();
    }

    protected void configureShell(Shell sh) {
        super.configureShell(sh);
        sh.setText(UiPlugin.getString("FindReplace.findReplaceTitle"));
        this.setShellStyle(0);
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(96);
    }

    public boolean close() {
        this.fmifra.setClosed();
        return super.close();
    }

    public void setOriginatingAction(FMIFindReplaceAction fra) {
        this.fmifra = fra;
    }

    public void handleEditorFocusEvent(FMIEditorFocusEvent e) {
        this.setEditor(e.getSourceEditor());
    }

    public void handleEditorMessageEvent(FMIEditorMessageEvent e) {
        this.statusMessage.setText(e.getEditorMessage());
    }
}

