/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.action;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.action.EditorAction;
import com.ibm.fmi.ui.editors.FileManagerIntegrationEditor;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MoveActions
extends EditorAction {
    private String actions;
    private FileManagerIntegrationEditor editor;

    public MoveActions(String action, FileManagerIntegrationEditor editor) {
        super(action);
        this.actions = action;
        this.editor = editor;
    }

    public void run() {
        Iterator it = this.getStructuredSelection().iterator();
        DisplayLine line = null;
        Object obj = null;
        while (it.hasNext() && line == null) {
            obj = it.next();
            if (obj instanceof DisplayLine) {
                line = obj;
                continue;
            }
            if (!(obj instanceof HexRecordWrapper)) continue;
            line = ((HexRecordWrapper)obj).getRecord();
        }
        if (line == null || it.hasNext()) {
            return;
        }
        this.mainActions(this.actions.equals(UiPlugin.getString("MOVE_UP")), line);
    }

    public void mainActions(boolean up, DisplayLine line) {
        if (up) {
            try {
                this.editor.getActiveModel().moveLineUp(line);
            }
            catch (FMIKeyException e) {
                UiPlugin.trace(0, (Object)this, UiPlugin.getString("Error.move.up"), e);
            }
            catch (FMIModelException e) {
                UiPlugin.trace(0, (Object)this, UiPlugin.getString("Error.move.down"), e);
            }
        } else if (!up) {
            try {
                this.editor.getActiveModel().moveLineDown(line);
            }
            catch (FMIKeyException e) {
                UiPlugin.trace(0, (Object)this, UiPlugin.getString("Error.move.down"), e);
            }
            catch (FMIModelException e) {
                UiPlugin.trace(0, (Object)this, UiPlugin.getString("Error.move.down"), e);
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Iterator it = this.getStructuredSelection().iterator();
        DisplayLine line = null;
        Object obj = null;
        while (it.hasNext() && line == null) {
            obj = it.next();
            if (obj instanceof DisplayLine) {
                line = obj;
                continue;
            }
            if (!(obj instanceof HexRecordWrapper)) continue;
            line = ((HexRecordWrapper)obj).getRecord();
        }
        if (line == null || it.hasNext()) {
            return false;
        }
        return this.editor.getActiveModel().canShiftRecords();
    }
}

