/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.fmi.ui";
    public static final String SUPRESSED_ICON = "icons/SuppressRecord_1.jpg";
    public static final String EXCLUDED_ICON = "icons/excluded_icon.gif";
    public static final String UNSELECTED_ICON = "icons/unselected_icon.gif";
    public static final String TBL_EXP_ICON = "icons/tgl_obj.gif";
    public static final int TRACE_ERROR = 0;
    public static final int TRACE_WARNING = 1;
    public static final int TRACE_INFO = 2;
    public static final int TRACE_DEBUG = 3;
    private static final String[] traceLevels = new String[]{"ERROR", "WARN ", "INFO ", "DEBUG"};
    private static UiPlugin plugin;
    private static ResourceBundle resourceBundle;
    private static int traceLevel;
    private boolean debugMode;

    public UiPlugin() {
        plugin = this;
        try {
            resourceBundle = ResourceBundle.getBundle("plugin");
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.debugMode = Boolean.valueOf(Platform.getDebugOption((String)"com.ibm.fmi.ui/Debug"));
        String debuglevel = Platform.getDebugOption((String)"com.ibm.fmi.ui/Level");
        if (debuglevel != null) {
            traceLevel = Integer.valueOf(debuglevel);
        }
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(Integer.toString(2049), false);
        store.setDefault(Integer.toString(2050), false);
        store.setDefault(Integer.toString(2051), true);
    }

    public void stop(BundleContext context) throws Exception {
        this.getImageRegistry().dispose();
        super.stop(context);
        plugin = null;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(EXCLUDED_ICON, UiPlugin.getImageDescriptor(EXCLUDED_ICON));
        reg.put(SUPRESSED_ICON, UiPlugin.getImageDescriptor(SUPRESSED_ICON));
        reg.put(UNSELECTED_ICON, UiPlugin.getImageDescriptor(UNSELECTED_ICON));
        reg.put(TBL_EXP_ICON, UiPlugin.getImageDescriptor(TBL_EXP_ICON));
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static String getString(String key) {
        ResourceBundle bundle = UiPlugin.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : String.valueOf('!') + key + '!';
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('%') + key + '%';
        }
    }

    public static String getString(String key, Object[] arguments) {
        ResourceBundle bundle = UiPlugin.getResourceBundle();
        try {
            if (bundle == null) {
                return String.valueOf('!') + key + '!';
            }
            return MessageFormat.format(bundle.getString(key), arguments);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('%') + key + '%';
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return UiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static boolean isDebug() {
        return UiPlugin.plugin.debugMode;
    }

    public static void trace(int level, Object obj, String msg, Throwable t) {
        if (level == 0 || level == 1) {
            Status status = new Status(level == 0 ? 4 : 2, PLUGIN_ID, 0, String.valueOf(obj.toString()) + " : " + msg, t);
            plugin.getLog().log((IStatus)status);
        }
        if (UiPlugin.plugin.debugMode && level <= traceLevel) {
            System.err.println(String.valueOf(traceLevels[level]) + "> " + DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())) + " : " + obj + " : " + msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }
}

