/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import java.nio.ByteBuffer;

public class DynamicTemplateExpression {
    int lineNum;
    byte conn;
    byte[] operator;
    byte leftParen;
    byte rightParen;
    int valLen1;
    int valStart2;
    int valLen2;
    private static byte VAL1_REQ_QUOTES_BIT = (byte)8;
    private static byte VAL2_REQ_QUOTES_BIT = (byte)7;
    private static byte VAL_REQ_REXX_BIT = (byte)6;
    private static byte START_VAL_OFFSET_BIT = (byte)5;
    boolean val1ReqQuotes;
    boolean val2ReqQuotes;
    boolean valReqRexx;
    boolean startValIsOffset;
    int offset;
    String expression;

    public DynamicTemplateExpression(ByteBuffer buf) throws FMIParseException {
        this.parse(buf);
    }

    private void parse(ByteBuffer buf) throws FMIParseException {
        this.lineNum = buf.get();
        this.conn = buf.get();
        this.operator = new byte[3];
        buf.get(this.operator);
        this.leftParen = buf.get();
        this.rightParen = buf.get();
        this.valLen1 = buf.get();
        this.valStart2 = buf.get();
        this.valLen2 = buf.get();
        byte flag = buf.get();
        this.val1ReqQuotes = ByteUtilities.testBit(flag, VAL1_REQ_QUOTES_BIT);
        this.val2ReqQuotes = ByteUtilities.testBit(flag, VAL2_REQ_QUOTES_BIT);
        this.valReqRexx = ByteUtilities.testBit(flag, VAL_REQ_REXX_BIT);
        this.startValIsOffset = ByteUtilities.testBit(flag, START_VAL_OFFSET_BIT);
        this.offset = buf.get();
        byte[] emptySpace = new byte[12];
        buf.get(emptySpace);
        short expressionLen = buf.getShort();
        try {
            this.expression = ByteUtilities.getString(buf, expressionLen);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
    }

    public byte getConn() {
        return this.conn;
    }

    public String getExpression() {
        return this.expression;
    }

    public byte getLeftParen() {
        return this.leftParen;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getOperator() {
        return this.operator;
    }

    public byte getRightParen() {
        return this.rightParen;
    }

    public boolean isStartValIsOffset() {
        return this.startValIsOffset;
    }

    public boolean isVal1ReqQuotes() {
        return this.val1ReqQuotes;
    }

    public boolean isVal2ReqQuotes() {
        return this.val2ReqQuotes;
    }

    public int getValLen1() {
        return this.valLen1;
    }

    public int getValLen2() {
        return this.valLen2;
    }

    public boolean isValReqRexx() {
        return this.valReqRexx;
    }

    public int getValStart2() {
        return this.valStart2;
    }
}

