/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;

class AttributeSegment
extends Segment {
    private boolean keepLeadingZeros;
    private static final int KEEP_LEADING_ZEROS_BIT = 7;
    private boolean validationError;
    private static final int VALIDATION_ERR_BIT = 8;
    private boolean numericInvalid;
    private static final int NUMERIC_INVALID_BIT = 7;
    private static final int FIRST_FREE_LENGTH = 2;
    private int width;
    private static final int SECOND_FREE_LENGTH = 4;
    private boolean createDataExists;
    private boolean fillCharHex;
    private boolean random;
    private boolean repeatUserPattern;
    private boolean displayPatternHex;
    private static final int CREATE_DATA_EXISTS_BIT = 8;
    private static final int FILL_CHAR_HEX_BIT = 7;
    private static final int RANDOM_BIT = 6;
    private static final int REPEAT_USER_PATTERN_BIT = 5;
    private static final int DISPLAY_PATTERN_HEX_BIT = 4;
    private boolean minValueNotBlank;
    private boolean maxValueNotBlank;
    private boolean incrValueNotBlank;
    private boolean cycleValueNotBlank;
    private boolean fillCharNotBlank;
    private boolean repeatUserPatternNotBlank;
    private static final int MIN_VAL_NOT_BLANK_BIT = 8;
    private static final int MAX_VAL_NOT_BLANK_BIT = 7;
    private static final int INCR_VAL_NOT_BLANK_BIT = 6;
    private static final int CYCLE_VAL_NOT_BLANK_BIT = 5;
    private static final int FILL_CHAR_NOT_BLANK_BIT = 4;
    private static final int REPEAT_USER_PATTERN_NOT_BLANK_BIT = 3;
    private short patternLen;
    private int cycle;
    private byte createPattern;
    private byte createAction;
    private char startChar;
    private char[] fillChar;
    private static final int THIRD_FREE_LENGTH = 15;

    public AttributeSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    protected void parse(ByteBuffer buf) throws FMIParseException {
        byte tempByte = buf.get();
        this.keepLeadingZeros = ByteUtilities.testBit(tempByte, 7);
        tempByte = buf.get();
        this.validationError = ByteUtilities.testBit(tempByte, 8);
        this.numericInvalid = ByteUtilities.testBit(tempByte, 7);
        buf.position(buf.position() + 2);
        this.width = buf.getInt();
        buf.position(buf.position() + 4);
        tempByte = buf.get();
        this.createDataExists = ByteUtilities.testBit(tempByte, 8);
        this.fillCharHex = ByteUtilities.testBit(tempByte, 7);
        this.random = ByteUtilities.testBit(tempByte, 6);
        this.repeatUserPattern = ByteUtilities.testBit(tempByte, 5);
        this.displayPatternHex = ByteUtilities.testBit(tempByte, 4);
        tempByte = buf.get();
        this.minValueNotBlank = ByteUtilities.testBit(tempByte, 8);
        this.maxValueNotBlank = ByteUtilities.testBit(tempByte, 7);
        this.incrValueNotBlank = ByteUtilities.testBit(tempByte, 6);
        this.cycleValueNotBlank = ByteUtilities.testBit(tempByte, 5);
        this.fillCharNotBlank = ByteUtilities.testBit(tempByte, 4);
        this.repeatUserPatternNotBlank = ByteUtilities.testBit(tempByte, 3);
        this.patternLen = buf.getShort();
        this.cycle = buf.getInt();
        this.createPattern = buf.get();
        this.createAction = buf.get();
        this.startChar = buf.getChar();
        this.fillChar = new char[2];
        this.fillChar[0] = (char)buf.get();
        this.fillChar[1] = (char)buf.get();
        buf.position(buf.position() + 15);
    }
}

