/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.client.FMIClientUtilities;
import com.ibm.fmi.client.FMIEditSessionProperties;
import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIDisplayLineRecordIterator;
import com.ibm.fmi.model.FMIRecordHeaderIterator;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.IRecordHeaderContainer;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordHeader;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.event.FMIModelDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIModelFieldChangeEvent;
import com.ibm.fmi.model.event.FMIModelMultiDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.key.KSDSKey;
import com.ibm.fmi.model.key.KSDSKeyIndex;
import com.ibm.fmi.model.shadowline.HiddenSet;
import com.ibm.fmi.model.shadowline.ShadowLine;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplattedData
extends FMIResource
implements IFMIModelListener {
    private List<RecordLayout> layouts;
    private List<DisplayLine> displayLines;
    private KSDSKey key;
    private KSDSKeyIndex keyIndex;
    private String datasetName;
    private List<Record> deletedRecords;
    private List<Record> newRecords;
    private List<Record> modifiedRecords;
    private int curLayout;
    private int startLayoutSymbol;
    private Object zosResource;
    private FMIEditSessionProperties sessionProperties;

    public TemplattedData(String datasetName) {
        this.datasetName = datasetName;
        this.curLayout = 0;
        this.startLayoutSymbol = -1;
        this.layouts = null;
        this.displayLines = null;
        this.key = null;
        this.keyIndex = null;
        this.deletedRecords = new ArrayList<Record>();
        this.modifiedRecords = new ArrayList<Record>();
        this.newRecords = new ArrayList<Record>();
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    void setStartLayoutSymbol(int startLayoutSymbol) {
        this.startLayoutSymbol = startLayoutSymbol;
    }

    List<DisplayLine> getDisplayLines() {
        if (this.displayLines == null) {
            this.displayLines = new ArrayList<DisplayLine>();
        }
        return this.displayLines;
    }

    List<RecordLayout> getLayouts() {
        return this.layouts;
    }

    public void addDisplayLine(int index, DisplayLine displayLine, boolean initializing) throws FMIConversionException, FMIParseException, FMIKeyException, FMIModelException {
        DisplayLine below;
        this.setupDisplayLines();
        if (this.displayLines.contains(displayLine) || this.deletedRecords.contains(displayLine)) {
            if (!(displayLine instanceof Record)) {
                throw new FMIModelException("Cannot copy this line");
            }
            displayLine = displayLine.copy();
        }
        if (!initializing) {
            FMIResourceIterator<Record> recordIterator = displayLine.getRecordIterator();
            while (recordIterator.hasNext()) {
                Record curRecord = (Record)recordIterator.next();
                RecordHeader curHeader = curRecord.getHeader();
                this.newRecords.add(curRecord);
                FMIRecordHeaderIterator recIter = new FMIRecordHeaderIterator(index, this.displayLines);
                int seqIndex = 0;
                if (!recIter.hasPrevious()) {
                    curHeader.setNew();
                } else {
                    IRecordHeaderContainer prev = recIter.previous();
                    seqIndex = prev.getHeader().getSequenceNumber() + 1;
                    curHeader.setNew(prev.getHeader().getID(), seqIndex++);
                    recIter.next();
                }
                while (recIter.hasNext()) {
                    IRecordHeaderContainer next = recIter.next();
                    if (!Arrays.equals(next.getHeader().getID(), curHeader.getID())) break;
                    next.getHeader().setSequenceNumber(seqIndex++);
                }
                if (this.key == null) continue;
                this.keyIndex.handleKeyAddition(curRecord);
            }
        }
        DisplayLine above = this.displayLines.size() > 0 && index > 0 ? this.displayLines.get(index - 1) : null;
        DisplayLine displayLine2 = below = this.displayLines.size() > 0 && index < this.displayLines.size() - 1 ? this.displayLines.get(index + 1) : null;
        if (!(above != null && above.mergeBeginning(displayLine) || below != null && below.mergeEnd(displayLine))) {
            this.displayLines.add(index, displayLine);
        }
        displayLine.addModelListener(this);
        displayLine.setParent(this);
        this.fireModelDisplayLineChangeEvent(new FMIModelDisplayLineChangeEvent(displayLine, this, FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.ADD));
    }

    public void addDisplayLine(HiddenSet recordSet) throws FMIConversionException, FMIParseException, FMIModelException, FMIKeyException {
        this.setupDisplayLines();
        this.addDisplayLine(this.displayLines.size(), recordSet, false);
    }

    public void addDisplayLines(int index, List<DisplayLine> displayLines, boolean initializing) throws FMIConversionException, FMIParseException, FMIModelException, FMIKeyException {
        if (this.displayLines == null) {
            this.displayLines = new ArrayList<DisplayLine>();
        }
        for (DisplayLine dL : displayLines) {
            this.addDisplayLine(index++, dL, initializing);
        }
    }

    public void addDisplayLines(List<DisplayLine> displayLines, boolean initializing) throws FMIConversionException, FMIParseException, FMIModelException, FMIKeyException {
        this.setupDisplayLines();
        this.addDisplayLines(this.displayLines.size(), displayLines, initializing);
    }

    private void setupDisplayLines() {
        if (this.displayLines == null) {
            this.displayLines = new ArrayList<DisplayLine>();
        }
    }

    public void addRecord(RecordLayout layout, int[] definingObjects, int recordOffset) throws FMIConversionException, FMIParseException, FMIModelException, FMIKeyException {
        Record newRecord = new Record(this.layouts.get(this.curLayout), this);
        newRecord.buildDefaultRecord(definingObjects);
        this.addDisplayLine(recordOffset, newRecord, false);
    }

    private DisplayLine getPreviousDisplayLine(DisplayLine dl) throws FMIModelException {
        DisplayLine previousLine = null;
        boolean foundIt = false;
        for (DisplayLine d : this.displayLines) {
            if (d == dl) {
                foundIt = true;
                break;
            }
            previousLine = d;
        }
        if (!foundIt) {
            throw new FMIModelException("Internal Error: Could not find outgoing save record in display lines");
        }
        return previousLine;
    }

    public void removeDisplayLine(DisplayLine displayLine) throws FMIModelException, FMIKeyException {
        if (this.displayLines != null) {
            FMIResourceIterator<Record> iterator = displayLine.getRecordIterator();
            while (iterator.hasNext()) {
                Record curRecord = (Record)iterator.next();
                if (!curRecord.getHeader().isNew()) {
                    this.deletedRecords.add(curRecord);
                } else {
                    for (Record rec : this.newRecords) {
                        if (rec != curRecord) continue;
                        this.newRecords.remove(rec);
                        break;
                    }
                }
                if (curRecord.getHeader().isModified()) {
                    for (Record rec : this.modifiedRecords) {
                        if (rec != curRecord) continue;
                        this.modifiedRecords.remove(rec);
                        break;
                    }
                }
                FMIRecordHeaderIterator recIter = new FMIRecordHeaderIterator(curRecord, this.displayLines);
                RecordHeader previousHeader = null;
                boolean wasAnchor = curRecord.getHeader().getSequenceNumber() == 0;
                boolean wasFirstItem = false;
                if (!recIter.hasPrevious()) {
                    previousHeader = new RecordHeader();
                    wasFirstItem = true;
                } else {
                    previousHeader = recIter.previous().getHeader();
                    recIter.next();
                }
                recIter.next();
                while (recIter.hasNext()) {
                    IRecordHeaderContainer nextContainer = recIter.next();
                    RecordHeader nextHeader = nextContainer.getHeader();
                    if (!Arrays.equals(nextHeader.getID(), curRecord.getHeader().getID())) break;
                    nextHeader.setID(previousHeader.getID());
                    if (wasAnchor && !wasFirstItem) continue;
                    nextHeader.setSequenceNumber(nextHeader.getSequenceNumber() - 1);
                }
                curRecord.getHeader().setDeleted();
                if (this.key == null) continue;
                this.keyIndex.handleKeyDeletion(curRecord);
            }
            this.displayLines.remove(displayLine);
            displayLine.removeModelListener(this);
            displayLine.setParent(null);
            try {
                this.fireModelDisplayLineChangeEvent(new FMIModelDisplayLineChangeEvent(displayLine, this, FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.REMOVE));
            }
            catch (FMIKeyException fMIKeyException) {
                throw new FMIModelException("Internal Error: Unknown");
            }
        }
    }

    public void removeDisplayLineFromView(int index) throws FMIModelException {
        if (index >= 0 && index < this.displayLines.size()) {
            DisplayLine displayLine = this.displayLines.get(index);
            this.displayLines.remove(index);
            displayLine.removeModelListener(this);
            try {
                this.fireModelDisplayLineChangeEvent(new FMIModelDisplayLineChangeEvent(displayLine, this, FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.REMOVE_FROM_VIEW));
            }
            catch (FMIKeyException fMIKeyException) {
                throw new FMIModelException("Internal Error: Unknown");
            }
        }
    }

    public void addRecordLayout(RecordLayout layout) throws FMIModelException, FMIKeyException {
        if (this.layouts == null) {
            this.layouts = new ArrayList<RecordLayout>();
        }
        this.layouts.add(layout);
    }

    public void addRecordLayout(List<RecordLayout> layouts) throws FMIModelException, FMIKeyException {
        if (this.layouts == null) {
            this.layouts = new ArrayList<RecordLayout>();
        }
        this.layouts.addAll(layouts);
    }

    public void removeRecordLayout(RecordLayout layout) throws FMIModelException {
        if (this.layouts != null) {
            this.layouts.remove(layout);
        }
    }

    @Override
    public void handleFieldChangeEvent(FMIModelFieldChangeEvent event) throws FMIModelException {
        this.fireModelFieldChangeEvent(event);
    }

    @Override
    public void handleDisplayLineChangeEvent(FMIModelDisplayLineChangeEvent event) throws FMIModelException {
        this.fireModelDisplayLineChangeEvent(event);
    }

    @Override
    public void handleMultiDisplayLineChangeEvent(FMIModelMultiDisplayLineChangeEvent event) throws FMIModelException {
        this.fireModelMultiDisplayLineChangeEvent(event);
    }

    public void setChildModified(Record modifiedRecord) {
        this.modifiedRecords.add(modifiedRecord);
    }

    public RecordLayout getCurLayout() {
        return this.layouts.get(this.curLayout);
    }

    public void moveLineUp(DisplayLine line) throws FMIModelException, FMIKeyException {
        if (this.displayLines == null || this.displayLines.size() == 0 || line instanceof ShadowLine) {
            throw new FMIModelException("Cannot move line");
        }
        int index = this.displayLines.indexOf(line);
        if (index < 1) {
            throw new FMIModelException("Cannot move line");
        }
        DisplayLine above = this.displayLines.get(index - 1);
        DisplayLine below = null;
        if (index < this.displayLines.size() - 1) {
            below = this.displayLines.get(index + 1);
        }
        DisplayLine[] newLines = null;
        DisplayLine[] removed = null;
        DisplayLine[] moved = null;
        DisplayLine[] changed = null;
        if (above.canSplit()) {
            DisplayLine newLine = above.splitOffEnd();
            this.displayLines.add(index + 1, newLine);
            if (this.attemptMergeBelow(newLine, below)) {
                changed = new DisplayLine[2];
                changed[1] = below;
            } else {
                newLines = new DisplayLine[]{newLine};
                changed = new DisplayLine[]{above};
            }
        } else {
            this.displayLines.add(index - 1, this.displayLines.remove(index));
            if (this.attemptMergeBelow(above, below)) {
                changed = new DisplayLine[]{below};
                removed = new DisplayLine[]{above};
            } else {
                moved = new DisplayLine[]{line, above};
            }
        }
        this.fireModelMultiDisplayLineChangeEvent(new FMIModelMultiDisplayLineChangeEvent(newLines, removed, moved, changed, this));
    }

    private boolean attemptMergeBelow(DisplayLine above, DisplayLine below) {
        if (below != null && below.mergeBeginning(above)) {
            this.displayLines.remove(above);
            return true;
        }
        return false;
    }

    private boolean attemptMergeAbove(DisplayLine above, DisplayLine below) {
        if (above != null && above.mergeEnd(below)) {
            this.displayLines.remove(below);
            return true;
        }
        return false;
    }

    public void moveLineDown(DisplayLine line) throws FMIModelException, FMIKeyException {
        if (this.displayLines == null || this.displayLines.size() == 0 || line instanceof ShadowLine) {
            throw new FMIModelException("Cannot move line");
        }
        int index = this.displayLines.indexOf(line);
        if (index == -1 || index > this.displayLines.size() - 2) {
            throw new FMIModelException("Cannot move line");
        }
        DisplayLine above = index > 1 ? this.displayLines.get(index - 1) : null;
        DisplayLine below = this.displayLines.get(index + 1);
        DisplayLine[] newLines = null;
        DisplayLine[] removed = null;
        DisplayLine[] moved = null;
        DisplayLine[] changed = null;
        if (below.canSplit()) {
            DisplayLine newLine = below.splitOffBeginning();
            this.displayLines.add(index, below.splitOffBeginning());
            if (this.attemptMergeAbove(above, newLine)) {
                changed = new DisplayLine[2];
                changed[1] = above;
            } else {
                newLines = new DisplayLine[]{newLine};
                changed = new DisplayLine[]{below};
            }
        } else {
            this.displayLines.add(index + 1, this.displayLines.remove(index));
            if (this.attemptMergeAbove(above, below)) {
                changed = new DisplayLine[]{above};
                removed = new DisplayLine[]{below};
            } else {
                moved = new DisplayLine[]{line, below};
            }
        }
        this.fireModelMultiDisplayLineChangeEvent(new FMIModelMultiDisplayLineChangeEvent(newLines, removed, moved, changed, this));
    }

    public int numDisplayLines() {
        if (this.displayLines == null) {
            return 0;
        }
        return this.displayLines.size();
    }

    public void hideRecord(Record toHide, Class<? extends HiddenSet> hiddenSetType) throws FMIModelException, FMIKeyException {
        int index = this.displayLines.indexOf(toHide);
        if (index == -1) {
            throw new FMIModelException("Internal Error: Attempted to modify non-existant display line");
        }
        HiddenSet newHiddenSet = null;
        try {
            newHiddenSet = hiddenSetType.newInstance();
        }
        catch (Exception exception) {
            throw new FMIModelException("Internal Error: Provided invalid shadow line class");
        }
        newHiddenSet.setParent(this);
        toHide.setParent(newHiddenSet);
        toHide.addModelListener(newHiddenSet);
        newHiddenSet.addRecord(toHide);
        DisplayLine above = index >= 1 ? this.displayLines.get(index - 1) : null;
        DisplayLine below = index < this.displayLines.size() - 1 ? this.displayLines.get(index + 1) : null;
        toHide.removeModelListener(this);
        this.removeDisplayLineFromView(index);
        if (above != null && above.mergeEnd(newHiddenSet)) {
            DisplayLine[] removed = null;
            DisplayLine[] changed = new DisplayLine[]{above};
            if (below != null && above.mergeEnd(below)) {
                removed = new DisplayLine[2];
                removed[1] = below;
                this.removeDisplayLine(this.displayLines.get(index));
            } else {
                removed = new DisplayLine[]{toHide};
            }
            this.fireModelMultiDisplayLineChangeEvent(new FMIModelMultiDisplayLineChangeEvent(null, removed, null, changed, this));
        } else if (below == null || !below.mergeBeginning(newHiddenSet)) {
            DisplayLine[] removed = new DisplayLine[]{toHide};
            DisplayLine[] changed = new DisplayLine[]{below};
            this.displayLines.add(index, newHiddenSet);
            this.fireModelMultiDisplayLineChangeEvent(new FMIModelMultiDisplayLineChangeEvent(null, removed, null, changed, this));
        } else {
            this.fireModelDisplayLineChangeEvent(new FMIModelDisplayLineChangeEvent(toHide, this, FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.CHANGE));
        }
    }

    public void makeRecordVisible(Record visible) throws FMIModelException, FMIKeyException {
        if (!(visible.getParent() instanceof HiddenSet)) {
            throw new FMIModelException("Internal Error: Provided invalid shadow line class");
        }
        HiddenSet containingSet = (HiddenSet)visible.getParent();
        int index = this.displayLines.indexOf(containingSet);
        if (index == -1) {
            throw new FMIModelException("Internal Error: Provided invalid shadow line class");
        }
        ArrayList<DisplayLine> newLines = containingSet.removeRecordandSplit(visible);
        for (DisplayLine line : newLines) {
            line.setParent(this);
            line.addModelListener(this);
        }
        this.displayLines.remove(index);
        this.displayLines.addAll(index, newLines);
        this.fireModelMultiDisplayLineChangeEvent(new FMIModelMultiDisplayLineChangeEvent(newLines.toArray(new DisplayLine[0]), new DisplayLine[]{containingSet}, null, null, this));
    }

    public void saveToFile(String fileName) {
        try {
            FileOutputStream fout = new FileOutputStream(fileName);
            for (DisplayLine d : this.displayLines) {
                ((OutputStream)fout).write(d.getFullEbcdic());
            }
            ((OutputStream)fout).close();
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public int getNumBytes(List<Record> recordList) throws FMIModelException {
        int byteWidth = 0;
        if (recordList != null) {
            for (Record r : recordList) {
                byteWidth += r.getFullEBCDICWidth();
            }
        }
        return byteWidth;
    }

    public boolean saveToFM(IProgressMonitor monitor) throws FMIModelException {
        if (this.keyIndex != null && this.keyIndex.containsDuplicates()) {
            throw new FMIModelException("Duplicate keys exist in data.  Save not allowed until they are removed.");
        }
        int byteWidth = 0;
        int numRecords = 0;
        int curWidth = this.getNumBytes(this.newRecords);
        if (curWidth != 0) {
            byteWidth += curWidth;
            numRecords += this.newRecords.size();
        }
        if ((curWidth = this.getNumBytes(this.modifiedRecords)) != 0) {
            byteWidth += curWidth;
            numRecords += this.modifiedRecords.size();
        }
        if ((curWidth = this.getNumBytes(this.deletedRecords)) != 0) {
            byteWidth += curWidth;
            numRecords += this.deletedRecords.size();
        }
        if (byteWidth == 0) {
            throw new FMIModelException("Internal error: no data to save");
        }
        byte[] saveBytes = new byte[byteWidth + 4];
        ByteBuffer buf = ByteBuffer.allocate(byteWidth + 4);
        buf.putInt(numRecords);
        if (this.deletedRecords != null) {
            for (Record r : this.deletedRecords) {
                buf.put(r.getFullEbcdic());
            }
        }
        if (this.newRecords != null) {
            for (Record r : this.newRecords) {
                buf.put(r.getFullEbcdic());
            }
        }
        if (this.modifiedRecords != null) {
            for (Record r : this.modifiedRecords) {
                buf.put(r.getFullEbcdic());
            }
        }
        buf.flip();
        buf.get(saveBytes);
        Integer newLayout = this.layouts.get(this.curLayout).getSymbol() == this.startLayoutSymbol ? null : new Integer(this.layouts.get(this.curLayout).getSymbol());
        return FMIClientUtilities.saveToFM((IProgressMonitor)monitor, (Object)this.zosResource, (byte[])saveBytes, (Integer)newLayout);
    }

    public KSDSKey getKey() {
        return this.key;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public boolean canShiftRecords() {
        return this.key == null;
    }

    public KSDSKeyIndex getKeyIndex() {
        return this.keyIndex;
    }

    public void changeLayout(RecordLayout newLayout) throws FMIModelException {
        if (!this.layouts.contains(newLayout)) {
            throw new FMIModelException("Cannot change to unknown layout");
        }
        if (newLayout == this.getCurLayout()) {
            return;
        }
        ArrayList<DisplayLine> newDisplayLines = new ArrayList<DisplayLine>();
        if (this.displayLines != null) {
            for (DisplayLine dl : this.displayLines) {
                List<DisplayLine> newLines = dl.changeLayout(newLayout);
                if (newLines.size() > 1) {
                    newDisplayLines.addAll(newLines);
                    continue;
                }
                if (newLines.size() != 1) continue;
                if (newDisplayLines.size() > 0) {
                    DisplayLine curLine;
                    DisplayLine above = (DisplayLine)newDisplayLines.get(newDisplayLines.size() - 1);
                    if (above.mergeEnd(curLine = newLines.get(0))) continue;
                    newDisplayLines.add(curLine);
                    continue;
                }
                newDisplayLines.add(newLines.get(0));
            }
            this.displayLines = newDisplayLines;
        }
        this.curLayout = this.layouts.indexOf(newLayout);
    }

    @Override
    public void addModelListenerAllLevels(IFMIModelListener listener) {
        this.addModelListener(listener);
        for (DisplayLine d : this.displayLines) {
            d.addModelListenerAllLevels(listener);
        }
    }

    @Override
    public void removeModelListenerAllLevels(IFMIModelListener listener) {
        this.removeModelListener(listener);
        for (DisplayLine d : this.displayLines) {
            d.removeModelListenerAllLevels(listener);
        }
    }

    public FMIResourceIterator<DisplayLine> getDisplayLineIterator() {
        return new FMIResourceIterator<DisplayLine>(this.displayLines);
    }

    public FMIResourceIterator<RecordLayout> getRecordLayoutIterator() {
        return new FMIResourceIterator<RecordLayout>(this.layouts);
    }

    public void cleanUp(Shell activeShell) {
        FMIClientUtilities.cleanUpDatasets((String)this.datasetName);
        FMIClientUtilities.closeEditorSession((Object)this.zosResource, (Shell)activeShell);
    }

    void setZosResource(Object zosResource) {
        this.zosResource = zosResource;
    }

    void setEditSessionProperties(FMIEditSessionProperties properties) {
        this.sessionProperties = properties;
        if (this.sessionProperties.getKeyLen() > 0 && this.sessionProperties.getKeyOffset() >= 1) {
            this.key = new KSDSKey(this.sessionProperties.getKeyOffset() - 1, this.sessionProperties.getKeyLen());
            this.keyIndex = new KSDSKeyIndex(this.key, this);
        }
    }

    public FMIDisplayLineRecordIterator getDisplayLineRecordIterator() throws FMIModelException {
        return new FMIDisplayLineRecordIterator(this.displayLines);
    }

    public int getMaxLRECL() {
        return this.sessionProperties.getMaxRECL();
    }
}

