/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.DefiningObject;
import com.ibm.fmi.model.DisplayOrderComparator;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroup;
import com.ibm.fmi.model.FieldGroupIterator;
import com.ibm.fmi.model.FieldGroupVarArray;
import com.ibm.fmi.model.FieldIterator;
import com.ibm.fmi.model.IFieldGroupContainer;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIModelException;
import java.util.ArrayList;
import java.util.Arrays;

public class RecordLayout
extends FMIResource
implements IFieldGroupContainer {
    protected FieldGroup topLevelItem = null;
    private TemplattedData dataset = null;
    private static final int NO_DEFINING_OBJECT = -1;
    public static final int NO_VAR_ARRAY = -1;
    protected int symbol;
    protected String name;
    protected boolean valid = false;
    protected Field[] displayOrderFields;
    protected Field[] modelOrderFields;
    int firstVarArrayIndex = -1;
    int lastDefiningObject = -1;

    public RecordLayout(int symbol, String name, TemplattedData dataset, FieldGroup topLevelDataItem) throws FMIModelException {
        this.topLevelItem = topLevelDataItem;
        this.dataset = dataset;
        this.symbol = symbol;
        this.name = name;
        this.initializeFieldGroups(this, this.topLevelItem);
        this.modelOrderFields = this.buildFieldsArray(this.topLevelItem, false);
        this.displayOrderFields = this.buildFieldsArray(this.topLevelItem, true);
        this.topLevelItem.calculateWidths();
    }

    protected RecordLayout(TemplattedData dataset) {
        this.dataset = dataset;
    }

    Field[] buildFieldsArray(FieldGroup topLevel, boolean sort) {
        if (topLevel instanceof Field) {
            Field[] curFields = new Field[]{(Field)topLevel};
            return curFields;
        }
        FieldIterator fIterator = new FieldIterator(topLevel);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (fIterator.hasNext()) {
            fieldList.add(fIterator.next());
        }
        Field[] fieldArr = fieldList.toArray(new Field[0]);
        Arrays.sort(fieldArr, new DisplayOrderComparator());
        int i = 0;
        while (i < fieldArr.length) {
            fieldArr[i].setDisplayIndex(i);
            ++i;
        }
        return fieldArr;
    }

    public int getMaxASCIIWidth() {
        return this.topLevelItem.getMaxAsciiWidth();
    }

    public int getEbcdicWidth() {
        return this.topLevelItem.getMaxEbcdicWidth();
    }

    public int getFirstVarArrayIndex() {
        return this.firstVarArrayIndex;
    }

    public FieldGroup copyContentItems(Record parent) throws FMIModelException {
        if (this.topLevelItem == null) {
            return null;
        }
        FieldGroup newTopLevel = this.topLevelItem.copy();
        this.initializeFieldGroups(parent, newTopLevel);
        FieldIterator fIterator = new FieldIterator(newTopLevel);
        while (fIterator.hasNext()) {
            Field nextField = fIterator.next();
            nextField.addModelListener(parent);
        }
        return newTopLevel;
    }

    private void initializeFieldGroups(IFieldGroupContainer parent, FieldGroup newTopLevel) throws FMIModelException {
        FieldGroupIterator fgIterator = new FieldGroupIterator(newTopLevel);
        int modelIndex = 0;
        while (fgIterator.hasNext()) {
            FieldGroup cur = fgIterator.next();
            cur.setModelIndex(modelIndex++);
            cur.setParentResource(parent);
            if (!(cur instanceof FieldGroupVarArray)) continue;
            FieldGroupVarArray varArray = (FieldGroupVarArray)cur;
            FieldGroup defGroup = FieldGroupIterator.findFieldGroup(newTopLevel, varArray.getDependsOn().getModelIndex());
            if (defGroup instanceof DefiningObject) {
                DefiningObject defObject = (DefiningObject)defGroup;
                defObject.setTgtArray(varArray);
                varArray.setDependsOn(defObject);
                continue;
            }
            throw new FMIModelException("Internal Error - Variable length array locations inconsistent");
        }
    }

    public Record createRecord() throws FMIModelException {
        Record newRecord = new Record(this, this.dataset);
        return newRecord;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addModelListenerAllLevels(IFMIModelListener listener) {
        this.addModelListener(listener);
    }

    public void removeModelListenerAllLevels(IFMIModelListener listener) {
        this.removeModelListener(listener);
    }

    public FieldIterator getFieldIterator() {
        return new FieldIterator(this.topLevelItem);
    }

    public FieldGroupIterator getFieldGroupIterator() {
        return new FieldGroupIterator(this.topLevelItem);
    }

    public FieldGroup findFieldGroup(int modelIndex) {
        return FieldGroupIterator.findFieldGroup(this.topLevelItem, modelIndex);
    }

    public FMIResource getFMIResource() {
        return this;
    }

    public int numDisplayFields() {
        return this.displayOrderFields.length;
    }

    public Field getDisplayField(int index) {
        return this.displayOrderFields[index];
    }

    public Field getModelField(int index) {
        return this.modelOrderFields[index];
    }

    public int numModelFields() {
        return this.modelOrderFields.length;
    }

    public byte[] getRecordContent(int offset, int length) {
        return null;
    }

    public void setRecordContent(int offset, byte[] bytes, Field changedField, boolean fireEvent) throws FMIModelException {
    }

    public RecordLayout getLayout() {
        return this;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }
}

