/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.ByteUtilities;

public class RecordHeader {
    private byte[] header;

    RecordHeader() {
        this.header = new byte[32];
        this.setIDDefault();
        int i = 16;
        while (i < this.header.length) {
            this.header[i] = 0;
            ++i;
        }
    }

    public void setIDDefault() {
        int i = 0;
        while (i < 16) {
            this.header[i] = -1;
            ++i;
        }
    }

    public RecordHeader(byte[] header) {
        this.header = header;
    }

    public RecordHeader copy() {
        RecordHeader newHeader = new RecordHeader((byte[])this.header.clone());
        return newHeader;
    }

    public byte[] getBytes() {
        return this.header;
    }

    public void setNotSuppressed() {
        this.header[17] = (byte)(this.header[17] & 0xFFFFFFBF);
    }

    public void setSuppressed() {
        this.header[17] = (byte)(this.header[17] | 0x40);
    }

    public boolean isModified() {
        return (this.header[16] & 8) == 8;
    }

    public void setModified() {
        if (!this.isNew()) {
            this.header[16] = (byte)(this.header[16] | 8);
        }
    }

    public void setUnmodified() {
        this.header[16] = (byte)(this.header[16] & 0xFFFFFFF7);
    }

    public void setNew(byte[] id, int seqNumber) {
        this.header[16] = (byte)(this.header[16] | 0x20);
        this.setID(id);
        this.setSequenceNumber(seqNumber);
        this.setUnmodified();
    }

    public void setNew() {
        this.header[16] = (byte)(this.header[16] | 0x20);
        this.setIDDefault();
        this.setSequenceNumber(0);
        this.setUnmodified();
    }

    public void setNotNew() {
        this.header[16] = (byte)(this.header[16] & 0xFFFFFFFD);
    }

    public boolean isNew() {
        return (this.header[16] & 0x20) == 32;
    }

    public boolean isDeleted() {
        return (this.header[16] & 0x10) == 16;
    }

    public void setDeleted() {
        this.header[16] = (byte)(this.header[16] | 0x10);
    }

    public int getSequenceNumber() {
        return ByteUtilities.byteArrayToInt(this.header, 24);
    }

    public void setID(byte[] id) {
        System.arraycopy(id, 0, this.header, 0, 16);
    }

    public byte[] getID() {
        byte[] returnId = new byte[16];
        System.arraycopy(this.header, 0, returnId, 0, 16);
        return returnId;
    }

    public void setLayout(int layout) {
        byte[] layoutBytes = ByteUtilities.intToByteArray(layout);
        this.setLayout(layoutBytes);
    }

    public void setLayout(byte[] layoutBytes) {
        System.arraycopy(layoutBytes, 0, this.header, 20, 4);
    }

    public int getLayoutNumber() {
        byte[] layoutBytes = new byte[4];
        System.arraycopy(this.header, 20, layoutBytes, 0, 4);
        return ByteUtilities.byteArrayToInt(layoutBytes);
    }

    public byte[] getLayoutBytes() {
        byte[] layoutBytes = new byte[4];
        System.arraycopy(this.header, 20, layoutBytes, 0, 4);
        return layoutBytes;
    }

    public void setSequenceNumber(int seqNo) {
        byte[] seqNoBytes = ByteUtilities.intToByteArray(seqNo);
        this.setSequenceNumber(seqNoBytes);
    }

    public void setSequenceNumber(byte[] seqNoBytes) {
        System.arraycopy(seqNoBytes, 0, this.header, 24, 4);
    }

    public void setRecordLength(int length) {
        byte[] lengthBytes = ByteUtilities.intToByteArray(length);
        this.setRecordLength(lengthBytes);
    }

    public void setRecordLength(byte[] lengthBytes) {
        System.arraycopy(lengthBytes, 0, this.header, 28, 4);
    }
}

