/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.DefaultField;
import com.ibm.fmi.model.DefiningObject;
import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroup;
import com.ibm.fmi.model.FieldGroupIterator;
import com.ibm.fmi.model.FieldGroupVarArray;
import com.ibm.fmi.model.FieldIterator;
import com.ibm.fmi.model.IFieldGroupContainer;
import com.ibm.fmi.model.IRecordHeaderContainer;
import com.ibm.fmi.model.RecordHeader;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.datatypeconverters.FMIAlphaNumericDataTypeConverter;
import com.ibm.fmi.model.event.FMIModelDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.key.KSDSKey;
import com.ibm.fmi.model.key.KSDSKeyIndex;
import com.ibm.fmi.model.shadowline.HiddenSet;
import com.ibm.fmi.model.shadowline.SuppressedSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Record
extends DisplayLine
implements IFMIModelListener,
IFieldGroupContainer,
IRecordHeaderContainer {
    private FieldGroup topLevelItem;
    private RecordHeader header = null;
    private byte[] recordBytes = null;
    private Field[] displayOrderFields;
    private Field[] modelOrderFields;
    private KSDSKey theKey;
    private KSDSKeyIndex keyIndex;
    private TemplattedData model;
    private boolean containsDuplicateKey = false;
    private final String INVALID_NUM_STRING_VALUES = "The number of strings provided doesn't match the number of fields in the layout";

    public Record(RecordLayout layout, TemplattedData topLevel) throws FMIModelException {
        this.model = topLevel;
        this.theKey = this.model.getKey();
        this.keyIndex = this.model.getKeyIndex();
        this.layout = layout;
        this.topLevelItem = layout.copyContentItems(this);
        this.modelOrderFields = layout.buildFieldsArray(this.topLevelItem, false);
        this.displayOrderFields = layout.buildFieldsArray(this.topLevelItem, true);
    }

    public void setLayout(RecordLayout layout) throws FMIConversionException, FMIParseException, FMIKeyException, FMIModelException {
        this.removeListeners();
        this.layout = layout;
        this.topLevelItem = layout.copyContentItems(this);
        if (this.recordBytes != null && this.recordBytes.length > 0) {
            this.setEbcdic(this.recordBytes, true, true, false);
        }
        this.modelOrderFields = layout.buildFieldsArray(this.topLevelItem, false);
        this.displayOrderFields = layout.buildFieldsArray(this.topLevelItem, true);
    }

    public void buildDefaultRecord(int[] definingObjectValues) throws FMIModelException {
        FieldIterator fIter = this.getFieldIterator();
        this.topLevelItem.initialized = false;
        int i_dov = 0;
        while (fIter.hasNext()) {
            Field curField = fIter.next();
            if (!(curField instanceof DefiningObject)) continue;
            DefiningObject dObj = (DefiningObject)curField;
            FieldGroupVarArray varArr = dObj.getTgtArray();
            varArr.setSize(definingObjectValues[i_dov++]);
        }
        int recordWidth = this.topLevelItem instanceof DefaultField ? this.model.getMaxLRECL() : this.topLevelItem.ebcdicWidth;
        this.recordBytes = new byte[recordWidth];
        fIter.reset();
        i_dov = 0;
        while (fIter.hasNext()) {
            Field curField = fIter.next();
            if (curField instanceof DefiningObject) {
                try {
                    curField.setASCIIStr(Integer.toString(definingObjectValues[i_dov++]), false);
                    continue;
                }
                catch (FMIConversionException fMIConversionException) {
                    throw new FMIModelException("Invalid defining object value provided");
                }
            }
            if (!curField.hasRedefine() && !curField.isEmpty()) {
                curField.setDefaultValue();
                continue;
            }
            if (!curField.hasRedefine()) continue;
            curField.updateStringValue(false);
        }
        try {
            this.topLevelItem.setEbcdic(this.recordBytes, 0, true, true, false);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIModelException("Exception creating new record");
        }
        this.header = new RecordHeader();
        this.header.setRecordLength(this.recordBytes.length);
        this.header.setLayout(this.layout.getSymbol());
    }

    public void setEbcdic(byte[] bytes, boolean initializing, boolean fullRecord, boolean fireEvent) throws FMIConversionException, FMIParseException, FMIKeyException, FMIModelException {
        if (!fullRecord && this.recordBytes != null && this.recordBytes.length > bytes.length) {
            System.arraycopy(bytes, 0, this.recordBytes, 0, bytes.length);
        } else {
            this.recordBytes = bytes;
        }
        if (this.topLevelItem instanceof DefaultField) {
            ((DefaultField)this.topLevelItem).setDefaultWidth(this.recordBytes.length);
        }
        this.topLevelItem.setEbcdic(bytes, 0, initializing, true, fireEvent);
    }

    private int getWidth() {
        return this.topLevelItem.getActualEbcdicWidth();
    }

    public byte[] getEbcdic() {
        return this.topLevelItem.getEbcdicValue();
    }

    public String getASCIIString() throws FMIConversionException, FMIModelException {
        byte[] bytes = this.getEbcdic();
        return new FMIAlphaNumericDataTypeConverter().EBCDICtoASCIIstr(bytes, bytes.length, null);
    }

    public void setAsciiString(String string, boolean fireEvent) throws FMIConversionException, FMIParseException, FMIKeyException, FMIModelException {
        if (this.topLevelItem == null || string == null || string.length() == 0) {
            return;
        }
        byte[] oldEBCDIC = this.getEbcdic();
        byte[] bytes = new FMIAlphaNumericDataTypeConverter().ASCIIstrToEBCDIC(string, oldEBCDIC, this.getWidth(), null);
        this.setEbcdic(bytes, true, false, fireEvent);
        if (!Arrays.equals(bytes, oldEBCDIC)) {
            this.setModified();
        }
    }

    public void setFieldsAscii(String[] fieldValues) throws FMIConversionException, FMIModelException, FMIKeyException, FMIModelException {
        if (this.modelOrderFields.length != fieldValues.length) {
            throw new FMIModelException("The number of strings provided doesn't match the number of fields in the layout");
        }
        int i_values = 0;
        Field[] fieldArray = this.modelOrderFields;
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field f = fieldArray[n];
            f.setASCIIStr(fieldValues[i_values++], true);
            ++n;
        }
    }

    public Field[] getDisplayFields() {
        return this.displayOrderFields;
    }

    public Field[] getModelFields() {
        return this.modelOrderFields;
    }

    @Override
    public RecordHeader getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = new RecordHeader(header);
    }

    public void setHeader(RecordHeader header) {
        this.header = header;
    }

    @Override
    public byte[] getFullEbcdic() {
        byte[] headerBytes = this.header.getBytes();
        byte[] buf = new byte[headerBytes.length + this.recordBytes.length];
        System.arraycopy(headerBytes, 0, buf, 0, headerBytes.length);
        System.arraycopy(this.recordBytes, 0, buf, headerBytes.length, this.recordBytes.length);
        return buf;
    }

    public byte[] getRecordEbcdic() {
        return this.recordBytes;
    }

    @Override
    public boolean mergeBeginning(DisplayLine toMerge) {
        return false;
    }

    @Override
    public boolean mergeEnd(DisplayLine toMerge) {
        return false;
    }

    @Override
    public DisplayLine copy() throws FMIParseException, FMIConversionException, FMIKeyException, FMIModelException {
        Record copy = new Record(this.layout, this.model);
        byte[] newRecordContents = new byte[this.recordBytes.length];
        System.arraycopy(this.recordBytes, 0, newRecordContents, 0, this.recordBytes.length);
        copy.setEbcdic(newRecordContents, true, true, false);
        copy.setHeader(this.header.copy());
        return copy;
    }

    private void removeListeners() {
        if (this.displayOrderFields != null && this.displayOrderFields.length > 0) {
            Field[] fieldArray = this.displayOrderFields;
            int n = 0;
            int n2 = fieldArray.length;
            while (n < n2) {
                Field f = fieldArray[n];
                f.removeModelListener(this);
                f.setParent(null);
                ++n;
            }
        }
    }

    @Override
    public RecordLayout getLayout() {
        return this.layout;
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public DisplayLine splitOffBeginning() {
        return null;
    }

    @Override
    public DisplayLine splitOffEnd() {
        return null;
    }

    public int getFullEBCDICWidth() {
        return this.recordBytes.length + this.header.getBytes().length;
    }

    public void setContainsDuplicateKey() throws FMIModelException {
        this.containsDuplicateKey = true;
        this.fireModelDisplayLineChangeEvent(new FMIModelDisplayLineChangeEvent(this, this.parent, FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.CHANGE));
    }

    public void clearContainsDuplicateKey() throws FMIModelException {
        this.containsDuplicateKey = false;
        if (this.parent instanceof HiddenSet) {
            ((HiddenSet)this.parent).fireModelDisplayLineChangeEvent(new FMIModelDisplayLineChangeEvent((HiddenSet)this.parent, ((HiddenSet)this.parent).getParent(), FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.CHANGE));
        } else {
            this.fireModelDisplayLineChangeEvent(new FMIModelDisplayLineChangeEvent(this, this.parent, FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.CHANGE));
        }
    }

    @Override
    public boolean containsDuplicateKey() {
        return this.containsDuplicateKey;
    }

    public int numRecords() {
        return 1;
    }

    @Override
    public DisplayLine splitOffBeginning(int numUpper) {
        return null;
    }

    @Override
    public DisplayLine splitOffEnd(int numLower) {
        return null;
    }

    @Override
    public Field getDisplayField(int index) {
        if (index < 0 || index >= this.displayOrderFields.length) {
            throw new ArrayIndexOutOfBoundsException("Array out of bounds");
        }
        return this.displayOrderFields[index];
    }

    public Record getRecord(int index) throws FMIModelException {
        if (index != 0) {
            throw new FMIModelException("Array out of bounds");
        }
        return this;
    }

    @Override
    public List<DisplayLine> changeLayout(RecordLayout layout) throws FMIModelException {
        ArrayList<DisplayLine> newDL = new ArrayList<DisplayLine>(1);
        if (this.layout == layout) {
            newDL.add(this);
        } else {
            SuppressedSet suppSet = new SuppressedSet();
            suppSet.setLayout(this.layout);
            suppSet.setParent(this.parent);
            suppSet.addRecord(this);
            this.removeModelListener((TemplattedData)this.parent);
            this.setParent(suppSet);
            this.addModelListener(suppSet);
            this.header.setSuppressed();
            newDL.add(suppSet);
        }
        return newDL;
    }

    @Override
    public void removeModelListenerAllLevels(IFMIModelListener listener) {
        Field[] fieldArray = this.displayOrderFields;
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field f = fieldArray[n];
            f.removeModelListener(listener);
            ++n;
        }
        this.removeModelListener(listener);
    }

    @Override
    public void addModelListenerAllLevels(IFMIModelListener listener) {
        Field[] fieldArray = this.displayOrderFields;
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field f = fieldArray[n];
            f.addModelListener(listener);
            ++n;
        }
        this.addModelListener(listener);
    }

    @Override
    public FMIResourceIterator<Record> getRecordIterator() {
        ArrayList<Record> recList = new ArrayList<Record>(1);
        recList.add(this);
        return new FMIResourceIterator<Record>(recList);
    }

    public FieldIterator getFieldIterator() {
        return new FieldIterator(this.topLevelItem);
    }

    @Override
    public FieldGroup findFieldGroup(int modelIndex) {
        return FieldGroupIterator.findFieldGroup(this.topLevelItem, modelIndex);
    }

    @Override
    public FMIResource getFMIResource() {
        return this;
    }

    public int indexOf(Field field) {
        int i = 0;
        while (i < this.displayOrderFields.length) {
            if (field.equals(this.displayOrderFields[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public byte[] getRecordContent(int offset, int length) {
        if (length == -22) {
            length = this.recordBytes.length;
        }
        byte[] tempArray = new byte[length];
        System.arraycopy(this.recordBytes, offset, tempArray, 0, length);
        return tempArray;
    }

    @Override
    public void setRecordContent(int offset, byte[] bytes, Field changedField, boolean fireEvent) throws FMIModelException {
        byte[] oldRecord;
        block6: {
            if (offset + bytes.length > this.recordBytes.length) {
                throw new FMIModelException("Attempted to write beyond end of record");
            }
            byte[] oldValue = new byte[bytes.length];
            oldRecord = (byte[])this.recordBytes.clone();
            System.arraycopy(this.recordBytes, offset, oldValue, 0, bytes.length);
            System.arraycopy(bytes, 0, this.recordBytes, offset, bytes.length);
            boolean didSetModified = this.setModified();
            ArrayList<Object> changedFields = new ArrayList();
            try {
                changedFields = this.topLevelItem.testRecordChange(offset, bytes.length, changedField);
                if (changedFields != null) {
                    for (Field field : changedFields) {
                        if (field == changedField) continue;
                        field.updateStringValue(false);
                    }
                }
            }
            catch (FMIModelException fMIModelException) {
                System.arraycopy(oldValue, 0, this.recordBytes, offset, bytes.length);
                if (this.header == null || !didSetModified) break block6;
                this.header.setUnmodified();
            }
        }
        if (this.theKey != null && offset < this.theKey.getOffset() + this.theKey.getLength() && offset + bytes.length > this.theKey.getOffset() && this.topLevelItem.initialized) {
            byte[] byArray = new byte[this.theKey.getLength()];
            System.arraycopy(oldRecord, this.theKey.getOffset(), byArray, 0, this.theKey.getLength());
            this.keyIndex.handleKeyChange(this, byArray);
        }
    }

    private boolean setModified() {
        boolean didSetModified = false;
        if (this.header != null && !this.header.isModified() && !this.header.isNew()) {
            this.header.setModified();
            didSetModified = true;
            this.model.setChildModified(this);
        }
        return didSetModified;
    }

    @Override
    public int numDisplayFields() {
        return this.displayOrderFields == null ? 0 : this.displayOrderFields.length;
    }

    public RecordHeader copyHeader() {
        return this.header.copy();
    }

    @Override
    public int numModelFields() {
        return this.modelOrderFields == null ? 0 : this.modelOrderFields.length;
    }

    @Override
    public Field getModelField(int index) {
        return index >= this.modelOrderFields.length || index < 0 ? null : this.modelOrderFields[index];
    }

    public byte[] getKeyContent() {
        return this.theKey == null ? null : this.getRecordContent(this.theKey.getOffset(), this.theKey.getLength());
    }
}

