/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.IFieldGroupContainer;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldGroup
extends FMIResource {
    public static final int UNKNOWN_INDEX = -1;
    protected int startLayoutIndex;
    protected int endLayoutIndex;
    protected int modelIndex;
    protected int recordOffset;
    protected int level;
    protected FieldGroup[] children;
    protected FieldGroup parent;
    protected IFieldGroupContainer parentResource;
    protected String name;
    public int NO_WIDTH = 0;
    protected int ebcdicWidth;
    protected int actualWidth;
    protected int maxAsciiWidth;
    protected boolean editable;
    protected int numSlackBytes;
    protected boolean hasRedefine;
    protected boolean empty;
    protected boolean hasContent;
    protected int symbol;
    protected boolean initialized;
    protected boolean containsODOChild;

    public FieldGroup(String name, int level, int recordOffset, int length, int symbol, FieldGroup[] children) {
        this.name = name;
        this.level = level;
        this.children = children;
        this.symbol = symbol;
        this.startLayoutIndex = -1;
        this.endLayoutIndex = -1;
        this.ebcdicWidth = length;
        this.recordOffset = recordOffset;
        this.parent = null;
        this.initialized = false;
        this.actualWidth = this.NO_WIDTH;
        this.maxAsciiWidth = this.NO_WIDTH;
        this.editable = false;
        this.empty = false;
        this.hasContent = false;
        this.hasRedefine = false;
        this.numSlackBytes = 0;
        this.setUpChildren();
        this.containsODOChild = false;
    }

    protected void setUpChildren() {
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.setParent(this);
            ++n;
        }
        this.calculateWidths();
    }

    public String getName() {
        return this.name;
    }

    public FieldGroup copy() throws FMIModelException {
        FieldGroup[] copyChildren = new FieldGroup[this.children.length];
        int i = 0;
        while (i < copyChildren.length) {
            copyChildren[i] = this.children[i].copy();
            ++i;
        }
        FieldGroup copy = new FieldGroup(this.name, this.level, this.recordOffset, this.ebcdicWidth, this.symbol, copyChildren);
        copy.numSlackBytes = this.numSlackBytes;
        copy.hasRedefine = this.hasRedefine;
        copy.setStartLayoutIndex(this.startLayoutIndex);
        FieldGroup[] fieldGroupArray = copy.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup child = fieldGroupArray[n];
            child.setParent(copy);
            ++n;
        }
        return copy;
    }

    public int getActualEbcdicWidth() {
        return this.actualWidth;
    }

    public byte[] getEbcdicValue() {
        if (!this.initialized) {
            return new byte[0];
        }
        if (this.ebcdicWidth < 0) {
            return this.parentResource.getRecordContent(this.recordOffset, this.actualWidth);
        }
        return this.parentResource.getRecordContent(this.recordOffset, this.ebcdicWidth);
    }

    public int getMaxAsciiWidth() {
        return this.maxAsciiWidth;
    }

    public int getMaxEbcdicWidth() {
        return this.ebcdicWidth;
    }

    public int setEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        if (decrement != 0) {
            this.recordOffset -= decrement;
        }
        if (this.actualWidth != 0 && !initializing && (ebcdic = this.prepareNewEbcdicArr(this.getEbcdicValue(), ebcdic)) == null) {
            return 0;
        }
        decrement = this.setChildrenEbcdic(ebcdic, decrement, initializing, forceVal, fireEvent);
        this.initialized = true;
        return decrement;
    }

    protected byte[] prepareNewEbcdicArr(byte[] oldEbcdic, byte[] newEbcdic) throws FMIConversionException {
        byte[] curPiece = new byte[this.ebcdicWidth];
        System.arraycopy(newEbcdic, this.recordOffset, curPiece, 0, this.ebcdicWidth);
        newEbcdic = curPiece;
        if (newEbcdic.length > this.ebcdicWidth || oldEbcdic.length != 0 && newEbcdic.length > oldEbcdic.length || newEbcdic.length == 0) {
            throw new FMIConversionException("Invalid EBCDIC width");
        }
        if (Arrays.equals(oldEbcdic, newEbcdic)) {
            return null;
        }
        if (newEbcdic.length < oldEbcdic.length) {
            System.arraycopy(newEbcdic, 0, oldEbcdic, 0, newEbcdic.length);
            newEbcdic = oldEbcdic;
        }
        return newEbcdic;
    }

    protected int setChildrenEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        this.actualWidth = 0;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            if (!f.isEmpty()) {
                decrement = f.setEbcdic(ebcdic, decrement, initializing, forceVal, fireEvent);
                if (!f.hasRedefine) {
                    this.actualWidth += f.actualWidth;
                }
            }
            ++n;
        }
        return decrement;
    }

    public void calculateWidths() {
        this.maxAsciiWidth = 0;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            this.maxAsciiWidth += f.getMaxAsciiWidth();
            ++n;
        }
    }

    @Override
    public void removeModelListenerAllLevels(IFMIModelListener listener) {
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.removeModelListener(listener);
            ++n;
        }
        this.removeModelListener(listener);
    }

    @Override
    public void addModelListenerAllLevels(IFMIModelListener listener) {
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.addModelListener(listener);
            ++n;
        }
        this.addModelListener(listener);
    }

    public boolean containsData() {
        return false;
    }

    public void setParentResource(IFieldGroupContainer parentResource) {
        this.parentResource = parentResource;
    }

    public int getRecordOffset() {
        return this.recordOffset;
    }

    public IFieldGroupContainer getParentResource() {
        return this.parentResource;
    }

    FieldGroup getParent() {
        return this.parent;
    }

    void setParent(FieldGroup parent) {
        this.parent = parent;
    }

    protected void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    protected int getModelIndex() {
        return this.modelIndex;
    }

    public int setStartLayoutIndex(int startLayoutIndex) {
        this.startLayoutIndex = startLayoutIndex;
        int curIndex = startLayoutIndex;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            if (!f.isEmpty()) {
                curIndex = f.setStartLayoutIndex(curIndex);
            }
            ++n;
        }
        this.endLayoutIndex = curIndex;
        return curIndex;
    }

    public int getStartLayoutIndex() {
        return this.startLayoutIndex;
    }

    public int getEndLayoutIndex() {
        return this.endLayoutIndex;
    }

    public int numChildren() {
        return this.children.length;
    }

    public FieldGroup getChild(int index) {
        if (index < this.children.length) {
            return this.children[index];
        }
        return null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.setEditable(editable);
            ++n;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean isHasContent() {
        return this.hasContent;
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
    }

    protected void incrementRecordOffset(int increment) {
        this.recordOffset += increment;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.incrementRecordOffset(increment);
            ++n;
        }
    }

    protected void decrementRecordOffset(int decrement) {
        this.recordOffset -= decrement;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.decrementRecordOffset(decrement);
            ++n;
        }
    }

    protected void setEndLayoutIndex(int endLayoutIndex) {
        this.endLayoutIndex = endLayoutIndex;
    }

    public int getSymbol() {
        return this.symbol;
    }

    void addNameIndex(int index) {
        int startParen = this.name.indexOf(40);
        this.name = startParen == -1 ? String.valueOf(this.name) + "(" + (index + 1) + ")" : String.valueOf(this.name.substring(0, startParen + 1)) + (index + 1) + "," + this.name.substring(startParen + 1, this.name.length());
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            f.addNameIndex(index);
            ++n;
        }
    }

    ArrayList<Field> testRecordChange(int offset, int length, Field changedField) throws FMIModelException {
        if (!this.recordChangeApplies(offset, length)) {
            return null;
        }
        ArrayList<Field> changedFields = new ArrayList<Field>();
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            ArrayList<Field> childChangedFields = f.testRecordChange(offset, length, changedField);
            if (childChangedFields != null) {
                changedFields.addAll(childChangedFields);
            }
            ++n;
        }
        return changedFields;
    }

    protected boolean recordChangeApplies(int offset, int length) {
        return offset <= this.recordOffset + this.actualWidth && this.recordOffset <= offset + length;
    }

    int getNumSlackBytes() {
        return this.numSlackBytes;
    }

    public int setSlackBytes(FieldGroup nextGroup) {
        FieldGroup previousChild = null;
        this.numSlackBytes = 0;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup child = fieldGroupArray[n];
            if (!child.hasRedefine()) {
                if (previousChild != null) {
                    previousChild.setSlackBytes(child);
                    this.numSlackBytes += previousChild.numSlackBytes;
                }
                previousChild = child;
            }
            ++n;
        }
        if (previousChild != null) {
            previousChild.setSlackBytes(nextGroup);
            this.numSlackBytes += previousChild.numSlackBytes;
        }
        return this.numSlackBytes;
    }

    public void setHasRedefine() {
        this.hasRedefine = true;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup c = fieldGroupArray[n];
            c.setHasRedefine();
            ++n;
        }
    }

    public boolean hasRedefine() {
        return this.hasRedefine;
    }

    public void setContainsODOChild() {
        this.containsODOChild = true;
    }

    public boolean requiresHalfWordBoundary() {
        return this.children[0].requiresHalfWordBoundary();
    }

    public boolean requiresFullWordBoundary() {
        return this.children[0].requiresFullWordBoundary();
    }

    public boolean isAligned() {
        return this.children[0].isAligned();
    }

    public void decrementWidth(int decrement) {
        this.ebcdicWidth -= decrement;
        if (this.parent != null) {
            this.parent.decrementWidth(decrement);
        }
    }

    public void setInitialized() {
        this.initialized = true;
    }
}

