/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.HiddenSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FMIDisplayLineRecordIterator
implements Iterator<Record> {
    public ListIterator<DisplayLine> displayLineIterator;
    public FMIResourceIterator<Record> recordIterator;
    public Record next;

    public FMIDisplayLineRecordIterator(List<DisplayLine> displayLines) throws FMIModelException {
        this.displayLineIterator = displayLines.listIterator();
        this.recordIterator = null;
        this.next = null;
        this.findFirstRecord(displayLines);
    }

    private void findFirstRecord(List<DisplayLine> displayLines) throws FMIModelException {
        while (this.displayLineIterator.hasNext()) {
            DisplayLine cur = this.displayLineIterator.next();
            if (cur instanceof Record) {
                this.next = (Record)cur;
                break;
            }
            if (!(cur instanceof HiddenSet)) continue;
            this.recordIterator = ((HiddenSet)cur).getRecordIterator();
            this.next = (Record)this.recordIterator.next();
            break;
        }
        if (this.next == null) {
            throw new FMIModelException("Could not find record in model");
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Record next() {
        Record toReturn = this.next;
        this.next = null;
        if (this.recordIterator != null && !this.recordIterator.hasNext()) {
            this.recordIterator = null;
        }
        if (this.recordIterator != null && this.recordIterator.hasNext()) {
            this.next = (Record)this.recordIterator.next();
        } else if (this.displayLineIterator != null && this.displayLineIterator.hasNext()) {
            DisplayLine nextDL = this.displayLineIterator.next();
            while (this.displayLineIterator.hasNext() && this.next == null) {
                if (nextDL instanceof Record) {
                    this.next = (Record)nextDL;
                    continue;
                }
                if (nextDL instanceof HiddenSet) {
                    this.recordIterator = ((HiddenSet)nextDL).getRecordIterator();
                    this.next = (Record)this.recordIterator.next();
                    continue;
                }
                nextDL = this.displayLineIterator.next();
            }
        }
        return toReturn;
    }

    @Override
    public void remove() {
    }
}

