/*********************************************************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/*********************************************************************/
/*|:h3.IDIXH.H                                                       */
/*|    IDIXH.H $$prereqs IDIIH.H                                     */
 
#define  JPAMOD                1
#define  LPAMOD                2
#define  HFSMOD                3
#define  MAX_MSGLEN            1024
 
/*********************************************************************/
/*   API Structure Definitions                                       */
/*********************************************************************/
struct XCSECT ;
typedef struct XCSECT XCSECT ;
typedef struct CMSG CMSG ;
struct CMSG ;
typedef struct CDMSG CDMSG ;
struct CDMSG ;
struct CICS_APIQ ;
typedef struct CICS_APIQ CICS_APIQ ;
struct TACBKEY;
typedef struct TACBKEY TACBKEY;
struct MOD_DATA ;
typedef struct MOD_DATA  MOD_DATA ;
struct MSGENT;
typedef struct MSGENT MSGENT;
struct MSGREL;
typedef struct MSGREL MSGREL;
 
/* Module Key Data - Load module or HFS file information              */
 struct MOD_DATA {
  int          ModDataLeng;         /* Length of load module/HFS file */
                                    /* and CSECT data in the KEY area.*/
  int          ModType;             /* Load module or HFS file        */
  char        *ModOrigin;           /* DSN or path name               */
  char         ModBDate[7];         /* Date of Binding YYYYDDD        */
  char         ModBTime[6];         /* Time of Binding HHMMSS         */
  char         ModLoadDD[9];        /* Load DD name if special load   */
  char         AliasTrueName[9];    /* if mod is alias, this is the true name */
  int          BindAttempted : 1;   /* Bind for CSECT data attempted. */
  short        ModDDConcat;         /* Concat of dataset (start at 1) */
};
 
#define INITMSGRELSZ 5
#define INCRMSGRELSZ 5
 
struct MSGENT {
  KANCHOR *pKAmsg;           /* KANCHOR of MSG'<msg_id> */
  KANCHOR *pKArel;           /* KANCHOR of 'loosely related' RELSEQ */
  unsigned int important : 1;  /* Promote message to synopsis */
};
 
struct MSGREL {
  int max_entries;           /* Total size of array in number of elements */
  int cur_entries;           /* Number of entries used */
  MSGENT msgent[1];
};
 
/*********************************************************************/
/*   API Function Definitions                                        */
/*********************************************************************/
/*****************************************************************************/
/*|:h4.xPopDCAT()                                                            */
/*|:p.The xPopDCAT() call opens the Dump Catalog and searches for the        */
/*|most recent records for the passed dump dataset name. If found it         */
/*|populates Key Information and the Dictionary with data from the dump      */
/*|catalog records.                                                          */
/*|:xmp.*/
 
void xPopDCAT(void);
 
/*|:exmp.*/
/*****************************************************************************/
/*|:h4.xCsectId()                                                            */
/*|:p.The xCsectId() call fills out the supplied structure containing        */
/*|information describing a CSECT. The caller must pass an IANCHOR for       */
/*|a CSECT.                                                                  */
/*|:xmp.*/
 
int xCsectId(IANCHOR *pIDA,char *pDSA,XCSECT *CsectID);
 
/*|:exmp.*/
/*****************************************************************/
/*|:h4.mapCsectEntryPoint                                        */
/*|The mapCsectEntryPoint function maps csect KEY data into the  */
/*|dictionary for the module Entry Points that are potential     */
/*|answers to a current WhereAmI search.  The Label Definition   */
/*|ESD items from the binder are tested with a call to           */
/*|LECuData to chech the LE signature data (PPA1 PPA2) to see if */
/*|the label is a valid Entry Point and the entry point name     */
/*|and language (for PL1 8 character ESD names are mangled).     */
/*|This action was initially added to MapModuleCsects but        */
/*|testing all LD's for a module regardless of their potential   */
/*|use caused a blow out in the minidump size as LECuData()      */
/*|dLocate's the information for analysis.                       */
/*|:p.                                                           */
/*|Input data is the IANCHOR for the CSECT plus the WhereAmI     */
/*|address that triggered the search.                            */
/*|                                                              */
/*****************************************************************/
/*|:xmp.*/
 
int mapCsectEntryPoint( IANCHOR *pIDC, int WAIaddr ) ;
 
/*|:exmp.*/
/*****************************************************************************/
/*|:h4.demandbind()                                              */
/*|:p.The demandbind() call is used by WhereAmI() internal processing        */
/*|in realtim mode to request dynamic binding of a load module in order to   */
/*|map its CSECT information.                                                */
/*|returns 1 to show success, 0 to show failure                              */
/*|:xmp.*/
 
int demandbind( IANCHOR *);
 
/*|:exmp.*/
/*****************************************************************************/
/*|:h4.bindexclude()                                                         */
/*|:p.The bindexclude() call is used to determine whether a bind should      */
/*|be performed on a module by checking its name against an exclusion list.  */
/*|returns 1 to exclude, 0 to indicate the module should/would be bound.     */
/*|:xmp.*/
 
int bindexclude( char *);
 
/*|:exmp.*/
/*****************************************************************************/
/*|:h4.XpoplSegScan()                                                        */
/*|:p.XpoplSegScan() will process the buffer segments added since prior call.*/
/*|returns 0 to show success, 8 to show failure                              */
/*|:xmp.*/
 
int XpoplSegScan( void);
 
/*|:exmp.*/
 
struct     XCSECT {
  char    *ModName;          /* Load module or HFS file name                 */
  char     AliasTrueName[9]; /* if module is an ALIAS, the True Name         */
  int      ModType;          /* Module Type (JPA/LPA load module or HFS file)*/
  char    *ModOrigin;        /* DSN or HFS path                              */
  char     ModBDate[7];      /* Date of Binding YYYYDDD                      */
  char     ModBTime[6];      /* Time of Binding HHMMSS                       */
  int      ModAddr;          /* Module Address                               */
  char    *CsectName;        /* CSECT name                                   */
  char    *CsectRName;       /* Resident name                                */
  char    *CsectLang;        /* CSECT (WDB) Language                         */
  int      CsectMOffset;     /* Module Offset                                */
  char    *CsectCName;       /* CSECT Compiler name                          */
  char     CsectCVersion[2]; /* Compiler Version                             */
  char     CsectCModLevel[2];/* Compiler Mod Level                           */
  char     CsectCDate[7];    /* Compile Date YYYYDDD                         */
  int      MemId;            /* LE Member Language Id                        */
  char    *CUName;           /* Compile Unit name                            */
  int      CUAddr;           /* Start of Compile Unit                        */
  char    *EPName;           /* Entry Point name                             */
  int      EPAddr;           /* Entry Point address                          */
  char     LECDate[8];       /* LE-enabled program compile date YYYYMMDD     */
  char     LECTime[6];       /* LE-enabled program compile time HHMMSS       */
  char    *ServLvl;          /* Service Level                                */
  char    *ProductNo;        /* Product number                               */
} ;
 
struct CMSG {
  int   Cnmsg;                      /* Offset to next record */
  char  msctime[11];                /* HH:MM:SS:hh  timestamp */
  char  msctext[MAX_MSGLEN];        /* Message Text  */
};
 
struct CDMSG {
  int   CDnmsg;                     /* Offset to next record */
  char  mscdtext[MAX_MSGLEN];       /* Message Text  */
};
 
/* Data returned by CICS XPI INQUIRE_APPLICATION_DATA call (DFHAPIQX macro) */
 struct CICS_APIQ {
  /*      APIQ Call structured parameter list          */
  /*      - Includes a standard 16 byte header         */
  struct {
    short int      _apiq_plistlen;  /* LENGTH OF PLIST                */
    short int      _filler1;        /* RESERVED FOR ID                */
    int            _apiq_format_no; /* UNIQUE FORMAT NUMBER           */
    int            _apiq_version_no;/* VERSION NUMBER OF PLIST        */
    struct {
      unsigned char  _apiq_res01;
      unsigned char  _apiq_res02;
      unsigned char  _apiq_res03;
      unsigned char  _apiq_res04;
    } apiq_reserved;     /* RESERVED           */
  } apiq_head;
  /*      EXISTENCE BITS                               */
  /*       The Existence Bits define which parameters  */
  /*       are included in the request and/or response */
  struct {
    unsigned char  _apiq_xb01;
    unsigned char  _apiq_xb02;
    unsigned char  _apiq_xb03;
    unsigned char  _apiq_xb04;
    unsigned char  _apiq_xb05;
    unsigned char  _apiq_xb06;
    unsigned char  _apiq_xb07;
    unsigned char  _apiq_xb08;
  } apiq_existence;
  /*      Actual KEYWORDS now follow                  */
  char           apiq_function;
  unsigned char  _filler2;
  char           apiq_response;
  char           apiq_reason;
  int            apiq_eib;
  int            apiq_syseib;
  int            apiq_tctua;
  int            apiq_tctuasize;
  int            apiq_twa;
  int            apiq_twasize;
  int            apiq_rsa;
  int            apiq_dsa;
};
 
#define apiq_plistlen   apiq_head._apiq_plistlen
#define apiq_format_no  apiq_head._apiq_format_no
#define apiq_version_no apiq_head._apiq_version_no
#define apiq_res01      apiq_head.apiq_reserved._apiq_res01
#define apiq_res02      apiq_head.apiq_reserved._apiq_res02
#define apiq_res03      apiq_head.apiq_reserved._apiq_res03
#define apiq_res04      apiq_head.apiq_reserved._apiq_res04
#define apiq_xb01       apiq_existence._apiq_xb01
#define apiq_xb02       apiq_existence._apiq_xb02
#define apiq_xb03       apiq_existence._apiq_xb03
#define apiq_xb04       apiq_existence._apiq_xb04
#define apiq_xb05       apiq_existence._apiq_xb05
#define apiq_xb06       apiq_existence._apiq_xb06
#define apiq_xb07       apiq_existence._apiq_xb07
#define apiq_xb08       apiq_existence._apiq_xb08
 
/* Values for field "apiq_function" */
#define APIQ_INQ_APPLICATION_DATA 001
 
/* Values for field "apiq_response" */
#define APIQ_OK          001
#define APIQ_EXCEPTION   002
#define APIQ_DISASTER    003
#define APIQ_INVALID     004
#define APIQ_KERNERROR   005
#define APIQ_PURGED      006
 
/* Values for field "apiq_reason"   */
#define APIQ_DPL_PROGRAM                001
#define APIQ_NO_TRANSACTION_ENVIRONMENT 002
#define APIQ_TRANSACTION_DOMAIN_ERROR   003
#define APIQ_INVALID_FUNCTION           004
#define APIQ_ABEND                      005
#define APIQ_LOOP                       006
#define APIQ_INQ_FAILED                 007
 
 
struct TACBKEY {    /* CICS TACB information, the first TACB passed form exits*/
  int  atacb;       /* address of TACB, gets passed from transaction exits    */
  int  asytca;      /* address of system TCA, gets populated in the scripts   */
  int  atca;        /* address of user TCA, this gets passed from trans. exits*/
};
 
#pragma linkage(ISPLINK,OS)
extern ISPLINK(char *, ...);
#pragma linkage(ISPEXEC,OS)
extern ISPEXEC(int, char *);
 
