/* API header Dump Management ****************************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
/*|:h3.IDIDH.H                                                       */
#include "stdio.h"
 
/*********************************************************************/
/* Structures to map SYSMDUMP records.                               */
/*********************************************************************/
 
struct DREC ;
typedef struct DREC DREC ;
/* This following simple mapping is for 'CV' records only, mainly SYSMDUMP */
struct DREC {       /* data from BLSRDRPX MACRO in SPA */
  char  idc[2] ;    /* dump record prefix c'DR' */
  char  idv ;       /* version 1=31 2=64 bit support */
  char  len ;       /* length of the prefix=64 0x40 */
  /* now follows the 16 byte address space idenitfier BLSRDATS MACRO in SPA */
  char  type[2] ;   /* type 'H ' is header, 'CV' is CPU Virtual storage */
  char  res1[2] ;   /* reserved */
  int   cpua ;      /* CPU address or -1 */
  union u_tag {
      int   asid ;      /* asid for 'CV' record */
      char  asidc[4] ;
  } u;
  char  res2[4] ;   /* reserved */
  /* more common data */
  union u_tag3 {
    struct {            /* DR1 (31 bit support) type */
      void *lad ;       /* logical address           */
      int   seq ;       /* sequence number of dump   */
      char  res3[8] ;   /* reserved for common data  */
    } s3;
    struct {            /* DR2 (64 bit support) type */
      char  res8[4] ;   /* upper 4 bytes of lad      */
      void *lad2 ;      /* logical address           */
      int   seq2 ;      /* sequence number of dump   */
      char  res9[4] ;   /* reserved for common data  */
    } s4;
  } u3;
 
  /* now follows the 28 byte record specific data */
  union u_tag2 {
    struct {
      char  key ;       /* storage key data for page */
      char  res4[5] ;   /* reserved */
      /* the last 20 byte common end for 'A ' 'CV' 'DS' records */
      char  styp ;      /* system area type */
      char  res5 ;      /* reserved */
                        /* The next 20 bytes are for DR1 type      */
                        /* records. If needed for DR2 type records */
                        /* remapping is required where aap is the  */
                        /* first 8 bytes.                          */
      void *aap ;       /* absolute (real) address */
      char  res6[16] ;  /* reserved */
    } s1;
    struct {
      /* We will use these 28 bytes for our own purpose            */
      int   cmpType ;   /* Type 1 records added to SYSMDUMP from   */
                        /* the HIST file for the EXPORT option     */
      int   cmpOffs ;   /* Offset                                  */
      int   FirstSeg :1, /* First segment flag                     */
            LastSeg  :1, /* Last segment flag                      */
            SpareFlg :30;
      char  res7[16] ;  /* Spare                                   */
    } s2;
  } u2;
  char  data[4096]; /* finally the dump data */
} ;
 
struct DRECH ;
typedef struct DRECH DRECH ;
struct DRECH {   /* Header type dump record data */
  /***********************************************************************/
  /* IHAPRD MACRO in SPA  definition of Dump Header record.              */
  /* (ADYPRD MACRO provides dump header DAE mapping, no currently used.) */
  /***********************************************************************/
  char  prdmodnm[8];  /* cl8   name of pgm requesting dump       */
  char  prdtodvl[8];  /* cl8   clock value at time of dump       */
  char  prdcpu[8];    /* cl8   processor identification          */
  char  prdtitle[100];/* cl100 title from dump                   */
  char  prddspb[8];   /* cl8   time system set non-dispatchable  */
  char  prddspe[8];   /* cl8   time system reset dispatchable    */
  char  prdsname[8];  /* cl8   system name                       */
  char  resv1[12];    /* cl12  reserved - aligns prdsdrsn        */
  char  prdsdrsn[16]; /* cl16  svc dump reason code (only for svc*/
  int   prdsdblk ;    /* f     number of blocks in a captured    */
  char  resv2[112];   /* cl112 reserved                          */
  int   prdsdfwd ;    /* f     pointer used for header chain     */
  short prdsdmpo ;    /* h     offset of sdump/sysmdump common   */
  short prdsdmpl ;    /* h     length of common section          */
  short prdslipo ;    /* h     offset of slip section            */
  short prdslipl ;    /* h     length of slip section            */
  short prdsysmo ;    /* h     offset of sysmdump section        */
  short prdsysml ;    /* h     length of sysmdump section        */
  short prdsdwao ;    /* h     offset of sdwa for this dump      */
  short prdsdwal ;    /* h     length of sdwa                    */
  char  prdcid[50];   /* cl50  caller's id                       */
  short prdintko ;    /* h     offset of incident token          */
} ;
 
struct PRDSDSM ;
typedef struct PRDSDSM PRDSDSM ;
struct PRDSDSM {
  /***********************************************************************/
  /* IHAPRD MACRO  SPA definition of Dump Header record, PRDSDSM section.*/
  /* SDUMP/SYSMDUMP COMMON SECTION - THIS SECTION WILL BE PRESENT        */
  /* FOR ALL SVC DUMPS, SYSMDUMPS AND SLIP DUMPS.  PRDSDMPO IS           */
  /* THE OFFSET TO THIS SECTION OF THE HEADER RECORD.                    */
  /***********************************************************************/
  void *prdcvt      ; /* cl4   virtual address of cvt            */
  short res1        ; /* cl2   reserved                          */
  char  prderrid[10]; /* cl10  errorid associated with dump      */
  char  prddsnam[44]; /* cl44  dsn to which dump was taken       */
  void *prdcml      ; /* cl4   ascb address of cml asid          */
  char  prdxmpsw[8] ; /* cl8   psw when sdump was involked       */
  short prdpasid    ; /* h     primary asid                      */
  short prdsasid    ; /* h     secondary asid                    */
  short prdhasid    ; /* h     home asid                         */
  short prdwasid    ; /* h     sdwa owners asid                  */
  void *prdsaddr    ; /* f     address where sdwa existed        */
  void *prdttch     ; /* f     pointer to trace table control hdr*/
  short prdsdpo     ; /* h     offset of svc dump parm list      */
  short prdsdpl     ; /* h     length of svc dump parm list      */
  short prdsdopo    ; /* h     offset of sdump options list      */
  short prdsdopl    ; /* h     length of sdump options list      */
  void *prdtcb      ; /* f     pointer to tcb of task which      */
  char  prddidco[3] ; /* cl3   dump id used for messages and to  */
  char  res2[1]     ; /* cl1   reserved                          */
  char  res3[32]    ; /* cl32  unused                            */
  int   prdgpr[16]  ; /* cl64  gpr's upon entering sdump         */
  int   prdcr[16]   ; /* cl64  cntl regs upon entering sdump     */
  char  prdpsw[8]   ; /* cl8   callers psw before sdump          */
  int   prdar[16]   ; /* cl64  access regs upon entering sdump   */
  char  prdfpr[128] ; /* cl128 fpr's upon entering sdump         */
  char  prdfpcr[4]  ; /* cl4   fpcr                              */
  char  Resv[4]     ; /* cl4   Reserved                          */
  char  prdg64h[64] ; /* cl64  G64H UPON ENTERING SDUMP          */
  char  prdc64s[128]; /* cl128 ESAME CRs at SDUMP entry          */
  int   prdcsa      ; /* cl4   Start of common storage           */
  int   prdepvt     ; /* cl4   End of common storage             */
  char  prdhjobn[8] ; /* cl8   PRDHASID JOBNAME                  */
} ;
 
struct PRDSYSMD ;
typedef struct PRDSYSMD PRDSYSMD ;
struct PRDSYSMD {
  /**********************************************************************/
  /* IHAPRD MACRO SPA definition, Dump Header record, PRDSYSMD section. */
  /* THE FOLLOWING SECTION WILL BE PRESENT ONLY FOR SYSMDUMPS.          */
  /* PRDSYSMO IS THE OFFSET TO THIS SECTION OF THE HEADER RECORD.       */
  /**********************************************************************/
  int   prdsmabd    ; /* cl4   abend code for the error          */
  int   prdsmpsw[2] ; /* cl8   psw at entry to abend             */
  char  prdsmlmn[8] ; /* cl8   name of active load module at     */
  void *prdsmlma    ; /* f     @ of active load module           */
  int   prdsmlmo    ; /* f     offset into active load module    */
  unsigned
  short prdsmpda[6] ; /* cl12  data at psw @ (6+ 6-)             */
  int   prdsmgpr[16]; /* cl64  gpr's at time of error            */
  char  prdsmrsn[4] ; /* cl4   reason code for the error         */
  int   prdsmar[16] ; /* cl64  ar's at time of error             */
  int   prdsmcr[16] ; /* cl64  control regs at time of error     */
} ;
 
/*********************************************************************/
/*   API Structure forward declarations                              */
/*********************************************************************/
struct LMOD ;
typedef struct LMOD LMOD ;
 
/******************************************************************************/
/*   API Function and Structure Definitions                                   */
/******************************************************************************/
/*|:h4.dOpenBLSCECT()                                                */
/*|:p.The dOpenBLSCECT() function opens an IPCS parmlib member               */
/*|:xmp.*/
int dOpenBLSCECT(char *member);
/*|:exmp.*/
/*|:h4.dOpenDSN()                                                */
/*|:p.dOpenDSN() opens the opts.dumpdsn Data Set Name and           */
/*|performs the inital dump basic information population of Key Data and     */
/*|Dump dictionary.                                                          */
/*|:xmp.*/
int dOpenDSN( void) ;
/*|:exmp.*/
/*|:h4.dLmodLocate()                                             */
/*|:p.dLmodLocate() loads an IPCS Load Module into storage from     */
/*|SYS1.MIGLIB, returning a structure that contains the name and a pointer   */
/*|to the loaded module, zero if if it was not found.  (CEELOAD is used)     */
/*|:xmp.*/
LMOD *dLmodLocate(char *name) ;
/*|:exmp.*/
/* structure to track load addresses of Model's, Exits, etc. loaded from SYS1.MIGLIB */
struct LMOD {         /* all char strings are null terminated */
  char name[9] ;      /* load module name we may need to increase this for PDS/E ???? Rod*/
  void *address ;     /* lmod loaded address, zero if not found. */
} ;
 
enum  boolean {FALSE,TRUE};
 
/*****************************************************************************/
/*|:h4.dLocate()                                             */
/*|:p.The dLocate() call checks if the passed dump address for length is     */
/*|mapped into storage, and if so returns its malloc'ed address,             */
/*|otherwise returns null if the start address is not in storage.  It        */
/*|returns -ve if start is in storage but the length of the data the         */
/*|caller requests exceedes the length mapped into storage.  In this         */
/*|case the -ve value returned is the length that could be successfuly       */
/*|obtained from the same start.  Storage is assumed to be for the           */
/*|AbendASID or master ASID.                                                 */
/*|:xmp.*/
/*|int   dLocate(int address, int length) ;
/*|:exmp.*/
#define  dLocate(address, length) \
        dxLocate(address, length, __FILE__, __LINE__)
int     dxLocate(int address, int length, char *file, int line) ;
 
/*****************************************************************************/
/*|:h4.dLocateASID()                                             */
/*|:p.dLocateASID() checks if the passed dump address for length is */
/*|mapped into storage, and if so returns its malloc'ed address,             */
/*|otherwise returns null if the start address is not in storage.  It        */
/*|returns -ve if start is in storage but the length of the data the         */
/*|caller requests exceedes the length mapped into storage.  In this         */
/*|case the -ve value returned is the length that could be successfuly       */
/*|obtained from the same start.  Storage must be for the specified ASID.    */
/*|:note.Never do an IDadd using the value returned from this                */
/*|function as it will corrupt the dictionary.                               */
/*|:xmp.*/
int   dLocateASID(int address, int length, int asid, char *file, int line) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.dLocateInfo()                                                         */
/*|:p.dLocateInfo returns the address and length of the dump                 */
/*|segment containing the given address or the closest one with a higher     */
/*|starting address that the address given.  All addresses are logical.      */
/*|:xmp.*/
 
#define dLocateInfo( address, ReturnAddr, ReturnLen) \
        dxLocateInfo(address, ReturnAddr, ReturnLen, __FILE__,__LINE__)
void dxLocateInfo(int address, int *ReturnAddr, int *ReturnLen, char *file, int line);
 
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.dLocatePriorInfo()                                                    */
/*|:p.dLocatePriorInfo returns the address and length of the dump            */
/*|segment containing the given address or the closest one with a LOWER      */
/*|starting address that the address given.  All addresses are logical.      */
/*|:xmp.*/
 
#define dLocatePriorInfo( address, ReturnAddr, ReturnLen) \
        dxLocatePriorInfo(address, ReturnAddr, ReturnLen, __FILE__,__LINE__)
void dxLocatePriorInfo(int address, int *ReturnAddr, int *ReturnLen, char *file, int line);
 
/*|:exmp.*/
 
/************************************************************************/
/*|:h4.testIA()                                                        */
/*|:p.testIA() checks the array of 4k pages saved in realtime to see if   */
/*|they were Invalid Addresses during realtime analysis.  MiniDump     */
/*|processing needs this during re-analysis to prevent unnecessarily   */
/*|opening and reading the SYSMDUMP only to find the address is        */
/*|not in the SYSMDUMP.                                                */
/*|Returns 1 if invalid address.                                       */
/*|Returns 0 if a valid address.                                       */
/*|The second arguement pointer to pointer to int may be null in which */
/*|case it is not used.  If it is supplied, point it to a null. If the */
/*|Invalid Address Array from the minidump is the old style(incomplete)*/
/*|the null will not be changed.  If realtime or a new minidump the    */
/*|invalid address array is the inverse of the real-time DUMPS         */
/*|addressability and the null will be updated to point to two int's.  */
/*|If returning 1 (invalid) the first int is the start address of the  */
/*|invalid range and the second word is the last byte address of the   */
/*|invalid range.                                                      */
/*|If returning 0 (valid) the first int is the start address-1 of the  */
/*|valid range and the second word is the last byte+1 address of the   */
/*|valid range. (i.e. they are the pointers to the invalid either end) */
/************************************************************************/
/*|:exmp.*/
#define testIA( address,pInvalid)  \
        testxIA(address,pInvalid, __FILE__, __LINE__ )
int testxIA( int address, int **pInvalid, char *file, int line ) ;
 
/*|:exmp.*/
/*****************************************************************************/
struct CBMHDR;
typedef struct CBMHDR CBMHDR;
 
/*|:h4.dSymInit()                                             */
/*|:p.dSymInit() initializes the Dump Dictionary and Key Data with  */
/*|information from IPCS symbols.  It must be called after open of the dump  */
/*|data set and after reading of the IPCS parmlib members.                   */
/*|:xmp.*/
void dSymInit(void);
/*|:exmp.*/
 
/*|:h4.dTerm()                                             */
/*|:p.dTerm() does termination processing for      */
/*|Dump Component.                                              */
/*|:xmp.*/
void dTerm(void);
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.RegisterDumpSeg()                                   */
/*|:p.RegisterDumpSeg() records (registers) a segment of dump data to be       */
/*|added to the dump array structures of the matching ASID.  The areas       */
/*|are normally 4k pages.  They may already be in storage as in the          */
/*|case of real-time, or they may be the relative record numbers of 4k       */
/*|Pages from the SYSMDUMP data set.                                         */
/*|The first parm *data is used in 3 ways:                                   */
/*|:ul.                                                                      */
/*|:li.*data = 0 means the addr and length point to in storage data          */
/*|mapped at it's correct logical address. This is used for                  */
/*|real-time. All DUMPS entries will be this style for real-time.            */
/*|:li.*data = positive number means *data is the actual address from        */
/*|which the data should be copied.  (normally pointing to segment           */
/*|buffer from a minidump read)                                              */
/*|:li.*data = negative number means turn off the high order bit to          */
/*|obtain the relative record number on the SYSMDUMP data set where          */
/*|the data can be read.                                                     */
/*|:eul.                                                                     */
/*|:xmp.*/
void RegisterDumpSeg( int data, int addr, int length, char key, int asid,char *file, int line) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.CountMiniDump()                                   */
/*|:p.CountMiniDump() is called at the end of realtime processing  */
/*|at the end of the report to count the current referenced minidump pages.  */
/*|:xmp.*/
int CountMiniDump( void) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.WriteMiniDump()                                   */
/*|:p.WriteMiniDump() is called at the end of realtime processing  */
/*|after the report has been written to the history file.  It is passed the  */
/*|maximum pages to be written to the history file as a MiniDump and if the  */
/*|referenced pages are less than that it returns the number written else 0. */
/*|:xmp.*/
int WriteMiniDump( char *pDDf, int maxpages) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.DumpsRead()                                       */
/*|:p.DumpsRead() is called at the end processing to determine     */
/*|which dumps were successfully opened.                                     */
/*|:xmp.*/
/*|Note this function should be called before dTerm().                       */
/*|returns 0 = no successful dump read                                       */
/*|        1 = minidump read                                                 */
/*|        2 = SYSMDUMP records read                                         */
/*|        3 = minidump and SYSMDUMP records read                            */
/*|                                                                          */
int DumpsRead( void) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.mapASIDs()                                                            */
/*|:p.mapASIDs diagnostic dump function.                                     */
/*|:xmp.*/
void mapASIDs(int level,char *file, int line);
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.DelayedFree()                                   */
/*|:p.DelayedFree() is called by the dispatcher to free redundent storage  */
/*|stacked up by populate() during the processing of a script dispatch.     */
/*|:xmp.*/
void DelayedFree(void) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.dInitRealTimeASID()                                                   */
/*|:p.dInitRealTimeASID() sets the AbendASID.                                */
/*|:xmp.*/
int dInitRealTimeASID(void) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.dInitRealTimeAreas()                                                  */
/*|:p.dInitRealTime() calls MapAreas()                                       */
/*|:xmp.*/
int dInitRealTimeAreas(void) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.setRealTimeTCBvalid()                                                 */
/*|:p.setRealTimeTCBvalid does a setIAvalid for the PSATOLD tcb assress.     */
/*|The VSMLIST unallocated data was gathered befor the IDIDA TCB was         */
/*|attached so the address range may have been invalid at that time.         */
/*|:xmp.*/
void setRealTimeTCBvalid( void);
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.drestoreIA()                                                          */
/*|:p.drestoreIA() places the Invalid Address array segments saved           */
/*|from realtime in a minidump back into the pAR->aIA array for use          */
/*|during minidump re-analysis.  Called from IDIXPOPL xPopDCAT().            */
/*|:xmp.*/
void drestoreIA( int ASID, int *IAdata, int ialen) ;
/*|:exmp.*/
 
/******************************************************************************/
/*|:h4.splitCommonRange()                                                     */
/*|:p.                                                                        */
/*|Passed the address if the beginning of common below the line and the       */
/*|end of common above the line, this roution goes through the exitsing       */
/*|ASIDA chain splitting the AR ranges on the low high boundraries and then   */
/*|assigns the range mapping low-high in each ASIDA to ASID 1 master common.  */
/******************************************************************************/
/*|:xmp.*/
void splitCommonRange(int low, int high) ;
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.MapAreas()                                                            */
/*|:p.MapAreas() does an IDadd for each common system area.  If              */
/*|called from dInitRealTime then it also does a RegisterDumpSeg for each    */
/*|LPA and Nucleus area.                                                     */
/*|:xmp.*/
void MapAreas(void);
/*|:exmp.*/
 
/*****************************************************************************/
/*|:h4.ZapLowCore()                                                          */
/*|:p.ZapLowCore() updates a copy of low core to be saved in the             */
/*|minidump.  The intended use of this is only to set PSAAOLD for multi      */
/*|region dumps - otherwise the PSA  points to ASID 0001.                    */
/*|input offset should be on a word boundry.                                 */
/*|:xmp.*/
void ZapLowCore(int offset, int word, char *file, int line);
/*|:exmp.*/
 
/*********************************************************************/
/*|:h4.IsDDSNopen()                                                  */
/*|:p.IsDDSNopen()                                                   */
/*|is called by the P component to determine if a dump               */
/*|data set for the current fault has been opened.                   */
/*|Returns 1 if yes; otherwise 0.                                    */
/*********************************************************************/
/*|:xmp.*/
int IsDDSNopen(void);
/*|:exmp.*/
 
/*********************************************************************/
/*   initialize Dump Management                                      */
/*********************************************************************/
void dInit(void) ; /* initialize Dump Management function */
 
struct SCANFOR ;
typedef struct SCANFOR SCANFOR ;
/*********************************************************************/
/*|:h4.scanfor() and iscanfor()                                      */
/*|The scanfor function scans the dump storage for a given range for */
/*|the data passed.  If found, the address is returned, otherwise    */
/*|null is returned.  (Therefore don't expect to scan for something  */
/*|at address zero.)  The call uses a SCANFOR structure initially    */
/*|set up by the caller containing input data, length, scan range,   */
/*|and alignment.  The structure is updated by each call to locate   */
/*|the next incidence of the data.  The user must initialize all     */
/*|fields for the first call, or use the iscanfor() function on the  */
/*|initial call for a search to initialize the structure.            */
/*|:xmp.*/
 
int scanfor(SCANFOR *pscanfor) ;
 
int iscanfor(SCANFOR *pscanfor, int pdata, int length, int start, int end, int align);
 
/*********************************************************************/
/*|:h4.scanforPREV() and iscanforPREV() scan the reverse direction.  */
 
int scanforPREV(SCANFOR *pscanfor) ;
 
int iscanforPREV(SCANFOR *pscanfor, int pdata, int length, int start, int end, int align);
 
                     /* note: the code uses int for pointers as they require less casting than void * */
struct     SCANFOR { /* structure for scanfor() */
  int      pdata ;   /* pointer to data to scan for */
  int      length;   /* length of data to scan for */
  int      start ;   /* start address to scan from (set to found+1 on each successful call) */
  int      end ;     /* end address of scan range */
  int      align ;   /* alignment of data. 0=none 1=halfword 2=fullword 3=double */
  void    *work;     /* work field(used by API), should be set to zero for a new start range */
} ;
 
 
/*********************************************************************/
/*|:h4.getPage() retrieves a page for the specified logical address. */
/*|:p.Retrieves a page for the specified logical address. The logical*/
/*|address should be the beginning of 4K page boundary. If not, this */
/*|function reads the page containing the specified address. This    */
/*|function reads a page (either from malloc'd storage or disk), and */
/*|copies the page into the specified buffer without keeping the page*/
/*|in the malloc'd storage (unlike dLocate). It is the caller's      */
/*|responsibility to allocate enough space to copy the page and free */
/*|the storage when finished. Returns 1 if successfull, else 0.      */
int getPage(int laddr, void* buffer);
 
/*|:h4.isDeferredReport()                                            */
/*|:p.Tests if the DeferredReport option is active for this analysis.*/
/*|:p.                                                               */
/*|int isDeferredReport(void);                                       */
#define isDeferredReport()  \
     isDeferredReport(__FILE__,__LINE__)
int (isDeferredReport)(char *file, int line);
 
