/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary.actions;

import com.ibm.etools.fa.jobs.RetrieveViewInformationJob;
import com.ibm.etools.fa.pages.RetrieveViewPage;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.summary.RootElement;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.ViewsContainerElement;
import com.ibm.etools.fa.view.summary.actions.HistoryFileViewAction;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RetrieveViewInformationAction
extends HistoryFileViewAction {
    public static final String VIEW_INFO_CACHE_FILE_EXTENSION = ".viewCachInfo";

    public void run(IAction action) {
        try {
            RootElement selectedRoot = (RootElement)this.selectedElement;
            FASubSystem[] faSubSystems = RSESystemManagement.getAllFASubSystems();
            if (faSubSystems == null || faSubSystems.length == 0) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("HistoryFilesView.NoSubSysTitle"), (String)NLS.getString("HistoryFilesView.NoSubSysMsg"));
                return;
            }
            String[] systemNames = new String[faSubSystems.length];
            int i = 0;
            while (i < faSubSystems.length) {
                systemNames[i] = faSubSystems[i].getSystemConnection().getAliasName();
                ++i;
            }
            RetrieveViewPage page = new RetrieveViewPage(Display.getCurrent().getActiveShell(), systemNames);
            if (page.open() != 0) {
                return;
            }
            String selectedSystemName = page.getSelectedSystemName();
            String viewDsn = page.getViewDsn();
            System.out.println("Selected system name = " + selectedSystemName + " view DSN = " + viewDsn);
            SystemElement systemElement = new SystemElement(selectedSystemName);
            systemElement = (SystemElement)selectedRoot.addIfNew(systemElement);
            ViewsContainerElement viewsContainerElement = new ViewsContainerElement();
            viewsContainerElement = (ViewsContainerElement)systemElement.addIfNew(viewsContainerElement);
            String projPath = String.valueOf(selectedSystemName) + File.separator;
            String fileName = String.valueOf(projPath) + viewDsn + VIEW_INFO_CACHE_FILE_EXTENSION;
            IFile file = FAPlugin.getDefault().getFile(fileName);
            RetrieveViewInformationJob job = new RetrieveViewInformationJob(selectedSystemName, systemElement, viewsContainerElement, viewDsn, String.valueOf(file.getParent().getLocation().toString()) + File.separator, file.getName());
            job.runJob();
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("RetrieveViewInformationAction.ErrMsg"), e, true);
            return;
        }
    }
}

