/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.details.actions;

import com.ibm.etools.fa.common.HistoryIndexFileEntry;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.actions.DetailedViewAction;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteCachedDataForDetailedView
extends DetailedViewAction {
    public void run(IAction arg0) {
        try {
            HistoryIndexFileEntry entry = (HistoryIndexFileEntry)this.currentSelection.get(this.currentSelection.size() - 1);
            String faultID = entry.DDirHdCFaultID();
            String projPath = String.valueOf(this.detailedView.getSystemAliasName()) + File.separator + entry.getHistoryFileName() + File.separator + faultID + File.separator;
            String miniDumpFileName = String.valueOf(projPath) + faultID + ".md";
            String rptFileName = String.valueOf(projPath) + faultID + ".far";
            IFile miniDumpFile = FAPlugin.getDefault().getFile(miniDumpFileName);
            IFile reportFile = FAPlugin.getDefault().getFile(rptFileName);
            if (miniDumpFile.exists()) {
                EditorManagement.closeEditor(miniDumpFile);
                miniDumpFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (reportFile.exists()) {
                EditorManagement.closeEditor(reportFile);
                reportFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("DeleteCachedDataForDetailedView.OkTitle"), (String)(String.valueOf(NLS.getString("DeleteCachedDataForDetailedView.OkMsg")) + " " + faultID));
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("DeleteCachedDataForDetailedView.ErrMsg"), e, true);
        }
    }
}

