/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pages;

import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.NLS;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RetrieveViewPage
extends TitleAreaDialog {
    private final String VIEW_DSN_COMBO = "com.ibm.etools.fa.pages.RetrieveViewPage.viewDsnCombo";
    private Combo rseConnectionCombo;
    private Combo viewDsnCombo;
    private String[] systemNames;
    private String selectedSystemName;
    private String viewDsn;
    private boolean cancelButtonPressed = false;

    public RetrieveViewPage(Shell parentShell, String[] systemNames) {
        super(parentShell);
        this.systemNames = systemNames;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.getString("RetrieveViewPage.Title"));
        this.setMessage(NLS.getString("RetrieveViewPage.Msg"));
        Composite composite = GUIUtility.createComposite(parent, 2);
        GUIUtility.createLabel(composite, NLS.getString("AddNewHistoryFilePage.curRSECon"), 1);
        this.rseConnectionCombo = GUIUtility.createCombo(composite);
        this.rseConnectionCombo.setItems(this.systemNames);
        this.rseConnectionCombo.select(0);
        GUIUtility.createLabel(composite, NLS.getString("RetrieveViewPage.viewDsn"), 1);
        this.viewDsnCombo = GUIUtility.createEditableCombo(composite);
        String[] prevValues = FAPlugin.getDefault().getDialogValues("com.ibm.etools.fa.pages.RetrieveViewPage.viewDsnCombo");
        this.viewDsnCombo.setItems(prevValues);
        this.viewDsnCombo.select(0);
        this.viewDsnCombo.setFocus();
        return super.createDialogArea(parent);
    }

    protected void okPressed() {
        this.selectedSystemName = this.rseConnectionCombo.getText();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cancelButtonPressed = true;
        super.cancelPressed();
    }

    private boolean validateViewDsn() {
        String value = this.viewDsnCombo.getText().trim();
        if (value.length() > 0) {
            this.viewDsn = value.toUpperCase();
            this.setMessage(NLS.getString("RetrieveViewPage.Msg"));
            return true;
        }
        this.setMessage(NLS.getString("RetrieveViewPage.InvalidViewDsn"), 3);
        return false;
    }

    public boolean close() {
        if (this.cancelButtonPressed) {
            return super.close();
        }
        if (!this.validateViewDsn()) {
            return false;
        }
        FAPlugin.getDefault().addNewDialogValueIfNew("com.ibm.etools.fa.pages.RetrieveViewPage.viewDsnCombo", this.viewDsn);
        return super.close();
    }

    public String getSelectedSystemName() {
        return this.selectedSystemName;
    }

    public String getViewDsn() {
        return this.viewDsn;
    }
}

