/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.jobs;

import com.ibm.etools.fa.common.FAViewInformation;
import com.ibm.etools.fa.jobs.FAJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.HistoryFilesView;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.ViewElement;
import com.ibm.etools.fa.view.summary.ViewsContainerElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class RetrieveViewInformationJob
extends FAJob {
    private String systemName = null;
    private SystemElement systemElement = null;
    private ViewsContainerElement viewsContainerElement = null;
    private String viewDsn;
    private String localPath;
    private String localFileName;

    public RetrieveViewInformationJob(String systemName, SystemElement systemElement, ViewsContainerElement viewsContainerElement, String viewDsn, String localPath, String localFileName) {
        this.systemName = systemName;
        this.viewsContainerElement = viewsContainerElement;
        this.systemElement = systemElement;
        this.localPath = localPath;
        this.localFileName = localFileName;
        this.viewDsn = viewDsn;
    }

    public void runJob() throws CoreException {
        Job downloadFaultEntryJob = new Job(NLS.getString("RetrieveViewInformationJob.name")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("", 2);
                    File outputFile = new File(String.valueOf(RetrieveViewInformationJob.this.localPath) + RetrieveViewInformationJob.this.localFileName);
                    if (outputFile.exists()) {
                        RetrieveViewInformationJob.this.jobStatus = Status.OK_STATUS;
                        RetrieveViewInformationJob.this.jobSuccessful = true;
                        return Status.OK_STATUS;
                    }
                    FASubSystem faSubSystem = RSESystemManagement.getFASubSystem(RetrieveViewInformationJob.this.systemName);
                    if (faSubSystem == null) {
                        RetrieveViewInformationJob.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + RetrieveViewInformationJob.this.systemName);
                        RetrieveViewInformationJob.this.jobStatus = Status.OK_STATUS;
                        RetrieveViewInformationJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        RetrieveViewInformationJob.this.jobStatus = Status.CANCEL_STATUS;
                        RetrieveViewInformationJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    if (!faSubSystem.readViewInformation(RetrieveViewInformationJob.this.viewDsn, RetrieveViewInformationJob.this.localPath, RetrieveViewInformationJob.this.localFileName)) {
                        RetrieveViewInformationJob.this.openErrorThreadSafe(NLS.getString("RetrieveViewInformationJob.ErrTitle"), NLS.getString("RetrieveViewInformationJob.ErrMsg"));
                        RetrieveViewInformationJob.this.jobStatus = Status.OK_STATUS;
                        RetrieveViewInformationJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        RetrieveViewInformationJob.this.jobStatus = Status.CANCEL_STATUS;
                        RetrieveViewInformationJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    RetrieveViewInformationJob.this.jobStatus = Status.OK_STATUS;
                    RetrieveViewInformationJob.this.jobSuccessful = true;
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    RetrieveViewInformationJob.this.openErrorThreadSafe(NLS.getString("RetrieveViewInformationJob.ErrTitle"), NLS.getString("RetrieveViewInformationJob.ErrMsg"));
                    FAPlugin.getDefault().log(4, NLS.getString("RetrieveViewInformationJob.ErrMsg"), e, false);
                    RetrieveViewInformationJob.this.jobStatus = Status.OK_STATUS;
                    RetrieveViewInformationJob.this.jobSuccessful = false;
                    return Status.OK_STATUS;
                }
            }
        };
        downloadFaultEntryJob.setPriority(30);
        downloadFaultEntryJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        downloadFaultEntryJob.addJobChangeListener(new IJobChangeListener(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        File viewInfoFile;
                        if ((this).RetrieveViewInformationJob.this.jobSuccessful && (viewInfoFile = new File(String.valueOf(RetrieveViewInformationJob.this.localPath) + File.separator + RetrieveViewInformationJob.this.localFileName)).exists()) {
                            ObjectInputStream input = null;
                            try {
                                try {
                                    input = new ObjectInputStream(new FileInputStream(viewInfoFile));
                                    ArrayList viewInfoList = (ArrayList)input.readObject();
                                    int i = 0;
                                    while (i < viewInfoList.size()) {
                                        FAViewInformation viewInfo = (FAViewInformation)viewInfoList.get(i);
                                        System.out.println(viewInfo.toString());
                                        RetrieveViewInformationJob.this.updateView(viewInfo, RetrieveViewInformationJob.this.systemName, RetrieveViewInformationJob.this.viewsContainerElement);
                                        ++i;
                                    }
                                }
                                catch (Exception e) {
                                    FAPlugin.getDefault().log(4, NLS.getString("RetrieveViewInformationJob.ErrMsg"), e, true);
                                }
                            }
                            catch (Throwable throwable) {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                throw throwable;
                            }
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                });
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        downloadFaultEntryJob.schedule();
    }

    private void updateView(FAViewInformation viewInfo, String systemName, ViewsContainerElement viewsContainerElement) throws Exception {
        ViewElement viewEle = new ViewElement(viewInfo);
        viewEle = (ViewElement)viewsContainerElement.addIfNew(viewEle);
        ArrayList histFiles = viewInfo.getHistoryFiles();
        int i = 0;
        while (i < histFiles.size()) {
            IFile localCacheFile = FAPlugin.getDefault().getFile(String.valueOf(systemName) + File.separator + ((String)histFiles.get(i)).toUpperCase().trim() + File.separator + "$$INDEX");
            FAHistoryFileViewData histFileViewData = new FAHistoryFileViewData(systemName, (String)histFiles.get(i), localCacheFile.getLocation().toString());
            HistoryFileElement histFileEle = new HistoryFileElement((String)histFiles.get(i), histFileViewData);
            histFileEle = (HistoryFileElement)viewEle.addIfNew(histFileEle);
            if (localCacheFile.exists()) {
                this.updateViews(histFileViewData, histFileEle);
            }
            ++i;
        }
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
        faView.expand(this.systemElement.getParent(), 3);
        faView.refresh();
    }

    private void updateViews(FAHistoryFileViewData data, HistoryFileElement histFileElement) throws Exception {
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
        faView.refresh();
    }
}

