/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.jobs;

import com.ibm.etools.fa.jobs.FAJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.details.DetailedHistoryFileView;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class RetrieveHistoryFileInformationJob
extends FAJob {
    private FAHistoryFileViewData histFileViewData = null;

    public RetrieveHistoryFileInformationJob(FAHistoryFileViewData histFileViewData) {
        this.histFileViewData = histFileViewData;
    }

    public void runJob() throws CoreException {
        System.out.println("RetrieveHistoryFileInformationJob running.....");
        Job readHistFileJob = new Job(String.valueOf(NLS.getString("AddNewHistoryFileAction.JobName")) + " " + this.histFileViewData.getHistFileName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(String.valueOf(NLS.getString("AddNewHistoryFileAction.JobName")) + " " + RetrieveHistoryFileInformationJob.this.histFileViewData.getHistFileName(), 2);
                    FASubSystem faSubSystem = RSESystemManagement.getFASubSystem(RetrieveHistoryFileInformationJob.this.histFileViewData.getSystemAliasName());
                    if (faSubSystem == null) {
                        RetrieveHistoryFileInformationJob.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + RetrieveHistoryFileInformationJob.this.histFileViewData.getSystemAliasName());
                        RetrieveHistoryFileInformationJob.this.jobSuccessful = false;
                        RetrieveHistoryFileInformationJob.this.jobStatus = Status.OK_STATUS;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        RetrieveHistoryFileInformationJob.this.jobSuccessful = false;
                        RetrieveHistoryFileInformationJob.this.jobStatus = Status.CANCEL_STATUS;
                        return Status.CANCEL_STATUS;
                    }
                    IProject configProj = FAPlugin.getDefault().getConfigProject();
                    IFile localCacheFile = FAPlugin.getDefault().getFile(String.valueOf(RetrieveHistoryFileInformationJob.this.histFileViewData.getSystemAliasName()) + File.separator + RetrieveHistoryFileInformationJob.this.histFileViewData.getHistFileName() + File.separator + "$$INDEX");
                    if (!faSubSystem.readHistoryFile(RetrieveHistoryFileInformationJob.this.histFileViewData.getHistFileName(), String.valueOf(configProj.getLocation().toString()) + File.separator + RetrieveHistoryFileInformationJob.this.histFileViewData.getSystemAliasName() + File.separator + RetrieveHistoryFileInformationJob.this.histFileViewData.getHistFileName() + File.separator, "$$INDEX")) {
                        RetrieveHistoryFileInformationJob.this.openErrorThreadSafe(NLS.getString("AddNewHistoryFileAction.AddHistFileErrTitle"), String.valueOf(NLS.getString("AddNewHistoryFileAction.AddHistFileErrMsg")) + " " + RetrieveHistoryFileInformationJob.this.histFileViewData.getHistFileName());
                        RetrieveHistoryFileInformationJob.this.jobSuccessful = false;
                        RetrieveHistoryFileInformationJob.this.jobStatus = Status.OK_STATUS;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        RetrieveHistoryFileInformationJob.this.jobSuccessful = false;
                        RetrieveHistoryFileInformationJob.this.jobStatus = Status.CANCEL_STATUS;
                        return Status.OK_STATUS;
                    }
                    localCacheFile.refreshLocal(1, monitor);
                    RetrieveHistoryFileInformationJob.this.jobSuccessful = true;
                    RetrieveHistoryFileInformationJob.this.jobStatus = Status.OK_STATUS;
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    RetrieveHistoryFileInformationJob.this.openErrorThreadSafe(NLS.getString("AddNewHistoryFileAction.AddHistFileErrTitle"), String.valueOf(NLS.getString("AddNewHistoryFileAction.AddHistFileErrMsg")) + " " + RetrieveHistoryFileInformationJob.this.histFileViewData.getHistFileName());
                    FAPlugin.getDefault().log(4, String.valueOf(NLS.getString("AddNewHistoryFileAction.AddHistFileErrMsg")) + " " + RetrieveHistoryFileInformationJob.this.histFileViewData.getHistFileName(), (Exception)((Object)e), false);
                    RetrieveHistoryFileInformationJob.this.jobSuccessful = false;
                    RetrieveHistoryFileInformationJob.this.jobStatus = Status.OK_STATUS;
                    return Status.OK_STATUS;
                }
            }
        };
        readHistFileJob.setPriority(30);
        readHistFileJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        readHistFileJob.addJobChangeListener(new IJobChangeListener(){

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (RetrieveHistoryFileInformationJob.this.jobSuccessful) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                RetrieveHistoryFileInformationJob.this.updateViews(RetrieveHistoryFileInformationJob.this.histFileViewData);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
        readHistFileJob.schedule();
    }

    private void updateViews(FAHistoryFileViewData data) throws Exception {
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage.findView("com.ibm.etools.fa.view.details.DetailedHistoryFileView") != null) {
            DetailedHistoryFileView view = (DetailedHistoryFileView)activePage.showView("com.ibm.etools.fa.view.details.DetailedHistoryFileView");
            ArrayList<FAHistoryFileViewData> viewData = new ArrayList<FAHistoryFileViewData>();
            viewData.add(data);
            view.populateTable(viewData, this.histFileViewData.getHistFileName());
        }
    }
}

