/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.common;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class HistoryIndexFileEntry
implements Serializable {
    public static final String zOS_DEFAULT_ENCODING = "Cp1047";
    private static final long serialVersionUID = 1L;
    private String historyFileName = null;
    private byte[] data = null;

    public HistoryIndexFileEntry(byte[] newData, String historyFileName) {
        this.data = new byte[newData.length];
        System.arraycopy(newData, 0, this.data, 0, newData.length);
        this.historyFileName = historyFileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HistoryIndexFileEntry) {
            HistoryIndexFileEntry otherObj = (HistoryIndexFileEntry)obj;
            byte[] otherData = otherObj.getHistoryIndexFileEntryRawData();
            if (otherData.length != this.data.length) {
                return false;
            }
            int i = 0;
            while (i < otherData.length) {
                if (this.data[i] != otherData[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public byte[] getHistoryIndexFileEntryRawData() {
        return this.data;
    }

    public String getHistoryFileName() {
        return this.historyFileName;
    }

    public byte[] DDirHdHdr() {
        byte[] buf = new byte[4];
        System.arraycopy(this.data, 0, buf, 0, 4);
        return buf;
    }

    public byte DDirHdLevel() {
        return this.data[4];
    }

    public byte[] DDirHdClock() {
        byte[] buf = new byte[8];
        System.arraycopy(this.data, 5, buf, 0, 8);
        return buf;
    }

    public String DDirHdJobname() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 13, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdTsName() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 22, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdOFaultID() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 31, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdCFaultID() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 40, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdAModeNm() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 49, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdUid() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 58, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdJobID() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 67, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdTranID() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 76, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdTranNo() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 85, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdPgmNm() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 94, 9, zOS_DEFAULT_ENCODING));
    }

    public byte DDirHdType() {
        return this.data[103];
    }

    public long DDirPofOffset() {
        return this.parseUnsignedInt(this.data, 104);
    }

    public String DDirPofModBData() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 108, 8, zOS_DEFAULT_ENCODING));
    }

    public String DDirPofModBTime() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 116, 7, zOS_DEFAULT_ENCODING));
    }

    public String DDirPofCsect() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 123, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirPofModule() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 132, 9, zOS_DEFAULT_ENCODING));
    }

    public byte DDirPofPrOrCs() {
        return this.data[141];
    }

    public byte[] DDirPofReserved() {
        byte[] buf = new byte[2];
        System.arraycopy(this.data, 142, buf, 0, 2);
        return buf;
    }

    public byte DDirHdJType() {
        return this.data[144];
    }

    public String DDirHdJClass() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 145, 1, zOS_DEFAULT_ENCODING));
    }

    public byte DDirHdDSNf() {
        return this.data[146];
    }

    public byte DDirHdAbendFormat() {
        return this.data[147];
    }

    public short DDirHdMdPages_old() {
        return this.parseSignedShort(this.data, 148);
    }

    public short DDirHdDupCount() {
        return this.parseSignedShort(this.data, 150);
    }

    public short DDirHdCacheIndex() {
        return this.parseSignedShort(this.data, 152);
    }

    public byte DDirHdTOC() {
        return this.data[154];
    }

    public byte DDirHdWDlevel() {
        return this.data[155];
    }

    public byte[] DDirHdAbend() {
        byte[] buf = new byte[4];
        System.arraycopy(this.data, 156, buf, 0, 4);
        return buf;
    }

    public long DDirHdSDWA() {
        return this.parseUnsignedInt(this.data, 160);
    }

    public long DDirHdCIBp() {
        return this.parseUnsignedInt(this.data, 164);
    }

    public String DDirHdStepname() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 168, 9, zOS_DEFAULT_ENCODING));
    }

    public byte[] DDirHdRes() {
        byte[] buf = new byte[3];
        System.arraycopy(this.data, 177, buf, 0, 3);
        return buf;
    }

    public long DDirHdRFR_IDIDA_TCB() {
        return this.parseUnsignedInt(this.data, 180);
    }

    public short DDIRHdExitName_off() {
        return this.parseSignedShort(this.data, 184);
    }

    public short DDIRHdPLIDSA_Off() {
        return this.parseSignedShort(this.data, 186);
    }

    public int DDirHdDSN_Off() {
        return this.parseUnsignedShort(this.data, 188);
    }

    public short DDirHdAcct_off() {
        return this.parseSignedShort(this.data, 190);
    }

    public short DDirHdFreeSpaceSize() {
        return this.parseSignedShort(this.data, 192);
    }

    public short DDirHdFreeSpace_off() {
        return this.parseSignedShort(this.data, 194);
    }

    public String DDirHdUsrName() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 196, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdImsPrgName() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 205, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdUsrTitle() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 214, 41, zOS_DEFAULT_ENCODING));
    }

    public byte DDirHdReserved2() {
        return this.data[255];
    }

    public byte DDirHdLock() {
        return this.data[256];
    }

    public String DDirHdApplID() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 257, 9, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdTermId() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 266, 5, zOS_DEFAULT_ENCODING));
    }

    public String DDirHdNetName() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 271, 9, zOS_DEFAULT_ENCODING));
    }

    public byte[] DDirHdDupClock() {
        byte[] buf = new byte[8];
        System.arraycopy(this.data, 280, buf, 0, 8);
        return buf;
    }

    public short DDirHdSubSeg_Off() {
        return this.parseSignedShort(this.data, 288);
    }

    public String DDirHdAcceGRPN() throws UnsupportedEncodingException {
        return this.removeZeros(new String(this.data, 290, 9, zOS_DEFAULT_ENCODING));
    }

    public byte DDirHdIAbendFormat() {
        return this.data[299];
    }

    public long DDirHdMdPages() {
        return this.parseUnsignedInt(this.data, 300);
    }

    public int DDirHdCPUhsec() {
        return this.parseSignedInt(this.data, 304);
    }

    public byte[] DDirHdIAbend() {
        byte[] buf = new byte[4];
        System.arraycopy(this.data, 308, buf, 0, 4);
        return buf;
    }

    public byte[] DDirHdSYSDDSN() {
        byte[] buf = new byte[45];
        System.arraycopy(this.data, 312, buf, 0, 45);
        return buf;
    }

    public byte[] DDirHdReserv3() {
        byte[] buf = new byte[3];
        System.arraycopy(this.data, 357, buf, 0, 3);
        return buf;
    }

    public long DDirHdpHistBufInfo() {
        return this.parseUnsignedInt(this.data, 360);
    }

    public byte[] DDirHdReserved() {
        byte[] buf = new byte[84];
        System.arraycopy(this.data, 364, buf, 0, 84);
        return buf;
    }

    public byte[] DDirHdTIME() {
        byte[] buf = new byte[16];
        System.arraycopy(this.data, 448, buf, 0, 16);
        return buf;
    }

    public byte[] DDirHdSTCK() {
        byte[] buf = new byte[8];
        System.arraycopy(this.data, 464, buf, 0, 8);
        return buf;
    }

    private String removeZeros(String s) {
        int i = 0;
        while (i < s.length()) {
            if (i == 0 && s.charAt(i) == '\u0000') {
                s = " ";
                return s;
            }
            if (s.charAt(i) == '\u0000') {
                s = s.substring(0, i).trim();
                return s;
            }
            ++i;
        }
        return s;
    }

    private long parseUnsignedInt(byte[] buffer, int start) {
        long i1 = (buffer[start++] & 0xFF) << 24;
        long i2 = (buffer[start++] & 0xFF) << 16;
        long i3 = (buffer[start++] & 0xFF) << 8;
        long i4 = buffer[start++] & 0xFF;
        return i1 | i2 | i3 | i4;
    }

    private int parseSignedInt(byte[] buffer, int start) {
        int i1 = (buffer[start++] & 0xFF) << 24;
        int i2 = (buffer[start++] & 0xFF) << 16;
        int i3 = (buffer[start++] & 0xFF) << 8;
        int i4 = buffer[start++] & 0xFF;
        return i1 | i2 | i3 | i4;
    }

    private short parseSignedShort(byte[] buffer, int start) {
        short i1 = (short)((buffer[start++] & 0xFF) << 8);
        short i2 = (short)(buffer[start++] & 0xFF);
        return (short)(i1 | i2);
    }

    private int parseUnsignedShort(byte[] buffer, int start) {
        int i1 = (buffer[start++] & 0xFF) << 8;
        int i2 = buffer[start++] & 0xFF;
        return i1 | i2;
    }
}

