/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.IOException;

public class RebootPanel
extends WizardPanel {
    private boolean restartWizard = false;
    private boolean rebootSelected = true;
    private String text = "";

    public RebootPanel() {
        this.setText("$L(com.installshield.wizardx.i18n.WizardXResources, RebootPanel.mustRestart)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("systemUtilService");
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.wizardx.i18n.WizardXResources");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
        if (!this.restartWizard) {
            try {
                SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                systemUtilService.setRebootOnExit(this.rebootSelected);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        } else {
            try {
                SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                systemUtilService.setRebootOnExit(true);
                WizardBean wizardBean = this.getWizard().getIterator().getNext(this.getWizard().getCurrentBean());
                if (wizardBean != this.getWizard().getIterator().end()) {
                    String string = System.getProperty("is.launcher.file");
                    if (string != null) {
                        File file = new File(string);
                        if (!file.exists()) {
                            this.logEvent(this, "err", "The file  " + string + "could not be found.  The wizard " + "will not be restarted.");
                        } else {
                            String string2 = String.valueOf(string) + " -goto " + wizardBean.getBeanId();
                            systemUtilService.addSystemStartupCommand(string2);
                        }
                    } else {
                        this.logEvent(this, "err", "Restarting the wizard after a reboot is only supported through the use of a native launcher.");
                    }
                    this.getWizard().exit(1003);
                }
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public boolean getRebootSelected() {
        return this.rebootSelected;
    }

    public boolean getRestartWizard() {
        return this.restartWizard;
    }

    public String getText() {
        return this.text;
    }

    public boolean isActive() {
        boolean bl;
        block2: {
            bl = super.isActive();
            if (!bl || !this.isRuntime()) break block2;
            try {
                SystemUtilService systemUtilService = (SystemUtilService)this.getService("systemUtilService");
                bl = systemUtilService.isRebootRequired();
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ServiceException)) break block2;
                this.logEvent(this, "err", throwable);
            }
        }
        return bl;
    }

    private boolean isRuntime() {
        boolean bl = false;
        try {
            Class.forName("com.installshield.isje.ISJE");
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = true;
        }
        return bl;
    }

    public void setRebootSelected(boolean bl) {
        this.rebootSelected = bl;
        this.propertyChanged("rebootSelected");
    }

    public void setRestartWizard(boolean bl) {
        this.restartWizard = bl;
    }

    public void setText(String string) {
        this.text = string;
    }
}

