/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32RegistryException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.CreateKeyOperation;
import com.installshield.wizard.platform.win32.registry.DwordValueOperation;
import com.installshield.wizard.platform.win32.registry.HexValueOperation;
import com.installshield.wizard.platform.win32.registry.MultiStringValueOperation;
import com.installshield.wizard.platform.win32.registry.StringValueOperation;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Win32RegistryProcessor {
    private static final int INITIALIZING = 1;
    private static final int READY_FOR_ITEM = 2;
    private static final int REMOVING_ITEM = 3;
    private static final int READING_KEY = 4;
    private static final int READING_VALUE = 5;
    private static final int READING_VALUE_TYPE = 6;
    private static final int READING_STRING_VALUE = 7;
    private static final int READING_DWORD_VALUE = 8;
    private static final int READING_HEX_VALUES = 9;
    private static final int READING_MORE_HEX_VALUES = 10;
    private static final int READING_EXPANDING_STRING_VALUES = 11;
    private static final int READING_MULTI_STRING_VALUES = 12;
    private static final int READING_MORE_EXPANDING_STRING_VALUES = 13;
    private static final int READING_MORE_MULTI_STRING_VALUES = 14;
    private int m_nState = 1;
    private BufferedReader m_br = null;
    private String m_strLine = null;
    private StringTokenizer m_st = null;
    private boolean m_bRemoving = false;
    private String m_strCurrentKey = null;
    private String m_strCurrentParentKey = null;
    private String m_strCurrentChildKey = null;
    private int m_nCurrentHive = -1;
    private String m_strValueName = null;
    private int m_nLine = 0;
    private Vector m_allBytes = null;
    private Win32RegistryService m_registryService = null;
    private WizardServices m_services;
    private StringBuffer m_stringInProgress = null;
    private Vector m_multiString = null;
    private Vector operationList = new Vector();

    public Win32RegistryProcessor(InputStream inputStream, WizardServices wizardServices, Win32RegistryService win32RegistryService) throws FileNotFoundException {
        this.m_br = new BufferedReader(new InputStreamReader(inputStream));
        this.m_registryService = win32RegistryService;
        this.m_services = wizardServices;
    }

    public Win32RegistryProcessor(String string, WizardServices wizardServices, Win32RegistryService win32RegistryService) {
        this.m_br = new BufferedReader(new StringReader(string));
        this.m_registryService = win32RegistryService;
        this.m_services = wizardServices;
    }

    private String getNextToken(String string, boolean bl) {
        String string2;
        do {
            try {
                string2 = string == null ? this.m_st.nextToken() : this.m_st.nextToken(string);
                if (string2 == null || !bl) continue;
                string2 = string2.trim();
            }
            catch (NoSuchElementException noSuchElementException) {
                string2 = null;
            }
        } while (string2 != null && bl && string2.length() == 0);
        return string2;
    }

    private String getQuotedString() {
        boolean bl = false;
        String string = new String("");
        do {
            String string2;
            if ((string2 = this.getNextToken("\"", false)).equals("\"")) {
                if (string.endsWith("\\") && this.m_st.hasMoreTokens()) {
                    String string3 = string;
                    string = string3.substring(0, string3.length() - 1);
                    string = String.valueOf(string) + string2;
                    continue;
                }
                bl = true;
                continue;
            }
            string = String.valueOf(string) + string2;
        } while (!bl && this.m_st.hasMoreTokens());
        return bl ? string : null;
    }

    private void initializeStringInProgress() {
        this.m_stringInProgress = new StringBuffer(64);
    }

    private boolean nextLine() throws Win32RegistryException {
        try {
            do {
                this.m_strLine = this.m_br.readLine();
                if (this.m_strLine == null) continue;
                this.m_strLine = this.m_services.resolveString(this.m_strLine.trim());
                ++this.m_nLine;
            } while (this.m_strLine != null && this.m_strLine.length() == 0);
            if (this.m_strLine != null) {
                this.m_st = null;
                this.m_st = new StringTokenizer(this.m_strLine, " \t", true);
            }
        }
        catch (IOException iOException) {
            throw new Win32RegistryException(iOException, this.m_nLine);
        }
        return this.m_strLine != null;
    }

    public Vector process() throws Win32RegistryException {
        try {
            this.m_nState = 1;
            boolean bl = this.nextLine();
            boolean bl2 = true;
            while (bl) {
                switch (this.m_nState) {
                    case 1: {
                        bl2 = this.processRegEdit4();
                        if (bl2) break;
                        bl = false;
                        break;
                    }
                    case 2: {
                        this.m_bRemoving = false;
                        bl2 = this.processItem();
                        break;
                    }
                    case 3: {
                        this.m_bRemoving = true;
                        bl2 = this.processItem();
                        break;
                    }
                    case 4: {
                        bl2 = this.processKey();
                        break;
                    }
                    case 5: {
                        bl2 = this.processValue();
                        break;
                    }
                    case 6: {
                        bl2 = this.processValueType();
                        break;
                    }
                    case 7: {
                        bl2 = this.processStringValue();
                        break;
                    }
                    case 11: {
                        this.initializeStringInProgress();
                        bl2 = this.processExpandingStringValue();
                        break;
                    }
                    case 12: {
                        this.m_multiString = new Vector(10);
                        this.initializeStringInProgress();
                        bl2 = this.processMultiStringValue();
                        break;
                    }
                    case 13: {
                        bl2 = this.processExpandingStringValue();
                        break;
                    }
                    case 14: {
                        bl2 = this.processMultiStringValue();
                        break;
                    }
                    case 8: {
                        bl2 = this.processDWordValue();
                        break;
                    }
                    case 9: {
                        this.m_allBytes = null;
                        this.m_allBytes = new Vector(20);
                        bl2 = this.processHexValues();
                        break;
                    }
                    case 10: {
                        bl2 = this.processHexValues();
                        break;
                    }
                }
                if (!bl2) {
                    this.m_nState = 2;
                }
                if (!bl || bl2 && this.m_st.hasMoreTokens()) continue;
                bl = this.nextLine();
            }
        }
        catch (Win32RegistryException win32RegistryException) {
            throw win32RegistryException;
        }
        catch (Exception exception) {
            throw new Win32RegistryException(exception, this.m_nLine);
        }
        return this.operationList;
    }

    private boolean processDWordValue() throws Win32RegistryException, ServiceException {
        boolean bl = true;
        String string = this.getNextToken(" \t", true);
        try {
            Long l = Long.valueOf(string, 16);
            if (l < 0L || l > 0xFFFFFFFFL) {
                bl = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.dwordValueOutOfRange", new String[]{string, new Long(0L).toString(), new Long(0xFFFFFFFFL).toString()}), this.m_nLine);
            }
            DwordValueOperation dwordValueOperation = new DwordValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, l.intValue());
            dwordValueOperation.install(this.m_registryService);
            this.operationList.addElement(dwordValueOperation);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForDword", new String[]{string}), this.m_nLine);
        }
        this.m_nState = 2;
        return bl;
    }

    private boolean processExpandingStringValue() throws Win32RegistryException, ServiceException {
        String string;
        boolean bl = true;
        boolean bl2 = false;
        do {
            if ((string = this.getNextToken(" ,\t\\", false)) == null || string.trim().length() == 0 || string.equals(",")) continue;
            if (string.equals("\\")) {
                this.m_nState = 14;
                bl2 = true;
                continue;
            }
            try {
                Integer n = Integer.valueOf(string, 16);
                if (n < 0 || n > 255) {
                    bl = false;
                    throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.hexValueOutOfRange", new String[]{string, new Integer(0).toString(), new Integer(255).toString()}), this.m_nLine);
                }
                if (n == 0) continue;
                this.m_stringInProgress.append((char)n.intValue());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForHex", new String[]{string}), this.m_nLine);
            }
        } while (this.m_st.hasMoreTokens() && bl);
        if (!bl2) {
            if (bl) {
                string = new StringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, true, this.m_stringInProgress.toString());
                string.install(this.m_registryService);
                this.operationList.addElement(string);
            }
            this.m_nState = 2;
        }
        return bl;
    }

    private boolean processHexValues() throws Win32RegistryException, ServiceException {
        Object object;
        Object object2;
        boolean bl = true;
        boolean bl2 = false;
        do {
            if ((object2 = this.getNextToken(" ,\t\\", false)) == null || ((String)object2).trim().length() == 0 || ((String)object2).equals(",")) continue;
            if (((String)object2).equals("\\")) {
                this.m_nState = 10;
                bl2 = true;
                continue;
            }
            try {
                object = Integer.valueOf((String)object2, 16);
                if ((Integer)object < 0 || (Integer)object > 255) {
                    bl = false;
                    throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.hexValueOutOfRange", new String[]{object2, new Integer(0).toString(), new Integer(255).toString()}), this.m_nLine);
                }
                this.m_allBytes.addElement(object);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForHex", new String[]{object2}), this.m_nLine);
            }
        } while (this.m_st.hasMoreTokens() && bl);
        if (!bl2) {
            if (bl) {
                object2 = new byte[this.m_allBytes.size()];
                object = this.m_allBytes.elements();
                int n = 0;
                while (object.hasMoreElements()) {
                    object2[n] = ((Integer)object.nextElement()).byteValue();
                    ++n;
                }
                HexValueOperation hexValueOperation = new HexValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, (byte[])object2);
                hexValueOperation.install(this.m_registryService);
                this.operationList.addElement(hexValueOperation);
            }
            this.m_nState = 2;
        }
        return bl;
    }

    private boolean processItem() throws Win32RegistryException {
        String string = this.getNextToken("[\"-]", true);
        if (string == null) {
            return false;
        }
        boolean bl = true;
        if (this.m_nState != 3 && string.equals("-")) {
            this.m_nState = 3;
        } else if (string.equals("\"")) {
            this.m_nState = 5;
        } else if (string.equals("[")) {
            this.m_nState = 4;
        } else {
            bl = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noClosingQuoteForValueName"), this.m_nLine);
        }
        return bl;
    }

    private boolean processKey() throws Win32RegistryException, ServiceException {
        boolean bl = false;
        try {
            this.setCurrentKey(this.getNextToken("]", false));
            String string = this.getNextToken("]", false);
            if (string.equals("]")) {
                if (this.m_bRemoving) {
                    this.m_registryService.deleteKey(this.m_nCurrentHive, this.m_strCurrentParentKey, this.m_strCurrentChildKey, false);
                    this.setCurrentKey(null);
                    bl = true;
                } else {
                    CreateKeyOperation createKeyOperation = new CreateKeyOperation(this.m_nCurrentHive, this.m_strCurrentParentKey, this.m_strCurrentChildKey);
                    createKeyOperation.install(this.m_registryService);
                    this.operationList.addElement(createKeyOperation);
                    bl = true;
                }
            } else {
                this.setCurrentKey(null);
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidKey"), this.m_nLine);
            }
            this.m_nState = 2;
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = true;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidKey"), this.m_nLine);
        }
        return bl;
    }

    private boolean processMultiStringValue() throws Win32RegistryException, ServiceException {
        Integer n;
        Object[] objectArray;
        boolean bl = true;
        boolean bl2 = false;
        do {
            if ((objectArray = this.getNextToken(" ,\t\\", false)) == null || objectArray.trim().length() == 0 || objectArray.equals(",")) continue;
            if (objectArray.equals("\\")) {
                this.m_nState = 14;
                bl2 = true;
                continue;
            }
            try {
                n = Integer.valueOf((String)objectArray, 16);
                if (n < 0 || n > 255) {
                    bl = false;
                    throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.hexValueOutOfRange", new String[]{objectArray, new Integer(0).toString(), new Integer(255).toString()}), this.m_nLine);
                }
                if (n == 0) {
                    if (!this.m_st.hasMoreTokens()) continue;
                    this.m_multiString.addElement(this.m_stringInProgress.toString());
                    this.initializeStringInProgress();
                    continue;
                }
                this.m_stringInProgress.append((char)n.intValue());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForHex", new String[]{objectArray}), this.m_nLine);
            }
        } while (this.m_st.hasMoreTokens() && bl);
        if (!bl2) {
            if (bl) {
                objectArray = new String[this.m_multiString.size()];
                this.m_multiString.copyInto(objectArray);
                n = new MultiStringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, (String[])objectArray);
                n.install(this.m_registryService);
                this.operationList.addElement(n);
            }
            this.m_nState = 2;
        }
        return bl;
    }

    private boolean processRegEdit4() {
        boolean bl = false;
        String string = this.getNextToken(" \t\n", true);
        if (string != null && string.equalsIgnoreCase("REGEDIT4")) {
            this.m_nState = 2;
            bl = true;
        }
        return bl;
    }

    private boolean processStringValue() throws Win32RegistryException, ServiceException {
        boolean bl = false;
        String string = this.getQuotedString();
        if (string == null) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noClosingQuoteForString", new String[]{this.m_strValueName, this.m_strCurrentKey}), this.m_nLine);
        }
        boolean bl2 = string.indexOf(37) >= 0;
        StringValueOperation stringValueOperation = new StringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, bl2, string);
        stringValueOperation.install(this.m_registryService);
        this.operationList.addElement(stringValueOperation);
        bl = true;
        this.m_nState = 2;
        return bl;
    }

    private boolean processValue() throws Win32RegistryException, ServiceException {
        if (this.m_strCurrentKey == null) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noKeySpecified"), this.m_nLine);
        }
        this.m_strValueName = this.getQuotedString();
        if (this.m_strValueName == null) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noClosingQuoteForValueName"), this.m_nLine);
        }
        String string = new String(this.m_strValueName);
        if (this.m_strValueName.equals("@")) {
            this.m_strValueName = "";
        }
        if (this.m_bRemoving) {
            this.m_registryService.deleteValue(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, false);
            this.m_nState = 2;
        } else {
            String string2 = this.getNextToken("=", true);
            if (string2 == null || !string2.equals("=")) {
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noEqualAfterValueName", new String[]{string}), this.m_nLine);
            }
            this.m_nState = 6;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processValueType() throws Win32RegistryException, ServiceException {
        boolean bl = false;
        String string = this.getNextToken("\":", true);
        if ((string = string.trim()).equals("\"")) {
            bl = true;
            this.m_nState = 7;
            return bl;
        }
        bl = true;
        String string2 = this.getNextToken(":", true);
        if (!string2.equals(":")) {
            return false;
        }
        String string3 = string.toLowerCase();
        if (string3.equals("dword")) {
            if (this.m_st.hasMoreTokens()) {
                this.m_nState = 8;
                return bl;
            }
            bl = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noValueAfterDwordType"), this.m_nLine);
        }
        if (string3.startsWith("hex(2)")) {
            if (this.m_st.hasMoreTokens()) {
                this.m_nState = 11;
                return bl;
            }
            StringValueOperation stringValueOperation = new StringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, true, "");
            stringValueOperation.install(this.m_registryService);
            this.operationList.addElement(stringValueOperation);
            this.m_nState = 2;
            return bl;
        }
        if (string3.startsWith("hex(7)")) {
            if (this.m_st.hasMoreTokens()) {
                this.m_nState = 12;
                return bl;
            }
            MultiStringValueOperation multiStringValueOperation = new MultiStringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, new String[0]);
            multiStringValueOperation.install(this.m_registryService);
            this.operationList.addElement(multiStringValueOperation);
            this.m_nState = 2;
            return bl;
        }
        if (!string3.startsWith("hex")) {
            bl = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidDataType", new String[]{string}), this.m_nLine);
        }
        if (this.m_st.hasMoreTokens()) {
            this.m_nState = 9;
            return bl;
        }
        HexValueOperation hexValueOperation = new HexValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, new byte[0]);
        hexValueOperation.install(this.m_registryService);
        this.operationList.addElement(hexValueOperation);
        this.m_nState = 2;
        return bl;
    }

    private void setCurrentKey(String string) throws Win32RegistryException {
        if (string == null) {
            this.m_strCurrentKey = null;
            this.m_strCurrentParentKey = null;
            this.m_strCurrentChildKey = null;
            this.m_nCurrentHive = -1;
        } else {
            if (string.endsWith("\\")) {
                string = string.substring(0, string.length() - 1);
            }
            int n = string.indexOf(92);
            this.m_nCurrentHive = -1;
            String string2 = n < 0 ? string : string.substring(0, n);
            if (string2.equalsIgnoreCase("HKEY_LOCAL_MACHINE")) {
                this.m_nCurrentHive = 4;
            } else if (string2.equalsIgnoreCase("HKEY_CLASSES_ROOT")) {
                this.m_nCurrentHive = 1;
            } else if (string2.equalsIgnoreCase("HKEY_CURRENT_CONFIG")) {
                this.m_nCurrentHive = 2;
            } else if (string2.equalsIgnoreCase("HKEY_CURRENT_USER")) {
                this.m_nCurrentHive = 3;
            } else if (string2.equalsIgnoreCase("HKEY_USERS")) {
                this.m_nCurrentHive = 5;
            }
            if (this.m_nCurrentHive != -1) {
                if (n < 0) {
                    this.m_strCurrentKey = null;
                    this.m_strCurrentParentKey = null;
                    this.m_strCurrentChildKey = null;
                } else {
                    this.m_strCurrentKey = string.substring(n + 1);
                    int n2 = this.m_strCurrentKey.lastIndexOf(92);
                    if (n2 < 0) {
                        this.m_strCurrentChildKey = this.m_strCurrentKey;
                        this.m_strCurrentParentKey = null;
                    } else {
                        this.m_strCurrentChildKey = this.m_strCurrentKey.substring(n2 + 1);
                        this.m_strCurrentParentKey = this.m_strCurrentKey.substring(0, n2);
                    }
                }
            } else {
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidRegistryHiveInKey", new String[]{string, string2}), this.m_nLine);
            }
        }
    }
}

