/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.commandline;

import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardEvent;
import com.installshield.wizard.WizardListener;
import com.installshield.wizard.commandline.GenerateOptionsTemplate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class GenerateOptionsRecord
extends GenerateOptionsTemplate
implements WizardListener {
    private String fileName;

    public void currentBeanChanged(WizardEvent wizardEvent) {
    }

    public boolean execute(Wizard wizard, String[] stringArray) {
        if (stringArray.length != 1) {
            wizard.setExitCode(1001);
            System.err.println("Invalid command line option: options-record requires a file name");
            return false;
        }
        this.fileName = stringArray[0];
        try {
            File file = new File(this.fileName);
            new FileOutputStream(file).close();
            file.delete();
        }
        catch (IOException iOException) {
            System.err.println("Cannot create options file " + this.fileName);
        }
        System.out.println("Options record mode enabled - run the wizard to completion to create the options file " + this.fileName);
        wizard.addWizardListener(this);
        return true;
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("options-record");
    }

    public void wizardFinished(WizardEvent wizardEvent) {
        if (wizardEvent.getWizard().getExitCode() == 0) {
            this.createOptionsFile(this.fileName, 2, wizardEvent.getWizard());
        } else {
            System.err.println("Options file " + this.fileName + " was not created because the wizard did not exit normally");
        }
    }

    public void wizardInitializing(WizardEvent wizardEvent) {
    }

    public void wizardStarted(WizardEvent wizardEvent) {
    }
}

