/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.rex;

import com.installshield.util.rex.Atom;
import com.installshield.util.rex.Range;

class Expr
extends Range {
    static int numberSequence = 0;
    Atom list = null;
    Atom curp = null;
    Atom curpAlt = null;
    int altLevel = 0;
    int number;
    Atom firstAtom;

    Expr() {
        this(true);
    }

    Expr(boolean bl) {
        if (bl) {
            this.number = numberSequence++;
        }
    }

    Atom append(Atom atom) {
        if (this.altLevel > 0) {
            --this.altLevel;
            if (this.curpAlt == null) {
                return this.appendAlt(atom, this.altLevel);
            }
            this.curpAlt = this.curpAlt.rplacd(atom);
            return this.curpAlt;
        }
        this.curpAlt = null;
        this.curp = this.curp == null ? (this.list = atom) : this.curp.rplacd(atom);
        return this.curp;
    }

    final Atom appendAlt(Atom atom) {
        return this.appendAlt(atom, 0);
    }

    Atom appendAlt(Atom atom, int n) {
        if (this.curp == null) {
            return this.append(atom);
        }
        if (this.curpAlt == null) {
            this.curpAlt = this.curp;
        }
        this.altLevel = n;
        this.curpAlt = this.curpAlt.rplacp(atom);
        return this.curpAlt;
    }

    final int getAltLevel() {
        return this.altLevel;
    }

    Atom getHead() {
        return this.list;
    }

    boolean isEmpty() {
        return this.list == null;
    }

    String listToString() {
        StringBuffer stringBuffer = new StringBuffer("");
        Atom atom = this.list;
        while (atom != null) {
            if (atom != this.list) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(atom.rexToString());
            Atom atom2 = atom.cpr();
            while (atom2 != null) {
                stringBuffer.append("\n\tOR");
                Atom atom3 = atom2;
                while (atom3 != null) {
                    stringBuffer.append(" " + atom3.rexToString());
                    atom3 = atom3.cdr();
                }
                atom2 = atom2.cpr();
            }
            atom = atom.cdr();
        }
        return stringBuffer.toString();
    }

    String rexToString() {
        return "( " + this.listToString() + " ){" + this.min + "," + (this.max == 256 ? "Max" : String.valueOf(this.max)) + "}";
    }

    final void setAltLevel(int n) {
        this.altLevel = n;
    }

    final void setFirstAtom() {
        this.firstAtom = this.list.car();
    }
}

