/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringUtils;
import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;

public class DestinationPanel
extends WizardPanel {
    private static final String CREATE_DIR = "createDirectoryResponse";
    private static final String YES_RESPONSE = "yes";
    private static final String NO_RESPONSE = "no";
    private final String productURL = "/product.xml";
    private String destinationCaption = "";
    private String browseCaption = "";
    private String destination = "";
    private boolean destinationSet = false;

    public DestinationPanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources,DestinationPanel.description,$P(displayName))");
        this.setDestinationCaption("$L(com.installshield.wizardx.i18n.WizardXResources,DirectoryInputComponent.DirectoryName)");
        this.setBrowseCaption("$L(com.installshield.wizard.i18n.WizardResources,browseWithMn)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("productService");
        wizardBuilderSupport.putRequiredService("fileService");
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.product.i18n.ProductResources");
            wizardBuilderSupport.putClass("com.installshield.product.wizardbeans.DestinationPanelSwingImpl$1");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            String string = "";
            ProductService productService = (ProductService)this.getService("productService");
            string = (String)productService.getProductBeanProperty("/product.xml", null, "absoluteInstallLocation");
            FileService fileService = (FileService)this.getService("fileService");
            String string2 = "";
            if (string != null) {
                string2 = this.resolveString(string);
            }
            boolean bl = false;
            if (string2.trim().length() > 0 && !string2.equals("")) {
                String string3;
                boolean bl2 = bl = fileService.fileExists(string2);
                if (!bl && this.getWizard().getServices().getValue(CREATE_DIR) != null && (string3 = (String)this.getWizard().getServices().getValue(CREATE_DIR)).equals(YES_RESPONSE)) {
                    fileService.createDirectory(string2);
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
        this.updateProductTree();
    }

    public String getBrowseCaption() {
        return this.browseCaption;
    }

    String getDestination() {
        return this.destination;
    }

    public String getDestinationCaption() {
        return this.destinationCaption;
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        String string = this.resolveString("$P(displayName)");
        String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.ote1Title", new String[]{string});
        String string3 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.ote1Doc");
        String string4 = "-P installLocation=";
        string4 = n == 1 ? String.valueOf(string4) + this.getOptionsFileTemplateValueStr() : String.valueOf(string4) + "\"" + this.getProductInstallLocation() + "\"";
        return new OptionsTemplateEntry[]{new OptionsTemplateEntry(string2, string3, string4)};
    }

    private String getProductInstallLocation() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            return (String)productService.getProductBeanProperty("/product.xml", null, "absoluteInstallLocation");
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return this.getDestination();
        }
    }

    private boolean isDirectoryWritable(FileService fileService, String string) {
        try {
            if (fileService.fileExists(string) && !fileService.isDirectoryWritable(string)) {
                throw new IOException("Directory exists and its read-only");
            }
            Stack<String> stack = new Stack<String>();
            String string2 = string;
            while (string2 != null && !fileService.fileExists(string2)) {
                stack.push(string2);
                string2 = fileService.getParent(string2);
            }
            Vector<String> vector = new Vector<String>();
            while (!stack.isEmpty()) {
                String string3 = (String)stack.pop();
                fileService.createDirectory(string3);
                vector.addElement(string3);
            }
            int n = vector.size() - 1;
            while (n >= 0) {
                fileService.deleteDirectory((String)vector.elementAt(n));
                --n;
            }
            return true;
        }
        catch (Exception exception) {
            this.logEvent(this, "wrn", exception.getMessage());
            return false;
        }
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        block2: {
            if (this.destinationSet) break block2;
            try {
                this.setDestination(this.getProductInstallLocation());
                this.destinationSet = true;
            }
            catch (Exception exception) {
                this.logEvent(this, "err", exception);
            }
        }
        return true;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        return this.validateDestination();
    }

    public void setBrowseCaption(String string) {
        if (string.equals("$L(com.installshield.wizard.i18n.WizardResources,browse)")) {
            string = "$L(com.installshield.wizard.i18n.WizardResources,browseWithMn)";
        }
        this.browseCaption = string;
        this.propertyChanged("browseCaption");
    }

    void setDestination(String string) {
        this.destination = string;
    }

    public void setDestinationCaption(String string) {
        this.destinationCaption = string;
        this.propertyChanged("destinationCaption");
    }

    private void showErrorMsg(String string, String string2) {
        try {
            this.getWizard().getServices().displayUserMessage(string, string2, 4);
        }
        catch (Exception exception) {
            throw new Error();
        }
    }

    private void showLocalizedErrorMsg(String string, String string2, String string3) {
        try {
            String string4 = LocalizedStringResolver.resolve(string, string2);
            String string5 = LocalizedStringResolver.resolve(string, string3);
            this.getWizard().getServices().displayUserMessage(string4, string5, 4);
        }
        catch (Exception exception) {
            throw new Error();
        }
    }

    private void showLocalizedErrorMsg(String string, String string2, String string3, String[] stringArray) {
        try {
            String string4 = LocalizedStringResolver.resolve(string, string2);
            String string5 = LocalizedStringResolver.resolve(string, string3, stringArray);
            this.getWizard().getServices().displayUserMessage(string4, string5, 4);
        }
        catch (Exception exception) {
            throw new Error();
        }
    }

    private void updateProductTree() {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setProductBeanProperty("/product.xml", null, "installLocation", this.resolveString(this.destination));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private boolean validateDestination() {
        if (StringUtils.isWhitespace(this.destination)) {
            this.showLocalizedErrorMsg("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory", "DestinationPanel.specifyDirectory");
            return false;
        }
        try {
            FileService fileService = (FileService)this.getService("fileService");
            fileService.validateFileName(this.destination);
            if (!this.isDirectoryWritable(fileService, this.destination)) {
                this.showLocalizedErrorMsg("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory", "notWritable", new String[]{this.destination});
                return false;
            }
        }
        catch (ServiceException serviceException) {
            this.showErrorMsg(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.destinationDirectory"), serviceException.getMessage());
            return false;
        }
        return true;
    }
}

