/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;

public class ChildrenProductTreeIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private FilteredProductTreeIterator iter;
    private ProductBean root;

    public ChildrenProductTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator) {
        this.iter = filteredProductTreeIterator;
        this.root = filteredProductTreeIterator.getNext(filteredProductTreeIterator.begin());
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        return productBean.equals(this.root) || productBean.getProductTree().getParent(productBean).equals(this.root);
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        if (productBean2 != this.iter.end() && productBean2.equals(this.root)) {
            productBean2 = this.iter.getNext(productBean2);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getPrevious(productBean);
        if (productBean2 != this.iter.begin() && productBean2.equals(this.root)) {
            productBean2 = this.iter.getPrevious(productBean2);
        }
        return productBean2;
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

