/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;

public class SourceFile
implements PropertyAccessible {
    private static final int OLD_UNKNOWN_TYPE = 0;
    private static final int OLD_ASCII_TYPE = 1;
    private static final int OLD_BINARY_TYPE = 2;
    private static final int OLD_DIRECTORY_TYPE = 3;
    private static final int OLD_DIRECTORY_TREE_TYPE = 4;
    public static final int UNKNOWN_FILE_TYPE = 0;
    public static final int ASCII_FILE_TYPE = 1;
    public static final int BINARY_FILE_TYPE = 2;
    public static final int UNKNOWN_ENTRY_TYPE = 0;
    public static final int FILE_ENTRY_TYPE = 1;
    public static final int DIRECTORY_ENTRY_TYPE = 2;
    public static final int FILENAME_ONLY = 0;
    public static final int PATH_AND_FILENAME = 1;
    private String fileName = "";
    private boolean resolveRuntimeFileName = false;
    private int pathForFiltering = 0;
    private String pattern = null;
    private String excludePattern = null;
    private boolean usingGNUPattern = false;
    private boolean usingGNUExcludePattern = false;
    private FileAttributes attributes = null;
    private int entryType = 0;
    private int fileType = 0;
    private boolean includeSubdirs = false;

    public SourceFile() {
    }

    public SourceFile(SourceFile sourceFile) {
        this.fileName = sourceFile.fileName;
        this.resolveRuntimeFileName = sourceFile.resolveRuntimeFileName;
        this.pattern = sourceFile.pattern;
        this.excludePattern = sourceFile.excludePattern;
        this.usingGNUPattern = sourceFile.usingGNUPattern;
        this.usingGNUExcludePattern = sourceFile.usingGNUExcludePattern;
        if (sourceFile.attributes != null) {
            this.attributes = (FileAttributes)sourceFile.attributes.clone();
        }
        this.fileType = sourceFile.fileType;
        this.entryType = sourceFile.entryType;
        this.includeSubdirs = sourceFile.includeSubdirs;
    }

    public SourceFile(String string) {
        this.setFileName(string);
    }

    public SourceFile(String string, String string2, int n) {
        this(string, string2, "", n);
    }

    public SourceFile(String string, String string2, String string3, int n) {
        this.setFileName(string);
        this.setIncludeSubdirs(true);
        this.setFileType(n);
        this.setEntryType(2);
        this.setPattern(string2);
        this.setExcludePattern(string3);
    }

    public FileAttributes getAttributes() {
        return this.attributes;
    }

    public int getEntryType() {
        return this.entryType;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileType() {
        return this.fileType;
    }

    public boolean getIncludeSubdirs() {
        return this.includeSubdirs;
    }

    public int getPathForFiltering() {
        return this.pathForFiltering;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getResolveRuntimeFileName() {
        return this.resolveRuntimeFileName;
    }

    public boolean isDirectoryTree() {
        return this.getEntryType() == 2 && this.getIncludeSubdirs();
    }

    public boolean isUsingGNUExcludePattern() {
        return this.usingGNUExcludePattern;
    }

    public boolean isUsingGNUPattern() {
        return this.usingGNUPattern;
    }

    public void setAttributes(FileAttributes fileAttributes) {
        this.attributes = fileAttributes;
    }

    public void setEntryType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("entryType: " + n);
        }
        this.entryType = n;
    }

    public void setExcludePattern(String string) {
        this.excludePattern = string;
    }

    public void setFileName(String string) {
        if (string != null) {
            string = FileUtils.normalizeFileName(string, '/');
        }
        this.fileName = string;
    }

    public void setFileType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("fileType: " + n);
        }
        this.fileType = n;
    }

    public void setIncludeSubdirs(boolean bl) {
        this.includeSubdirs = bl;
    }

    public void setPathForFiltering(int n) {
        this.pathForFiltering = n;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setResolveRuntimeFileName(boolean bl) {
        this.resolveRuntimeFileName = bl;
    }

    public void setType(int n) {
        switch (n) {
            case 0: {
                this.setEntryType(1);
                this.setFileType(0);
                this.setIncludeSubdirs(false);
                break;
            }
            case 1: {
                this.setEntryType(1);
                this.setFileType(1);
                this.setIncludeSubdirs(false);
                break;
            }
            case 2: {
                this.setEntryType(1);
                this.setFileType(2);
                this.setIncludeSubdirs(false);
                break;
            }
            case 3: {
                this.setEntryType(2);
                this.setFileType(2);
                this.setIncludeSubdirs(false);
                break;
            }
            case 4: {
                this.setEntryType(2);
                this.setFileType(2);
                this.setIncludeSubdirs(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("type: " + n);
            }
        }
    }

    public void setUsingGNUExcludePattern(boolean bl) {
        this.usingGNUExcludePattern = bl;
    }

    public void setUsingGNUPattern(boolean bl) {
        this.usingGNUPattern = bl;
    }
}

