/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.ArchiveWriterOutputStream;
import com.installshield.archive.ResourceWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipException;

public class ArchiveResourceWriter
implements ResourceWriter {
    protected ArchiveWriterOutputStream out;
    private ArchiveWriterEntry entry;

    public ArchiveResourceWriter() {
        this(null, null);
    }

    public ArchiveResourceWriter(ArchiveWriterOutputStream archiveWriterOutputStream, ArchiveWriterEntry archiveWriterEntry) {
        if (archiveWriterOutputStream == null && archiveWriterEntry != null || archiveWriterOutputStream != null && archiveWriterEntry == null) {
            throw new IllegalArgumentException("out and entry must either be both null or both not null");
        }
        this.out = archiveWriterOutputStream;
        this.entry = archiveWriterEntry;
    }

    public void close(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ArchiveWriterOutputStream) {
            ((ArchiveWriterOutputStream)((Object)outputStream)).closeEntry();
        }
    }

    public Date getDate() {
        Date date = null;
        if (this.entry != null) {
            date = this.entry.getDate();
        }
        return date;
    }

    public String getId() {
        String string = null;
        if (this.entry != null) {
            string = this.entry.getId();
        }
        return string;
    }

    public boolean isSpannable() {
        return this.entry.isSpannable();
    }

    public OutputStream open() throws IOException {
        if (this.out != null) {
            try {
                this.out.putNextEntry(this.entry);
                return this.out.open();
            }
            catch (ZipException zipException) {
                if (zipException.getMessage().startsWith("duplicate entry")) {
                    return null;
                }
                throw zipException;
            }
        }
        return new ByteArrayOutputStream();
    }
}

