<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>

<xsl:template match="LCReport">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="LCReportHeader">
<xsl:text disable-output-escaping="yes">&lt;html&gt;</xsl:text><head>
	<style type="text/css">
		.style1 {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 24px;
			font-style: normal;
			line-height: normal;
			font-weight: bold;
			color: #527081;
		}
		.style1_small {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 16px;
			font-style: normal;
			line-height: normal;
			font-weight: bold;
			color: #527081;
		}
		.style1_1 {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 18px;
			font-style: normal;
			line-height: normal;
			font-weight: bold;
		}
		.style3 {
			font-family: Arial, Helvetica, sans-serif;
			font-size: 14px;
			font-style: italic;
			font-weight: normal;
			color: #333333;
		}
		.style2 {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 14px;
			font-style: normal;
			font-weight: normal;
			color: #527081;
			text-decoration: none;
		}
		.style2_1 {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 14px;
			font-style: normal;
			line-height: normal;
			font-weight: normal;
		}
		.style4 {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 14px;
			font-style: normal;
			line-height: normal;
			font-weight: normal;
		}
		.style4bold {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 14px;
			font-style: normal;
			line-height: normal;
			font-weight: bold;
		}
		.style5 {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-size: 10px;
			font-style: normal;
			line-height: normal;
			font-weight: normal;
		}
	</style>
	<title>
		<xsl:value-of select="."/>
	</title>
	</head>
	<xsl:text disable-output-escaping="yes">&lt;body&gt;</xsl:text>
	<xsl:text disable-output-escaping="yes">&lt;table width="800" border="0" align="center"&gt;</xsl:text>
	<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
		<xsl:text disable-output-escaping="yes">&lt;td align="center" valign="top"&gt;</xsl:text>
		
		<img src="../images/Relativity.gif" alt="" width="800" height="110"/><br/>			
			<table width="90%" border="0" align="center">
				<tr>
					<td width="23%" nowrap="nowrap" class="style1_small">
						<div align="right">
						<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;SOA Assessment</xsl:text>
						</div></td>
					<td width="77%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
				</tr>
				<tr>
				    <td width="23%" class="style2">
						<div align="right">
						<xsl:text disable-output-escaping="yes">Client:&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
						</div></td>
			        <td width="77%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
				</tr>
				<tr>
				    <td widht="23%" class="style2">
						<div align="right">
						<xsl:text disable-output-escaping="yes">Application:&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
						</div></td>
			        <td width="77%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
				</tr>
				<tr>
					<td height="30" colspan="2"><div align="center"><img src="../images/line.gif" width="734" height="6"/></div></td>
				</tr>
        		<tr>
          			<td height="50" colspan="8" class="style1">
						<div align="center">
							<xsl:value-of select="."/>
						</div></td>
          		</tr>
	  		</table>
</xsl:template>


<xsl:template match="LCReportFooter">
<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>

<xsl:text disable-output-escaping="yes">&lt;table width="70%" border="0"&gt;</xsl:text>
<tr>
	<td nowrap="nowrap" colspan="8">
		<br/>
		<div align="right" class="style5">
		Report generated at <xsl:value-of select="./@date"/>
		</div>
		<xsl:value-of select="."/>
		<br/>
	</td>
</tr>
<tr>
	<td colspan="8" class="style2_1">
		<b>Remarks:</b><br/>
		<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
		<img style="position:relative; top:3px;" src="../images/missing.gif" width="15" align="baseline" />
		<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;Denotes missing file.</xsl:text>
	</td>
</tr>
<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>

<xsl:text disable-output-escaping="yes">&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;</xsl:text>

<xsl:text disable-output-escaping="yes">&lt;/body&gt;&lt;/html&gt;</xsl:text>
</xsl:template>


<xsl:template match="LCRecordFormat">
			<xsl:text disable-output-escaping="yes">&lt;table border="1" style="border-collapse:collapse; border:1px solid black"&gt;</xsl:text>
			<tr>
				<xsl:for-each select="./*">
				
				<th class="style4bold" style="background-color:#C0C0C0; border-collapse:collapse; border:1px solid black">
					<xsl:choose>
					<xsl:when test="attribute::CAPTION">       
						<xsl:value-of select="attribute::CAPTION"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="local-name()"/>
					</xsl:otherwise>
					</xsl:choose> 
				</th>
				
				</xsl:for-each>
			</tr>
</xsl:template>


<xsl:template match="LCRecord">
<tr>
	<xsl:apply-templates/>
</tr>
</xsl:template>

<xsl:template match="*">
<td nowrap="nowrap" class="style4" style="border-collapse:collapse; border:1px solid black">	
	<xsl:for-each select="attribute::*">		
		<xsl:if test="local-name()!='CAPTION' and local-name()!='DEFAULT' and local-name()!='RAW' and local-name()!='IMAGE'"> 
			<xsl:attribute name="{local-name()}">
				<xsl:value-of select="."/>
			</xsl:attribute>
		</xsl:if>		
	</xsl:for-each>
	<xsl:choose>
	<xsl:when test="child::*">    
	<table width="100%" border="1">
		<tr>
			<xsl:for-each select="./LCRecord[position()=1]/*">
			
			<th class="style4bold" style="background-color:#C0C0C0; border-collapse:collapse; border:1px solid black" colspan="2">      
				<xsl:choose>
				<xsl:when test="attribute::CAPTION">       
					<xsl:value-of select="attribute::CAPTION"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="local-name()"/>
				</xsl:otherwise>
				</xsl:choose> 
			</th>
			
			</xsl:for-each>
		</tr>
		<xsl:apply-templates/>	
	</table>
	</xsl:when>
	<xsl:otherwise>
		<xsl:variable name="val" select="."/>
		<xsl:choose>
		<xsl:when test="$val=''">       
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$val" disable-output-escaping="yes"/>
		</xsl:otherwise>
		</xsl:choose> 
	</xsl:otherwise>
	</xsl:choose> 
</td>
</xsl:template>


</xsl:stylesheet>
