#!/bin/ksh
. ./setwsbcenv.sh

USAGE="\nUsage: enableJTA.sh database [userid password] [qualifier]"
qualifier=$1

function ErrorMessage
{
  print "$USAGE"
}

function DirectConnectWithCurrentUserid
{
  db2 connect to $1
  qualifier=$USER
  EnableJta
}

function DirectConnectWithqualifier1
{
  db2 connect to $1
  qualifier=$2
  EnableJta
}

function ConnectWithParWithUserid
{
  db2 connect to $1 user $2 using $3
  qualifier=$2
  EnableJta
}

function ConnectWithParWithqualifier2
{
  db2 connect to $1 user $2 using $3
  qualifier=$4
  EnableJta
}

function EnableJta
{
  db2 bind $DB2_HOME/bnd/@db2cli.lst
  db2 bind $DB2_HOME/bnd/@db2ubind.lst
}

# *
# * Following block is for connecting to database and setting qualifier depending 
# * on number of parameters.
# *

if [[ $# = 0 ]]
then ErrorMessage
elif [[ $# = 1 ]]
then DirectConnectWithCurrentUserid $1
elif [[ $# = 2 ]]
then DirectConnectWithQualifier1 $1 $2
elif [[ $# = 3 ]]
then ConnectWithParWithUserid $1 $2 $3
elif [[ $# = 4 ]]
then ConnectWithParWithQualifier2 $1 $2 $3 $4
elif [[ $# > 4 ]]
then ErrorMessage
fi

db2 connect reset